/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.editabletextcomponent;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.gvsig.gui.beans.editabletextcomponent.IEditableText;
import org.gvsig.gui.beans.editabletextcomponent.event.UndoRedoEditEvent;
import org.gvsig.gui.beans.editabletextcomponent.event.UndoRedoEditListener;
import org.gvsig.gui.beans.editionpopupmenu.JOptionsEditionByMousePopupMenu;

public class EditableTextDecorator
implements IEditableText {
    public static final int DEFAULT_UNDO_REDO_LIMIT_ACTIONS = 100;
    private JOptionsEditionByMousePopupMenu optionsEditionByMouse;
    private UndoManager undoManager;
    private int undoRedoLimitActions;
    protected KeyListener editorKeyListener;
    private MouseAdapter editorMouseListener;
    private PropertyChangeListener editionMenuListener;
    private EventListenerList undoRedoEditListeners;
    private JTextComponent jTextComponent;

    public EditableTextDecorator(JTextComponent jTextComponent) {
        this.jTextComponent = jTextComponent;
        this.initialize();
        this.createDefaultListeners();
        this.configure();
    }

    private void initialize() {
        this.undoRedoEditListeners = new EventListenerList();
        this.jTextComponent.setEditable(true);
        this.optionsEditionByMouse = new JOptionsEditionByMousePopupMenu();
        this.undoManager = new UndoManager();
        this.undoRedoLimitActions = 100;
        this.undoManager.setLimit(this.undoRedoLimitActions);
    }

    private void createDefaultListeners() {
        this.defineEditionMenuPropertyChangeListener();
        this.defineEditorKeyListener();
        this.defineEditorMouseListener();
    }

    private void defineEditionMenuPropertyChangeListener() {
        this.editionMenuListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                if (arg0.getPropertyName().equals("SelectedOption")) {
                    switch (Integer.parseInt(arg0.getNewValue().toString())) {
                        case 1: {
                            EditableTextDecorator.this.undoOperationLogic();
                            break;
                        }
                        case 2: {
                            EditableTextDecorator.this.redoOperationLogic();
                            break;
                        }
                        case 3: {
                            EditableTextDecorator.this.jTextComponent.cut();
                            break;
                        }
                        case 4: {
                            EditableTextDecorator.this.jTextComponent.copy();
                            break;
                        }
                        case 5: {
                            EditableTextDecorator.this.jTextComponent.paste();
                            break;
                        }
                        case 6: {
                            EditableTextDecorator.this.deleteTextLogic();
                            break;
                        }
                        case 7: {
                            EditableTextDecorator.this.jTextComponent.selectAll();
                            break;
                        }
                    }
                }
            }
        };
    }

    protected void defineEditorKeyListener() {
        this.editorKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                if (ke.isControlDown()) {
                    if (ke.getKeyCode() == 67) {
                        EditableTextDecorator.this.jTextComponent.copy();
                        ke.consume();
                        return;
                    }
                    if (ke.getKeyCode() == 88) {
                        EditableTextDecorator.this.jTextComponent.cut();
                        ke.consume();
                        return;
                    }
                    if (ke.getKeyCode() == 86) {
                        EditableTextDecorator.this.jTextComponent.paste();
                        ke.consume();
                        return;
                    }
                    if (ke.getKeyCode() == 65) {
                        EditableTextDecorator.this.jTextComponent.selectAll();
                        ke.consume();
                        return;
                    }
                    if (ke.getKeyCode() == 90) {
                        if (ke.isShiftDown()) {
                            EditableTextDecorator.this.redoOperationLogic();
                        } else {
                            EditableTextDecorator.this.undoOperationLogic();
                        }
                        ke.consume();
                        return;
                    }
                }
                switch (ke.getKeyCode()) {
                    case 127: {
                        EditableTextDecorator.this.deleteTextLogic();
                        ke.consume();
                    }
                }
            }
        };
    }

    private void defineEditorMouseListener() {
        this.editorMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    EditableTextDecorator.this.optionsEditionByMouse.setEnabledAllOptions(false);
                    if (EditableTextDecorator.this.undoManager.canUndo()) {
                        EditableTextDecorator.this.optionsEditionByMouse.setEnabledUndoOption(true);
                    }
                    if (EditableTextDecorator.this.undoManager.canRedo()) {
                        EditableTextDecorator.this.optionsEditionByMouse.setEnabledRedoOption(true);
                    }
                    if (EditableTextDecorator.this.jTextComponent.getCaretPosition() != EditableTextDecorator.this.jTextComponent.getCaret().getMark()) {
                        EditableTextDecorator.this.optionsEditionByMouse.setEnabledCopyOption(true);
                        EditableTextDecorator.this.optionsEditionByMouse.setEnabledCutOption(true);
                        EditableTextDecorator.this.optionsEditionByMouse.setEnabledDeleteOption(true);
                    }
                    if (EditableTextDecorator.this.jTextComponent.getToolkit().getSystemClipboard().getContents(this).toString().length() > 0) {
                        EditableTextDecorator.this.optionsEditionByMouse.setEnabledPasteOption(true);
                    }
                    EditableTextDecorator.this.optionsEditionByMouse.setEnabledSelectAllOption(true);
                    EditableTextDecorator.this.optionsEditionByMouse.setLocation((int)EditableTextDecorator.this.jTextComponent.getLocationOnScreen().getX() + e.getX(), (int)EditableTextDecorator.this.jTextComponent.getLocationOnScreen().getY() + e.getY());
                    EditableTextDecorator.this.optionsEditionByMouse.setInvoker(EditableTextDecorator.this.jTextComponent);
                    EditableTextDecorator.this.optionsEditionByMouse.setVisible(true);
                }
            }
        };
    }

    private void configure() {
        PlainDocument document = this.configureDocument();
        this.configureEditor(document);
        this.configureOptionsEditionByMouse();
    }

    private PlainDocument configureDocument() {
        PlainDocument document = new PlainDocument();
        this.configureUndoManager(document);
        return document;
    }

    private void configureEditor(PlainDocument document) {
        if (this.jTextComponent != null) {
            this.jTextComponent.removeKeyListener(this.editorKeyListener);
            this.jTextComponent.addKeyListener(this.editorKeyListener);
            this.jTextComponent.removeMouseListener(this.editorMouseListener);
            this.jTextComponent.addMouseListener(this.editorMouseListener);
            this.jTextComponent.setDocument(document);
        }
    }

    private void configureOptionsEditionByMouse() {
        this.optionsEditionByMouse.addPropertyChangeListener(this.editionMenuListener);
    }

    private void configureUndoManager(PlainDocument document) {
        document.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                EditableTextDecorator.this.undoManager.addEdit(evt.getEdit());
            }
        });
    }

    private void undoOperationLogic() {
        try {
            if (this.undoManager.canUndo()) {
                String previousText = this.jTextComponent.getText();
                this.undoManager.undo();
                String newText = this.jTextComponent.getText();
                this.fireUndoRedoEditUpdate(new UndoRedoEditEvent(this.jTextComponent, 0, previousText, newText));
            }
        }
        catch (CannotUndoException e) {
            e.printStackTrace();
        }
    }

    private void redoOperationLogic() {
        try {
            if (this.undoManager.canRedo()) {
                String previousText = this.jTextComponent.getText();
                this.undoManager.redo();
                String newText = this.jTextComponent.getText();
                this.fireUndoRedoEditUpdate(new UndoRedoEditEvent(this.jTextComponent, 1, previousText, newText));
            }
        }
        catch (CannotRedoException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setUndoRedoLimitActions(int limit) {
        this.undoRedoLimitActions = limit;
        this.undoManager.setLimit(this.undoRedoLimitActions);
    }

    @Override
    public int getUndoRedoLimitActions() {
        return this.undoRedoLimitActions;
    }

    private void deleteTextLogic() {
        try {
            PlainDocument document = (PlainDocument)this.jTextComponent.getDocument();
            int caretPosition = this.jTextComponent.getCaretPosition();
            int markPosition = this.jTextComponent.getCaret().getMark();
            int min_index = Math.min(caretPosition, markPosition);
            int length = Math.abs(caretPosition - markPosition);
            document.remove(min_index, length);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addUndoRedoEditListener(UndoRedoEditListener listener) {
        this.undoRedoEditListeners.add(UndoRedoEditListener.class, listener);
    }

    @Override
    public void removeUndoRedoEditListener(UndoRedoEditListener listener) {
        this.undoRedoEditListeners.remove(UndoRedoEditListener.class, listener);
    }

    @Override
    public UndoRedoEditListener[] getUndoRedoEditListeners() {
        return (UndoRedoEditListener[])this.undoRedoEditListeners.getListeners(UndoRedoEditListener.class);
    }

    protected void fireUndoRedoEditUpdate(UndoRedoEditEvent e) {
        Object[] listeners = this.undoRedoEditListeners.getListenerList();
        if (listeners != null) {
            for (int i = 1; i < listeners.length; i += 2) {
                if (!(listeners[i] instanceof UndoRedoEditListener)) continue;
                ((UndoRedoEditListener)listeners[i]).operationExecuted(e);
            }
        }
    }
}

