/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.listview;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.gvsig.gui.beans.listview.IListViewPainter;
import org.gvsig.gui.beans.listview.ListViewItem;
import org.gvsig.gui.beans.listview.ListViewListener;
import org.gvsig.gui.beans.listview.painters.LargeIcon;
import org.gvsig.gui.beans.listview.painters.PaintList;
import org.gvsig.gui.beans.listview.painters.SmallIcon;
import org.gvsig.i18n.Messages;

public class ListViewComponent
extends JComponent
implements MouseListener,
MouseMotionListener,
ActionListener,
KeyListener,
FocusListener,
AncestorListener {
    private static final long serialVersionUID = 6177600314634665863L;
    private ArrayList<IListViewPainter> painters = new ArrayList();
    private ArrayList<JRadioButtonMenuItem> paintersMenu = new ArrayList();
    private ArrayList<ListViewItem> items = new ArrayList();
    private int view = 0;
    private boolean multiSelect = false;
    private Image image = null;
    private int width = 0;
    private int height = 0;
    private Graphics2D widgetGraphics = null;
    private JMenu jMenu = null;
    private ButtonGroup buttonGroup = null;
    private JPopupMenu jPopupMenu = null;
    private JTextField jRenameEdit = null;
    private int itemEdited = -1;
    private int lastSelected = -1;
    private int cursorPos = -1;
    private boolean editable = false;
    private ArrayList<ListViewListener> actionCommandListeners = new ArrayList();
    private ListViewItem lastSelectedItem = null;

    public ListViewComponent() {
        this.setFocusable(true);
        this.initialize();
    }

    private void initialize() {
        this.addListViewPainter(new PaintList(this.items));
        this.addListViewPainter(new SmallIcon(this.items));
        this.addListViewPainter(new LargeIcon(this.items));
        this.addAncestorListener(this);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public int getView() {
        return this.view;
    }

    public void setView(int view) {
        this.view = view;
    }

    public void addListViewPainter(IListViewPainter item) {
        this.painters.add(item);
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.getButtonGroup().add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.setText(item.getName());
        if (this.paintersMenu.size() == 0) {
            jRadioButtonMenuItem.setSelected(true);
        }
        this.getJMenu().add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.addActionListener(this);
        this.paintersMenu.add(jRadioButtonMenuItem);
    }

    public void sort() {
        Object[] list = this.items.toArray();
        Arrays.sort(list);
        this.items.clear();
        for (int i = 0; i < list.length; ++i) {
            this.items.add((ListViewItem)list[i]);
        }
    }

    public void addItem(ListViewItem item) {
        this.addItem(item, false);
    }

    public void addItem(ListViewItem item, boolean acceptRepeatNames) {
        this.items.add(item);
        if (!acceptRepeatNames) {
            this.changeName(item.getName(), this.items.size() - 1);
        }
        this.viewItem(this.items.size() - 1);
    }

    public void addItem(int pos, ListViewItem item) {
        this.items.add(pos, item);
        this.changeName(item.getName(), pos);
        this.viewItem(pos);
    }

    public void removeItem(int index) {
        this.items.remove(index);
        this.repaint();
    }

    public void removeSelecteds() {
        for (int i = this.items.size() - 1; i >= 0; --i) {
            if (!this.items.get(i).isSelected()) continue;
            this.items.remove(i);
        }
        this.repaint();
    }

    public ArrayList getItems() {
        return this.items;
    }

    private Graphics2D getWidgetGraphics() {
        this.getWidgetImage();
        return this.widgetGraphics;
    }

    private Image getWidgetImage() {
        int width2 = this.getVisibleRect().width;
        int height2 = this.getVisibleRect().height;
        if (width2 <= 0) {
            width2 = 1;
        }
        if (height2 <= 0) {
            height2 = 1;
        }
        if (this.width != width2 || this.height != height2) {
            this.image = this.createImage(width2, height2);
            if (this.image == null) {
                return null;
            }
            this.widgetGraphics = (Graphics2D)this.image.getGraphics();
        }
        this.width = width2;
        this.height = height2;
        return this.image;
    }

    private void redrawBuffer() {
        if (this.getWidgetGraphics() == null) {
            return;
        }
        this.getWidgetGraphics().setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.getWidgetGraphics().setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.getWidgetGraphics().setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        this.getWidgetGraphics().setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        this.getWidgetGraphics().setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        this.getWidgetGraphics().setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        this.getWidgetGraphics().translate(-this.getVisibleRect().x, -this.getVisibleRect().y);
        this.getWidgetGraphics().setColor(Color.white);
        this.getWidgetGraphics().fillRect(this.getVisibleRect().x, this.getVisibleRect().y, this.getVisibleRect().width, this.getVisibleRect().height);
        this.painters.get(this.view).paint(this.getWidgetGraphics(), this.getVisibleRect());
        this.getWidgetGraphics().translate(this.getVisibleRect().x, this.getVisibleRect().y);
    }

    @Override
    public void paint(Graphics g) {
        JViewport jViewport;
        Dimension aux;
        Dimension size;
        this.redrawBuffer();
        if (this.image != null) {
            if (this.isEnabled()) {
                g.drawImage(this.image, this.getVisibleRect().x, this.getVisibleRect().y, this);
            } else {
                BufferedImage bi = new BufferedImage(this.width, this.height, 1);
                Graphics2D big = bi.createGraphics();
                big.drawImage(this.image, 0, 0, this);
                ColorConvertOp colorConvert = new ColorConvertOp(ColorSpace.getInstance(1003), null);
                colorConvert.filter(bi, bi);
                big.setColor(new Color(255, 255, 255, 164));
                big.fillRect(0, 0, this.width, this.height);
                g.drawImage(bi, this.getVisibleRect().x, this.getVisibleRect().y, this);
            }
        }
        if (!(size = this.getPreferredSize()).equals(aux = this.painters.get(this.view).getPreferredSize())) {
            this.setPreferredSize(aux);
            this.setSize(aux);
        }
        if (this.getParent() instanceof JViewport && (jViewport = (JViewport)this.getParent()).getParent() instanceof JScrollPane && this.items.size() > 0) {
            ((JScrollPane)jViewport.getParent()).getVerticalScrollBar().setUnitIncrement(this.items.get((int)0).getItemRectangle().height);
        }
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public void setMultiSelect(boolean multiSelect) {
        if (!multiSelect) {
            for (int i = 0; i < this.items.size(); ++i) {
                this.items.get(i).setSelected(false);
            }
            if (this.lastSelected != -1 && this.lastSelected < this.items.size()) {
                this.items.get(this.lastSelected).setSelected(true);
            }
        }
        this.multiSelect = multiSelect;
        this.repaint();
    }

    private int getItem(int x, int y) {
        Point point = new Point(x, y);
        Rectangle rectangle = null;
        for (int i = 0; i < this.items.size(); ++i) {
            rectangle = this.items.get(i).getItemRectangle();
            if (rectangle == null || !rectangle.getBounds().contains(point)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.requestFocus();
        try {
            if ((e.getModifiers() & 0x10) != 16) {
                return;
            }
            this.cursorPos = this.getItem(e.getX(), e.getY());
            this.viewItem(this.cursorPos);
            if (this.cursorPos == -1) {
                return;
            }
            if (this.isMultiSelect()) {
                if ((e.getModifiers() & 1) == 1) {
                    int i;
                    int pos2 = this.lastSelected;
                    int pos1 = this.cursorPos;
                    if (pos2 < pos1) {
                        pos1 = this.lastSelected;
                        pos2 = this.cursorPos;
                    }
                    if ((e.getModifiers() & 2) != 2) {
                        for (i = 0; i < this.items.size(); ++i) {
                            this.items.get(i).setSelected(false);
                        }
                    }
                    for (i = pos1; i <= pos2; ++i) {
                        this.items.get(i).setSelected(true);
                    }
                    return;
                }
                this.lastSelected = this.cursorPos;
                if ((e.getModifiers() & 2) == 2) {
                    this.items.get(this.cursorPos).setSelected(!this.items.get(this.cursorPos).isSelected());
                    return;
                }
                for (int i = 0; i < this.items.size(); ++i) {
                    this.items.get(i).setSelected(false);
                }
                this.items.get(this.cursorPos).setSelected(true);
            } else {
                boolean selected = true;
                this.lastSelected = this.cursorPos;
                if ((e.getModifiers() & 2) == 2) {
                    selected = !this.items.get(this.cursorPos).isSelected();
                }
                for (int i = 0; i < this.items.size(); ++i) {
                    this.items.get(i).setSelected(false);
                }
                this.items.get(this.cursorPos).setSelected(selected);
            }
        }
        finally {
            this.repaint();
        }
    }

    private void viewItem(int pos) {
        JViewport jViewport;
        if (pos == -1 || this.items.size() == 0) {
            return;
        }
        this.redrawBuffer();
        Dimension aux = this.painters.get(this.view).getPreferredSize();
        this.setPreferredSize(aux);
        this.setSize(aux);
        if (pos < 0) {
            pos = 0;
        }
        if (pos >= this.items.size()) {
            pos = this.items.size() - 1;
        }
        if (this.getParent() instanceof JViewport && (jViewport = (JViewport)this.getParent()).getParent() instanceof JScrollPane) {
            ListViewItem lvi = this.items.get(pos);
            Rectangle rectangle = (Rectangle)lvi.getItemRectangle().clone();
            if (rectangle == null) {
                return;
            }
            rectangle.setLocation((int)rectangle.getX() - this.getVisibleRect().x, (int)rectangle.getY() - this.getVisibleRect().y);
            jViewport.scrollRectToVisible(rectangle);
            ((JScrollPane)jViewport.getParent()).getVerticalScrollBar().paintImmediately(((JScrollPane)jViewport.getParent()).getVerticalScrollBar().getVisibleRect());
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int itemSelected;
        if (!this.isEnabled()) {
            return;
        }
        if ((e.getModifiers() & 0x10) != 16) {
            return;
        }
        if (this.isMultiSelect()) {
            if ((e.getModifiers() & 1) == 1) {
                return;
            }
            if ((e.getModifiers() & 2) == 2) {
                return;
            }
        }
        if ((itemSelected = this.getItem(e.getX(), e.getY())) == -1) {
            return;
        }
        this.lastSelected = itemSelected;
        this.cursorPos = itemSelected;
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get(i).setSelected(false);
        }
        this.items.get(itemSelected).setSelected(true);
        this.repaint();
        this.viewItem(itemSelected);
    }

    private JPopupMenu getPopupMenu() {
        if (this.jPopupMenu == null) {
            this.jPopupMenu = new JPopupMenu();
            this.getJMenu().setText(Messages.getText((String)"view"));
            this.jPopupMenu.add(this.getJMenu());
        }
        return this.jPopupMenu;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if ((e.getModifiers() & 4) == 4) {
            this.getPopupMenu().show(this, e.getX(), e.getY());
        }
        if ((e.getModifiers() & 0x10) == 16) {
            this.fireSelectionValueChanged();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        int itemSelected = this.getItem(e.getX(), e.getY());
        if (itemSelected == -1) {
            this.setToolTipText(null);
            return;
        }
        if (this.items.get(itemSelected).isShowTooltip()) {
            this.setToolTipText(this.items.get(itemSelected).getName());
        } else {
            this.setToolTipText(null);
        }
    }

    private ButtonGroup getButtonGroup() {
        if (this.buttonGroup == null) {
            this.buttonGroup = new ButtonGroup();
        }
        return this.buttonGroup;
    }

    private JMenu getJMenu() {
        if (this.jMenu == null) {
            this.jMenu = new JMenu();
        }
        return this.jMenu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int pos;
        this.view = pos = this.paintersMenu.indexOf(e.getSource());
        this.viewItem(this.cursorPos);
    }

    public ListViewItem[] getSelectedValues() {
        int cont = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).isSelected()) continue;
            ++cont;
        }
        ListViewItem[] values = new ListViewItem[cont];
        cont = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).isSelected()) continue;
            values[cont] = this.items.get(i);
            ++cont;
        }
        return values;
    }

    public int getSelectedIndex() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).isSelected()) continue;
            return i;
        }
        return -1;
    }

    public void setSelectedIndex(int value) {
        if (value < 0) {
            value = 0;
        }
        if (value >= this.items.size()) {
            value = this.items.size() - 1;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get(i).setSelected(i == value);
        }
        this.lastSelectedItem = this.getSelectedValue();
        this.viewItem(value);
        this.update(this.getGraphics());
    }

    public ListViewItem getSelectedValue() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).isSelected()) continue;
            return this.items.get(i);
        }
        return null;
    }

    public int[] getSelectedIndices() {
        int cont = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).isSelected()) continue;
            ++cont;
        }
        int[] values = new int[cont];
        cont = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).isSelected()) continue;
            values[cont] = i;
            ++cont;
        }
        return values;
    }

    public void addListSelectionListener(ListViewListener listener) {
        if (!this.actionCommandListeners.contains(listener)) {
            this.actionCommandListeners.add(listener);
        }
    }

    public void removeListSelectionListener(ListViewListener listener) {
        this.actionCommandListeners.remove(listener);
    }

    private void fireSelectionValueChanged() {
        this.lastSelectedItem = this.getSelectedValue();
        Iterator<ListViewListener> acIterator = this.actionCommandListeners.iterator();
        EventObject e = null;
        while (acIterator.hasNext()) {
            ListViewListener listener = acIterator.next();
            if (e == null) {
                e = new EventObject(this);
            }
            listener.actionValueChanged(e);
        }
    }

    private void fireItemNameChanged(String oldName, ListViewItem item) {
        Iterator<ListViewListener> acIterator = this.actionCommandListeners.iterator();
        EventObject e = null;
        while (acIterator.hasNext()) {
            ListViewListener listener = acIterator.next();
            if (e == null) {
                e = new EventObject(this);
            }
            listener.actionItemNameChanged(e, oldName, item);
        }
    }

    public void renameItem(int item) {
        Rectangle rectangle;
        if (!this.isEditable()) {
            return;
        }
        if (item >= 0 && item < this.items.size() && this.items.get(item).isSelected() && (rectangle = this.items.get(item).getNameRectangle()) != null) {
            this.itemEdited = item;
            this.items.get(this.itemEdited).setSelected(false);
            this.repaint();
            this.setLayout(null);
            this.getJRenameEdit().setText(this.items.get(item).getName());
            this.add(this.getJRenameEdit());
            this.getJRenameEdit().setBounds(rectangle);
            this.getJRenameEdit().addFocusListener(this);
            this.getJRenameEdit().addKeyListener(this);
            this.getJRenameEdit().requestFocus();
            this.getJRenameEdit().setSelectionStart(0);
            this.getJRenameEdit().setSelectionEnd(this.getJRenameEdit().getText().length());
        }
    }

    public JTextField getJRenameEdit() {
        if (this.jRenameEdit == null) {
            this.jRenameEdit = new JTextField();
        }
        return this.jRenameEdit;
    }

    public void changeName(String newName, int pos) {
        boolean isItem;
        if ((newName = newName.trim()).length() == 0) {
            return;
        }
        String newNameAux = newName;
        int newNumber = 0;
        block0: do {
            isItem = false;
            for (int i = 0; i < this.items.size(); ++i) {
                if (i == pos || !this.items.get(i).getName().equals(newNameAux)) continue;
                isItem = true;
                newNameAux = newName + "_" + ++newNumber;
                continue block0;
            }
        } while (isItem);
        this.items.get(pos).setName(newNameAux);
    }

    public void closeRenameEdit() {
        if (this.jRenameEdit == null) {
            return;
        }
        if (this.itemEdited != -1) {
            String oldName = this.items.get(this.itemEdited).getName();
            this.changeName(this.getJRenameEdit().getText(), this.itemEdited);
            this.fireItemNameChanged(oldName, this.items.get(this.itemEdited));
            this.items.get(this.cursorPos).setSelected(true);
            this.itemEdited = -1;
            this.repaint();
        }
        this.remove(this.getJRenameEdit());
        this.jRenameEdit = null;
        this.requestFocus();
    }

    private void moveDown() {
        int selItem = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.cursorPos == i || this.items.get((int)i).getItemRectangle().y < this.items.get((int)this.cursorPos).getItemRectangle().y + this.items.get((int)this.cursorPos).getItemRectangle().height || this.items.get((int)i).getItemRectangle().x != this.items.get((int)this.cursorPos).getItemRectangle().x) continue;
            selItem = i;
            break;
        }
        if (selItem != -1) {
            this.cursorPos = selItem;
            this.setSelectedIndex(selItem);
        }
    }

    private void moveLeft() {
        int selItem = -1;
        for (int i = this.items.size() - 1; i >= 0; --i) {
            if (this.cursorPos == i || this.items.get((int)i).getItemRectangle().x + this.items.get((int)i).getItemRectangle().width > this.items.get((int)this.cursorPos).getItemRectangle().x || this.items.get((int)i).getItemRectangle().y != this.items.get((int)this.cursorPos).getItemRectangle().y) continue;
            selItem = i;
            break;
        }
        if (selItem != -1) {
            this.cursorPos = selItem;
            this.setSelectedIndex(selItem);
        }
    }

    private void moveRight() {
        int selItem = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.cursorPos == i || this.items.get((int)i).getItemRectangle().x < this.items.get((int)this.cursorPos).getItemRectangle().x + this.items.get((int)this.cursorPos).getItemRectangle().width || this.items.get((int)i).getItemRectangle().y != this.items.get((int)this.cursorPos).getItemRectangle().y) continue;
            selItem = i;
            break;
        }
        if (selItem != -1) {
            this.cursorPos = selItem;
            this.setSelectedIndex(selItem);
        }
    }

    private void moveUp() {
        int selItem = -1;
        for (int i = this.items.size() - 1; i >= 0; --i) {
            if (this.cursorPos == i || this.items.get((int)i).getItemRectangle().y + this.items.get((int)i).getItemRectangle().height > this.items.get((int)this.cursorPos).getItemRectangle().y || this.items.get((int)i).getItemRectangle().x != this.items.get((int)this.cursorPos).getItemRectangle().x) continue;
            selItem = i;
            break;
        }
        if (selItem != -1) {
            this.cursorPos = selItem;
            this.setSelectedIndex(selItem);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getSource() == this) {
            switch (e.getKeyCode()) {
                case 113: {
                    this.renameItem(this.cursorPos);
                    break;
                }
                case 40: {
                    this.moveDown();
                    break;
                }
                case 37: {
                    this.moveLeft();
                    break;
                }
                case 39: {
                    this.moveRight();
                    break;
                }
                case 38: {
                    this.moveUp();
                    break;
                }
                case 36: {
                    this.cursorPos = 0;
                    this.setSelectedIndex(this.cursorPos);
                    break;
                }
                case 35: {
                    this.cursorPos = this.items.size() - 1;
                    this.setSelectedIndex(this.cursorPos);
                    break;
                }
                case 33: {
                    if (this.items.size() <= 0) break;
                    int cont = (int)Math.floor(this.getVisibleRect().getHeight() / (double)this.items.get((int)0).getItemRectangle().height);
                    for (int i = 0; i < cont; ++i) {
                        this.moveUp();
                    }
                    break;
                }
                case 34: {
                    if (this.items.size() <= 0) break;
                    int cont = (int)Math.floor(this.getVisibleRect().getHeight() / (double)this.items.get((int)0).getItemRectangle().height);
                    for (int i = 0; i < cont; ++i) {
                        this.moveDown();
                    }
                    break;
                }
            }
            return;
        }
        if (e.getSource() == this.getJRenameEdit()) {
            switch (e.getKeyCode()) {
                case 27: {
                    this.getJRenameEdit().setText(this.items.get(this.itemEdited).getName());
                    this.closeRenameEdit();
                    break;
                }
                case 10: {
                    this.closeRenameEdit();
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this) {
            switch (e.getKeyCode()) {
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    this.fireSelectionValueChanged();
                }
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.closeRenameEdit();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (e.getSource() == this && e.getClickCount() == 2) {
            this.renameItem(this.cursorPos);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        JViewport jViewport;
        if (this.getParent() instanceof JViewport && (jViewport = (JViewport)this.getParent()).getParent() instanceof JScrollPane) {
            ((JScrollPane)jViewport.getParent()).setActionMap(null);
        }
    }

    public ListViewItem getLastSelectedItem() {
        return this.lastSelectedItem;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.update(this.getGraphics());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }
}

