/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.listview.painters;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import org.gvsig.gui.beans.listview.IListViewPainter;
import org.gvsig.gui.beans.listview.ListViewItem;
import org.gvsig.i18n.Messages;

public class SmallIcon
implements IListViewPainter {
    ArrayList items = null;
    int iconsWidth = 40;
    int minIconsWidth = 40;
    int iconsHeight = 28;
    Dimension lastDimension = new Dimension(0, 0);
    int cols = 0;

    public SmallIcon(ArrayList items) {
        this.items = items;
    }

    @Override
    public String getName() {
        return Messages.getText((String)"smallIcon");
    }

    @Override
    public Dimension getPreferredSize() {
        return this.lastDimension;
    }

    @Override
    public void paint(Graphics2D g, Rectangle visibleRect) {
        int aux = (int)Math.floor(visibleRect.getWidth() / (double)(this.minIconsWidth + 2));
        if (aux > this.items.size()) {
            aux = this.items.size();
        }
        this.iconsWidth = (int)(Math.floor(visibleRect.getWidth() / (double)aux) - 2.0);
        int height2 = 0;
        int posX = 0;
        int posY = 0;
        this.cols = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            ((ListViewItem)this.items.get(i)).setNameRectangle(null);
            ((ListViewItem)this.items.get(i)).setShowTooltip(true);
            if (posX != 0 && (double)((posX + 1) * (this.iconsWidth + 2)) > visibleRect.getWidth()) {
                posX = 0;
                ++posY;
            }
            ((ListViewItem)this.items.get(i)).getItemRectangle().setBounds(posX * (this.iconsWidth + 2), posY * (this.iconsHeight + 2), this.iconsWidth + 2, this.iconsHeight + 2);
            if (((ListViewItem)this.items.get(i)).getItemRectangle().intersects(visibleRect)) {
                if (((ListViewItem)this.items.get(i)).isSelected()) {
                    g.setColor(new Color(49, 106, 197));
                    g.fillRect(posX * (this.iconsWidth + 2), posY * (this.iconsHeight + 2), this.iconsWidth + 2, this.iconsHeight + 2);
                }
                Shape clip = g.getClip();
                g.translate(posX * (this.iconsWidth + 2) + 1, posY * (this.iconsHeight + 2) + 1);
                g.setClip(0, 0, this.iconsWidth, this.iconsHeight);
                if (((ListViewItem)this.items.get(i)).getIcon() != null) {
                    ((ListViewItem)this.items.get(i)).getIcon().paint(g, ((ListViewItem)this.items.get(i)).isSelected());
                }
                g.setClip(clip);
                g.translate(-(posX * (this.iconsWidth + 2) + 1), -(posY * (this.iconsHeight + 2) + 1));
            }
            if (height2 < (posY + 1) * (this.iconsHeight + 2)) {
                height2 = (posY + 1) * (this.iconsHeight + 2);
            }
            if (this.cols < posX) {
                this.cols = posX;
            }
            ++posX;
        }
        this.lastDimension = new Dimension(this.minIconsWidth + 2, height2);
    }
}

