/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.openfile;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gvsig.gui.beans.Messages;
import org.gvsig.gui.beans.openfile.listeners.OpenFileListener;

public class OpenFileContainer
extends JPanel {
    private static final long serialVersionUID = 5823371652872582451L;
    private int wComp = 500;
    private int hComp = 55;
    private int wButton = 165;
    private int wText = (int)Math.floor(0.63 * (double)this.wComp);
    private int hButton = 22;
    private boolean border = true;
    private JButton jButton = null;
    private JTextField tOpen = null;
    private OpenFileListener listener = null;
    private boolean isButtonVisible = true;

    public OpenFileContainer() {
        this.listener = new OpenFileListener(this);
        this.initialize();
        this.listener.setButton(this.getJButton());
    }

    public OpenFileContainer(boolean border) {
        this.border = border;
        this.listener = new OpenFileListener(this);
        this.initialize();
        this.listener.setButton(this.getJButton());
    }

    public OpenFileContainer(int WIDTH, int HEIGHT, boolean isButtonVisible) {
        this.isButtonVisible = isButtonVisible;
        this.wComp = WIDTH;
        this.hComp = HEIGHT;
        this.listener = new OpenFileListener(this);
        this.initialize();
        this.listener.setButton(this.getJButton());
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 10.0;
        gridBagConstraints1.insets = new Insets(0, 2, 0, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(500, 50));
        if (this.border) {
            this.setBorder(BorderFactory.createTitledBorder(null, Messages.getText("open_file"), 0, 0, null, null));
        }
        this.add((Component)this.getJButton(), gridBagConstraints);
        this.add((Component)this.getTOpen(), gridBagConstraints1);
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setPreferredSize(new Dimension(this.wButton, this.hButton));
            this.jButton.addActionListener(this.listener);
            this.jButton.setSize(this.wButton, this.hButton);
            this.jButton.setText(Messages.getText("abrir..."));
            this.jButton.setVisible(this.isButtonVisible);
            this.getTOpen().setEnabled(this.isButtonVisible);
        }
        return this.jButton;
    }

    public JTextField getTOpen() {
        if (this.tOpen == null) {
            this.tOpen = new JTextField();
            if (this.isButtonVisible) {
                this.tOpen.setPreferredSize(new Dimension(this.wText, this.hButton));
            } else {
                this.tOpen.setPreferredSize(new Dimension((int)Math.floor((double)this.wComp * 0.95), this.hButton));
            }
        }
        return this.tOpen;
    }

    public void setComponentSize(int w, int h) {
        this.wComp = w;
        this.hComp = 55;
        this.wText = (int)Math.floor(0.63 * (double)this.wComp);
        this.setPreferredSize(new Dimension(this.wComp, this.hComp));
        if (this.isButtonVisible) {
            this.getTOpen().setPreferredSize(new Dimension(this.wText, this.hButton));
        } else {
            this.getTOpen().setPreferredSize(new Dimension((int)Math.floor((double)this.wComp * 0.95), this.hButton));
        }
    }

    public File getFile() {
        File fil = null;
        if (this.getTOpen().getText() != "") {
            try {
                fil = new File(this.getTOpen().getText());
            }
            catch (Exception exc) {
                System.err.println("Ruta o archivo no v\u00e1lido");
            }
        }
        return fil;
    }
}

