/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.panelGroup.treePanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ContainerEvent;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gvsig.gui.beans.panelGroup.AbstractPanelGroup;
import org.gvsig.gui.beans.panelGroup.PanelGroupManager;
import org.gvsig.gui.beans.panelGroup.panels.AbstractPanel;
import org.gvsig.gui.beans.panelGroup.panels.IPanel;
import org.gvsig.gui.beans.panelGroup.tabbedPanel.TabbedPanel;

public class TreePanel
extends AbstractPanelGroup
implements Serializable {
    private static final long serialVersionUID = 2350636078676872309L;
    private JSplitPane jSplitPane = null;
    private JTree jTree = null;
    private JScrollPane treeJScrollPane = null;
    private DefaultMutableTreeNode rootNode = null;
    private DefaultTreeModel treeModel = null;
    private AbstractPanel defaultPanel = null;
    private final String rootNodeName = "";
    private final short DEFAULT_DIVIDER_WIDTH = (short)5;
    private DefaultMutableTreeNode lastNode = null;
    private int currentDividerLocation;
    private int panelsInGUICount;

    public TreePanel(Object reference) {
        super(reference);
        this.initialize();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.currentDividerLocation = -1;
        this.panelsInGUICount = 0;
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJSplitPane(), "Center");
    }

    protected JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane(1);
            this.jSplitPane.setDividerSize(5);
            this.jSplitPane.setLeftComponent(this.getTreeJScrollPane());
            this.jSplitPane.setRightComponent(this.getDefaultPanel());
            this.jSplitPane.setOneTouchExpandable(true);
            this.jSplitPane.setDividerLocation(180);
        }
        return this.jSplitPane;
    }

    protected AbstractPanel getDefaultPanel() {
        if (this.defaultPanel == null) {
            this.defaultPanel = new DefaultPanel();
        }
        return this.defaultPanel;
    }

    protected JTree getJTree() {
        if (this.jTree == null) {
            this.jTree = new JTree(this.getTreeModel());
            this.jTree.getSelectionModel().setSelectionMode(1);
            DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
            defaultTreeCellRenderer.setOpenIcon(null);
            defaultTreeCellRenderer.setClosedIcon(null);
            defaultTreeCellRenderer.setLeafIcon(null);
            ImageIcon treeCellRendererIcon = new ImageIcon(TreePanel.class.getResource("images/treenodecollapsibleicon.png"), null);
            defaultTreeCellRenderer.setOpenIcon(treeCellRendererIcon);
            treeCellRendererIcon = new ImageIcon(TreePanel.class.getResource("images/treenodeexpandableicon.png"), null);
            defaultTreeCellRenderer.setClosedIcon(treeCellRendererIcon);
            this.jTree.setRootVisible(false);
            this.jTree.setCellRenderer(defaultTreeCellRenderer);
            this.jTree.getModel().addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                    TreePath rootNodePath = new TreePath(TreePanel.this.getRootNode());
                    if (TreePanel.this.jTree.isCollapsed(rootNodePath)) {
                        TreePanel.this.jTree.expandPath(rootNodePath);
                    }
                    if (TreePanel.this.lastNode.getUserObject() instanceof IPanel) {
                        TreePanel.this.dispatchEvent(new ContainerEvent(TreePanel.this.jTree, 300, (Component)TreePanel.this.lastNode.getUserObject()));
                    }
                    TreePanel.this.lastNode = null;
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                    TreePath rootNodePath = new TreePath(TreePanel.this.getRootNode());
                    if (TreePanel.this.jTree.isCollapsed(rootNodePath)) {
                        TreePanel.this.jTree.expandPath(rootNodePath);
                    }
                    if (TreePanel.this.lastNode.getUserObject() instanceof IPanel) {
                        TreePanel.this.dispatchEvent(new ContainerEvent(TreePanel.this.jTree, 301, (Component)TreePanel.this.lastNode.getUserObject()));
                    }
                    TreePanel.this.lastNode = null;
                }

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                }
            });
            this.jTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)TreePanel.this.jTree.getLastSelectedPathComponent();
                    if (node == null) {
                        return;
                    }
                    Object object = node.getUserObject();
                    if (object != null && object instanceof AbstractPanel) {
                        TreePanel.this.getJSplitPane().setRightComponent((Component)object);
                        TreePanel.this.stateChanged(new ChangeEvent(object));
                        TreePanel.this.getJSplitPane().setDividerLocation(TreePanel.this.currentDividerLocation);
                    }
                }
            });
        }
        return this.jTree;
    }

    protected DefaultTreeModel getTreeModel() {
        if (this.treeModel == null) {
            this.treeModel = new DefaultTreeModel(this.getRootNode());
        }
        return this.treeModel;
    }

    protected DefaultMutableTreeNode getRootNode() {
        if (this.rootNode == null) {
            this.rootNode = new DefaultMutableTreeNode("");
        }
        return this.rootNode;
    }

    protected JScrollPane getTreeJScrollPane() {
        if (this.treeJScrollPane == null) {
            this.treeJScrollPane = new JScrollPane();
            this.treeJScrollPane.setViewportView(this.getJTree());
        }
        return this.treeJScrollPane;
    }

    @Override
    protected void loadPanel(IPanel panel) {
        super.loadPanel(panel);
        AbstractPanel panel_obj = (AbstractPanel)panel;
        if (panel_obj.isVisible()) {
            this.addPanelImpl(panel);
            Dimension panelPreferredSize = panel_obj.getPreferredSize();
            Dimension rightPanelPreferredSize = this.getJSplitPane().getRightComponent().getPreferredSize();
            if (panelPreferredSize.width > rightPanelPreferredSize.width || panelPreferredSize.height > rightPanelPreferredSize.height) {
                this.getJSplitPane().getRightComponent().setPreferredSize(new Dimension(Math.max(panelPreferredSize.width, rightPanelPreferredSize.width), Math.max(panelPreferredSize.height, rightPanelPreferredSize.height)));
            }
        }
    }

    protected void addPanelImpl(IPanel panel) {
        if (this.belongsThisGroup(panel)) {
            DefaultMutableTreeNode parent;
            DefaultMutableTreeNode new_node;
            if (panel.getLabel() == null) {
                return;
            }
            this.lastNode = new_node = new DefaultMutableTreeNode(panel);
            if (panel.getLabelGroup() == null) {
                this.getTreeModel().insertNodeInto(new_node, this.getRootNode(), this.getRootNode().getChildCount());
                ++this.panelsInGUICount;
                return;
            }
            for (int i = 0; i < this.getRootNode().getChildCount(); i = (int)((short)(i + 1))) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getRootNode().getChildAt(i);
                if (!node.getUserObject().toString().equals(panel.getLabelGroup())) continue;
                this.getTreeModel().insertNodeInto(new_node, node, node.getChildCount());
                ++this.panelsInGUICount;
                return;
            }
            this.lastNode = parent = new DefaultMutableTreeNode(panel.getLabelGroup());
            this.getTreeModel().insertNodeInto(parent, this.getRootNode(), this.getRootNode().getChildCount());
            this.lastNode = new_node;
            this.getTreeModel().insertNodeInto(new_node, parent, 0);
            ++this.panelsInGUICount;
        }
    }

    protected void addPanelSortOrdered(IPanel panel) {
        if (this.belongsThisGroup(panel)) {
            DefaultMutableTreeNode parent;
            DefaultMutableTreeNode new_node;
            if (panel.getLabel() == null) {
                return;
            }
            short p_index = (short)this.registeredPanels.indexOf(panel);
            this.lastNode = new_node = new DefaultMutableTreeNode(panel);
            int l_index = 0;
            if (panel.getLabelGroup() == null) {
                Enumeration<TreeNode> labelsAndGroups = this.rootNode.children();
                for (short i = 0; i < p_index; i = (short)(i + 1)) {
                    if (((IPanel)this.registeredPanels.get(i)).getLabelGroup() == null) {
                        if (!labelsAndGroups.hasMoreElements()) break;
                        if (!((DefaultMutableTreeNode)labelsAndGroups.nextElement()).getUserObject().equals(this.registeredPanels.get(i))) continue;
                        l_index = (short)(l_index + 1);
                        continue;
                    }
                    if (!labelsAndGroups.hasMoreElements()) break;
                    if (!((DefaultMutableTreeNode)labelsAndGroups.nextElement()).getUserObject().equals(((IPanel)this.registeredPanels.get(i)).getLabelGroup())) continue;
                    l_index = (short)(l_index + 1);
                }
                this.getTreeModel().insertNodeInto(new_node, this.getRootNode(), l_index);
                ++this.panelsInGUICount;
                return;
            }
            DefaultMutableTreeNode node = null;
            Enumeration<TreeNode> groups = this.rootNode.children();
            while (groups.hasMoreElements() && !(node = (DefaultMutableTreeNode)groups.nextElement()).getUserObject().equals(panel.getLabelGroup())) {
                node = null;
            }
            if (node != null) {
                Enumeration<TreeNode> labels = node.children();
                l_index = 0;
                while (labels.hasMoreElements()) {
                    if (!((DefaultMutableTreeNode)labels.nextElement()).getUserObject().equals(panel)) continue;
                    return;
                }
                labels = node.children();
                Object leaf_panel = ((DefaultMutableTreeNode)labels.nextElement()).getUserObject();
                for (short i = 0; i < p_index; i = (short)(i + 1)) {
                    if (((IPanel)this.registeredPanels.get(i)).getLabelGroup() != panel.getLabelGroup() || !((IPanel)this.registeredPanels.get(i)).equals(leaf_panel)) continue;
                    l_index = (short)(l_index + 1);
                    if (!labels.hasMoreElements()) break;
                    leaf_panel = ((DefaultMutableTreeNode)labels.nextElement()).getUserObject();
                }
                this.getTreeModel().insertNodeInto(new_node, node, l_index);
                ++this.panelsInGUICount;
                return;
            }
            int g_index = 0;
            groups = this.rootNode.children();
            String c_labelGroup = (String)((DefaultMutableTreeNode)groups.nextElement()).getUserObject();
            for (short i = 0; i < p_index; i = (short)(i + 1)) {
                String labelGroup = ((IPanel)this.registeredPanels.get(i)).getLabelGroup();
                if (c_labelGroup == null) {
                    if (labelGroup != null) continue;
                    c_labelGroup = (String)((DefaultMutableTreeNode)groups.nextElement()).getUserObject();
                    g_index = (short)(g_index + 1);
                    continue;
                }
                if (!c_labelGroup.equals(labelGroup)) continue;
                DefaultMutableTreeNode dmtnode = (DefaultMutableTreeNode)groups.nextElement();
                c_labelGroup = dmtnode.getUserObject().toString();
                g_index = (short)(g_index + 1);
            }
            this.lastNode = parent = new DefaultMutableTreeNode(panel.getLabelGroup());
            this.getTreeModel().insertNodeInto(parent, this.getRootNode(), g_index);
            this.lastNode = new_node;
            this.getTreeModel().insertNodeInto(new_node, parent, 0);
            ++this.panelsInGUICount;
        }
    }

    @Override
    protected void unLoadPanel(IPanel panel) {
        super.unLoadPanel(panel);
        this.removePanelImpl(panel);
    }

    protected void removePanelImpl(IPanel panel) {
        if (this.belongsThisGroup(panel)) {
            if (panel.getLabel() == null) {
                return;
            }
            if (panel.getLabelGroup() == null) {
                for (int i = 0; i < this.getRootNode().getChildCount(); i = (int)((short)(i + 1))) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getRootNode().getChildAt(i);
                    if (!node.getUserObject().toString().equals(panel.getLabel()) || node.getChildCount() != 0) continue;
                    this.lastNode = node;
                    this.getTreeModel().removeNodeFromParent(node);
                    --this.panelsInGUICount;
                    return;
                }
                return;
            }
            for (int i = 0; i < this.getRootNode().getChildCount(); i = (int)((short)(i + 1))) {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.getRootNode().getChildAt(i);
                if (parent.getChildCount() <= 0 || !parent.getUserObject().toString().equals(panel.getLabelGroup())) continue;
                for (int j = 0; j < parent.getChildCount(); j = (int)((short)(j + 1))) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getChildAt(j);
                    if (!node.getUserObject().toString().equals(panel.getLabel())) continue;
                    if (parent.getChildCount() == 1) {
                        this.lastNode = parent;
                        this.getTreeModel().removeNodeFromParent(parent);
                        --this.panelsInGUICount;
                        continue;
                    }
                    this.lastNode = node;
                    this.getTreeModel().removeNodeFromParent(node);
                    --this.panelsInGUICount;
                }
                return;
            }
        }
    }

    public TreePath getSelectionPath() {
        return this.getJTree().getSelectionPath();
    }

    @Override
    public IPanel getActivePanel() {
        if (this.registeredPanels.size() == 0) {
            return null;
        }
        Object node = ((DefaultMutableTreeNode)this.getJTree().getLastSelectedPathComponent()).getUserObject();
        if (node instanceof IPanel) {
            return (IPanel)node;
        }
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.registeredPanels.size() == 0) {
            return;
        }
        Object object = e.getSource();
        if (object != null && object instanceof IPanel) {
            ((IPanel)object).selected();
            this.currentDividerLocation = this.getJSplitPane().getDividerLocation();
        }
    }

    @Override
    public synchronized void setPanelInGUI(IPanel panel, boolean b) {
        if (this.registeredPanels.size() == 0) {
            return;
        }
        if (this.registeredPanels.indexOf(panel) == -1) {
            return;
        }
        if (b) {
            this.addPanelSortOrdered((AbstractPanel)panel);
        } else {
            this.removePanelImpl((AbstractPanel)panel);
        }
        this.repaint();
    }

    @Override
    public synchronized boolean isPanelInGUI(IPanel panel) {
        if (!this.registeredPanels.contains(panel)) {
            return false;
        }
        for (int i = 0; i < this.getRootNode().getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getRootNode().getChildAt(i);
            if (!(node.getChildCount() == 0 ? node.getUserObject().equals(panel) : this.isPanelAtBranch(panel, node))) continue;
            return true;
        }
        return false;
    }

    protected boolean isPanelAtBranch(IPanel panel, DefaultMutableTreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (!child.getUserObject().equals(panel)) continue;
            return true;
        }
        return false;
    }

    public void addTreeSelectionListener(TreeSelectionListener tsl) {
        this.getJTree().addTreeSelectionListener(tsl);
    }

    public void removeTreeSelectionListener(TreeSelectionListener tsl) {
        this.getJTree().removeTreeSelectionListener(tsl);
    }

    public TreeSelectionListener[] getTreeSelectionListeners() {
        return this.getJTree().getTreeSelectionListeners();
    }

    @Override
    public int getPanelInGUICount() {
        return this.panelsInGUICount;
    }

    public int getDividerLocation() {
        return this.getJSplitPane().getDividerLocation();
    }

    public void setDividerLocation(int location) {
        this.getJSplitPane().setDividerLocation(location);
    }

    public int getDividerSize() {
        return this.getJSplitPane().getDividerSize();
    }

    public void setDividerSize(int newSize) {
        this.getJSplitPane().setDividerSize(newSize);
    }

    static {
        PanelGroupManager.getManager().registerPanelGroup(TabbedPanel.class);
    }

    protected class DefaultPanel
    extends AbstractPanel {
        public DefaultPanel() {
        }

        public DefaultPanel(String id, String label, String labelGroup) {
            super(id, label, labelGroup);
        }

        @Override
        protected void initialize() {
        }

        @Override
        public void accept() {
        }

        @Override
        public void apply() {
        }

        @Override
        public void cancel() {
        }

        @Override
        public void selected() {
        }
    }
}

