/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.NumberFormatter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JNumberSpinner
extends JSpinner {
    private static final long serialVersionUID = 8614785196224519553L;
    private static final Logger logger = LoggerFactory.getLogger(JNumberSpinner.class);
    private boolean fireChanges;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private final int defaultColumns = 10;

    public JNumberSpinner() {
        super(new SpinnerNumberModel(0.0, Double.NEGATIVE_INFINITY, Double.MAX_VALUE, 1.0));
        this.init(10, 0);
    }

    public JNumberSpinner(int currentValue) {
        super(new SpinnerNumberModel(currentValue, Integer.MIN_VALUE, Integer.MAX_VALUE, 1));
        this.init(10, 0);
    }

    public JNumberSpinner(int currentValue, int columns) {
        super(new SpinnerNumberModel(currentValue, Integer.MIN_VALUE, Integer.MAX_VALUE, 1));
        this.init(columns, 0);
    }

    public JNumberSpinner(int currentValue, int columns, int minValue, int maxValue, int step) {
        super(new SpinnerNumberModel(currentValue, minValue, maxValue, step));
        this.init(columns, 0);
    }

    @Deprecated
    public JNumberSpinner(String currentValue, int columns, int minValue, int maxValue, int step) {
        super(new SpinnerNumberModel());
        Integer value;
        if (StringUtils.isBlank((CharSequence)currentValue)) {
            value = null;
        } else {
            try {
                value = Integer.valueOf(currentValue);
            }
            catch (Exception ex) {
                value = null;
            }
        }
        this.init(value == null ? Integer.valueOf(0) : value, columns, Integer.valueOf(minValue), Integer.valueOf(maxValue), step, 0);
        if (value == null) {
            JSpinner.NumberEditor editor = (JSpinner.NumberEditor)this.getEditor();
            JFormattedTextField textField = editor.getTextField();
            textField.setText("");
        }
    }

    public JNumberSpinner(int currentValue, int columns, int minValue, int maxValue, int step, int decimals) {
        super(new SpinnerNumberModel(currentValue, minValue, maxValue, step));
        this.init(columns, decimals);
    }

    public JNumberSpinner(double currentValue) {
        super(new SpinnerNumberModel(currentValue, Double.NEGATIVE_INFINITY, Double.MAX_VALUE, 1.0));
        this.init(10, 4);
    }

    @Deprecated
    public JNumberSpinner(String currentValue, int columns, double minValue, double maxValue, double step) {
        this(currentValue, columns, minValue, maxValue, step, 0);
    }

    @Deprecated
    public JNumberSpinner(String currentValue, int columns, double minValue, double maxValue, double step, int decimals) {
        super(new SpinnerNumberModel());
        Double value;
        if (StringUtils.isBlank((CharSequence)currentValue)) {
            value = null;
        } else {
            try {
                value = Double.valueOf(currentValue);
            }
            catch (Exception ex) {
                value = null;
            }
        }
        this.init(value == null ? Double.valueOf(0.0) : value, columns, Double.valueOf(minValue), Double.valueOf(maxValue), step, decimals);
        if (value == null) {
            JSpinner.NumberEditor editor = (JSpinner.NumberEditor)this.getEditor();
            JFormattedTextField textField = editor.getTextField();
            textField.setText("");
        }
    }

    public JNumberSpinner(double currentValue, int columns, double minValue, double maxValue, double step) {
        super(new SpinnerNumberModel(currentValue, minValue, maxValue, step));
        this.init(columns, 4);
    }

    public JNumberSpinner(double currentValue, int columns, double minValue, double maxValue, double step, int decimals) {
        super(new SpinnerNumberModel(currentValue, minValue, maxValue, step));
        this.init(columns, decimals);
    }

    private void init(int columns, int decimals) {
        JSpinner.NumberEditor editor = (JSpinner.NumberEditor)this.getEditor();
        JFormattedTextField textField = editor.getTextField();
        NumberFormatter formatter = (NumberFormatter)textField.getFormatter();
        DecimalFormat format = editor.getFormat();
        if (columns > 0) {
            textField.setColumns(columns);
        }
        format.setMinimumFractionDigits(decimals);
        formatter.setAllowsInvalid(true);
        this.fireChanges = true;
    }

    @Deprecated
    private void init(Number currentValue, int columns, Comparable minValue, Comparable maxValue, Number step, int decimals) {
        JSpinner.NumberEditor editor = (JSpinner.NumberEditor)this.getEditor();
        JFormattedTextField textField = editor.getTextField();
        NumberFormatter formatter = (NumberFormatter)textField.getFormatter();
        DecimalFormat format = editor.getFormat();
        SpinnerNumberModel model = this.getNumberModel();
        if (columns > 0) {
            textField.setColumns(columns);
        }
        model.setValue(currentValue);
        model.setMaximum(this.hackValue(maxValue));
        model.setMinimum(this.hackValue(minValue));
        model.setStepSize((int)Math.ceil(step.doubleValue()));
        format.setMinimumFractionDigits(decimals);
        formatter.setAllowsInvalid(true);
        this.fireChanges = true;
    }

    protected SpinnerNumberModel getNumberModel() {
        return (SpinnerNumberModel)this.getModel();
    }

    private Comparable hackValue(Comparable value) {
        if (!(value instanceof Double)) {
            return value;
        }
        return Integer.valueOf(((Number)((Object)value)).intValue());
    }

    public int getInteger() {
        return this.getNumberModel().getNumber().intValue();
    }

    public double getDouble() {
        return this.getNumberModel().getNumber().doubleValue();
    }

    public void setDouble(double v) {
        if (this.fireChanges) {
            this.fireChanges = false;
            try {
                this.setDouble(v);
            }
            finally {
                this.fireChanges = true;
            }
            return;
        }
        SpinnerNumberModel model = this.getNumberModel();
        model.setValue(v);
    }

    public void setInteger(int v) {
        if (this.fireChanges) {
            this.fireChanges = false;
            try {
                this.setInteger(v);
            }
            finally {
                this.fireChanges = true;
            }
            return;
        }
        SpinnerNumberModel model = this.getNumberModel();
        model.setValue(v);
    }

    public double getMaxValue() {
        Number n = (Number)((Object)this.getNumberModel().getMaximum());
        return n.doubleValue();
    }

    public void setMaxValue(double maxValue) {
        if (this.fireChanges) {
            this.fireChanges = false;
            try {
                this.setMaxValue(maxValue);
            }
            finally {
                this.fireChanges = true;
            }
            return;
        }
        SpinnerNumberModel model = this.getNumberModel();
        if (model.getValue() instanceof Double) {
            model.setMaximum(Double.valueOf(maxValue));
        } else {
            model.setMaximum(Integer.valueOf((int)maxValue));
        }
    }

    public double getMinValue() {
        Number n = (Number)((Object)this.getNumberModel().getMinimum());
        return n.doubleValue();
    }

    public void setMinValue(double minValue) {
        if (this.fireChanges) {
            this.fireChanges = false;
            try {
                this.setMinValue(minValue);
            }
            finally {
                this.fireChanges = true;
            }
            return;
        }
        SpinnerNumberModel model = this.getNumberModel();
        if (model.getValue() instanceof Double) {
            model.setMinimum(Double.valueOf(minValue));
        } else {
            model.setMinimum(Integer.valueOf((int)minValue));
        }
    }

    public double getStep() {
        Number n = this.getNumberModel().getStepSize();
        return n.doubleValue();
    }

    public void setStep(double step) {
        if (this.fireChanges) {
            this.fireChanges = false;
            try {
                this.setStep(step);
            }
            finally {
                this.fireChanges = true;
            }
            return;
        }
        SpinnerNumberModel model = this.getNumberModel();
        if (model.getValue() instanceof Double) {
            model.setStepSize(step);
        } else {
            model.setStepSize((int)step);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    protected void fireStateChanged() {
        super.fireStateChanged();
        if (this.fireChanges) {
            for (int i = 0; i < this.actionListeners.size(); ++i) {
                ActionListener listener = this.actionListeners.get(i);
                listener.actionPerformed(new ActionEvent(this, -1, null));
            }
        }
    }
}

