/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.swing.textBoxWithCalendar;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JDialog;
import org.freixas.jcalendar.DateEvent;
import org.freixas.jcalendar.DateListener;
import org.freixas.jcalendar.JCalendar;
import org.gvsig.gui.beans.Messages;
import org.gvsig.gui.beans.swing.textBoxWithCalendar.IMethodsForGraphicalCalendarComponents;

public class JCalendarDateDialog
extends JDialog
implements IMethodsForGraphicalCalendarComponents,
Serializable {
    private static final long serialVersionUID = -4265734997797240482L;
    private JCalendar jCalendar = null;
    private final int defaultWidth = 350;
    private final int defaultHeight = 230;
    private Dimension lastDimensionOfJDialog;
    private Dimension minDimensionOfJDialog;
    private Dimension maxDimensionOfJDialog;

    public JCalendarDateDialog() {
        this.initialize();
    }

    public JCalendarDateDialog(int width, int height) {
        this.initialize();
        this.lastDimensionOfJDialog.width = width;
        this.lastDimensionOfJDialog.height = height;
    }

    private void initialize() {
        this.setDefaultTitle();
        this.lastDimensionOfJDialog = new Dimension(this.defaultWidth, this.defaultHeight);
        this.setSizeResize(350, 230);
        this.getContentPane().add((Component)this.getJCalendar());
        this.maxDimensionOfJDialog = new Dimension(-1, -1);
        this.minDimensionOfJDialog = new Dimension(-1, -1);
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                boolean modified = false;
                int width = JCalendarDateDialog.this.getSize().width;
                int height = JCalendarDateDialog.this.getSize().height;
                int new_width = 0;
                int new_height = 0;
                if (height != 0 && width != 0) {
                    if (((JCalendarDateDialog)JCalendarDateDialog.this).minDimensionOfJDialog.height != -1 && height < ((JCalendarDateDialog)JCalendarDateDialog.this).minDimensionOfJDialog.height) {
                        new_width = width;
                        new_height = ((JCalendarDateDialog)JCalendarDateDialog.this).minDimensionOfJDialog.height;
                        modified = true;
                    }
                    if (((JCalendarDateDialog)JCalendarDateDialog.this).minDimensionOfJDialog.width != -1 && width < ((JCalendarDateDialog)JCalendarDateDialog.this).minDimensionOfJDialog.width) {
                        new_width = ((JCalendarDateDialog)JCalendarDateDialog.this).minDimensionOfJDialog.width;
                        new_height = height;
                        modified = true;
                    }
                    if (((JCalendarDateDialog)JCalendarDateDialog.this).maxDimensionOfJDialog.height != -1 && height > ((JCalendarDateDialog)JCalendarDateDialog.this).maxDimensionOfJDialog.height) {
                        new_width = width;
                        new_height = ((JCalendarDateDialog)JCalendarDateDialog.this).maxDimensionOfJDialog.height;
                        modified = true;
                    }
                    if (((JCalendarDateDialog)JCalendarDateDialog.this).maxDimensionOfJDialog.width != -1 && width > ((JCalendarDateDialog)JCalendarDateDialog.this).maxDimensionOfJDialog.width) {
                        new_width = ((JCalendarDateDialog)JCalendarDateDialog.this).maxDimensionOfJDialog.width;
                        new_height = height;
                        modified = true;
                    }
                    if (modified) {
                        JCalendarDateDialog.this.setResizable(false);
                        JCalendarDateDialog.this.setSize(new_width, new_height);
                        JCalendarDateDialog.this.setResizable(true);
                        JCalendarDateDialog.this.getJCalendar().revalidate();
                    }
                    JCalendarDateDialog.this.lastDimensionOfJDialog = JCalendarDateDialog.this.getSize();
                }
            }
        });
    }

    public void resizeToInitialSize() {
        this.getContentPane().setSize(this.defaultWidth, this.defaultHeight);
        this.getJCalendar().revalidate();
    }

    public void setMaximumWidthScreenResolutionPercentage(double max_width_screen_percentage) {
        int max_width = (int)Math.ceil((double)Toolkit.getDefaultToolkit().getScreenSize().width * max_width_screen_percentage);
        if (max_width > 0 || max_width == -1) {
            this.maxDimensionOfJDialog.width = max_width;
        }
    }

    public void setMinimumWidthScreenResolutionPercentage(double min_width_screen_percentage) {
        int min_width = (int)Math.ceil((double)Toolkit.getDefaultToolkit().getScreenSize().width * min_width_screen_percentage);
        if (min_width > 0 || min_width == -1) {
            this.minDimensionOfJDialog.width = min_width;
        }
    }

    public void setMaximumHeightScreenResolutionPercentage(double max_height_screen_percentage) {
        if (max_height_screen_percentage > 0.0 && max_height_screen_percentage <= 1.0 || max_height_screen_percentage == -1.0) {
            int max_height;
            this.maxDimensionOfJDialog.height = max_height = (int)Math.ceil((double)Toolkit.getDefaultToolkit().getScreenSize().height * max_height_screen_percentage);
        }
    }

    public void setMinimumHeightScreenResolutionPercentage(double min_height_screen_percentage) {
        if (min_height_screen_percentage > 0.0 && min_height_screen_percentage <= 1.0 || min_height_screen_percentage == -1.0) {
            int min_height;
            this.minDimensionOfJDialog.height = min_height = (int)Math.ceil((double)Toolkit.getDefaultToolkit().getScreenSize().height * min_height_screen_percentage);
        }
    }

    public void setMaximumWidth(int max_width) {
        if (max_width > 0 || max_width == -1) {
            this.maxDimensionOfJDialog.width = max_width;
        }
    }

    public void setMinimumWidth(int min_width) {
        if (min_width > 0 || min_width == -1) {
            this.minDimensionOfJDialog.width = min_width;
        }
    }

    public void setMaximumHeight(int max_height) {
        if (max_height > 0 || max_height == -1) {
            this.maxDimensionOfJDialog.height = max_height;
        }
    }

    public void setMinimumHeight(int min_height) {
        if (min_height > 0 || min_height == -1) {
            this.minDimensionOfJDialog.height = min_height;
        }
    }

    public void setSizeResize(int width, int height) {
        this.setSize(new Dimension(width, height));
        this.lastDimensionOfJDialog = this.getSize();
        this.getJCalendar().revalidate();
    }

    @Override
    public int getHeight() {
        return this.lastDimensionOfJDialog.height;
    }

    @Override
    public int getWidth() {
        return this.lastDimensionOfJDialog.width;
    }

    private JCalendar getJCalendar() {
        if (this.jCalendar == null) {
            this.jCalendar = new JCalendar();
            this.jCalendar.setToolTipText(Messages.getText("calendarSelectDate"));
            try {
                this.jCalendar.setToolTipTextToMonthDecrButton(Messages.getText("calendarBackOneMonth"));
                this.jCalendar.setToolTipTextToMonthIncrButton(Messages.getText("calendarForwardOneMonth"));
                this.jCalendar.setToolTipTextToYearDecrButton(Messages.getText("calendarBackOneYear"));
                this.jCalendar.setToolTipTextToYearIncrButton(Messages.getText("calendarForwardOneYear"));
                this.jCalendar.addDateListener(new DateListener(){

                    public void dateChanged(DateEvent arg0) {
                        JCalendarDateDialog.this.setVisible(false);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.jCalendar;
    }

    @Override
    public Date getDate() {
        return this.jCalendar.getDate();
    }

    @Override
    public void setDate(Date date) {
        this.jCalendar.setDate(date);
    }

    @Override
    public String getFormattedDate() {
        return new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault()).format(this.getDate());
    }

    @Override
    public String getTitle() {
        return super.getTitle();
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
    }

    public void setDefaultTitle() {
        this.setTitle(Messages.getText("calendarTitle"));
    }

    @Override
    public void setModal(boolean b) {
        super.setModal(b);
    }
}

