/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import jwizardcomponent.CancelAction;
import jwizardcomponent.DefaultJWizardComponents;
import jwizardcomponent.FinishAction;
import jwizardcomponent.JWizardComponents;
import jwizardcomponent.JWizardPanel;
import jwizardcomponent.common.SimpleButtonPanel;
import org.gvsig.gui.beans.wizard.WizardPanel;
import org.gvsig.gui.beans.wizard.WizardPanelCancelAction;
import org.gvsig.gui.beans.wizard.WizardPanelFinishAction;
import org.gvsig.gui.beans.wizard.panel.OptionPanel;
import org.gvsig.gui.beans.wizard.panel.OptionPanelContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardPanelWithLogo
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(WizardPanelWithLogo.class);
    private static final long serialVersionUID = 7506729926181935234L;
    public static final int ACTION_PREVIOUS = 0;
    public static final int ACTION_NEXT = 1;
    public static final int ACTION_CANCEL = 2;
    public static final int ACTION_FINISH = 3;
    DefaultJWizardComponents wizardComponents;
    JPanel buttonPanel;
    JLabel statusLabel = new JLabel();
    ImageIcon logo;
    private int direction = 1;

    public WizardPanelWithLogo(ImageIcon logo) {
        this.logo = logo;
        this.wizardComponents = new DefaultJWizardComponents();
        this.init();
    }

    public WizardPanelWithLogo() {
        this.wizardComponents = new DefaultJWizardComponents();
        this.logo = null;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        if (this.logo != null) {
            JPanel logoPanel = new JPanel();
            logoPanel.add(new JLabel(this.logo));
            logoPanel.setBackground(Color.WHITE);
            this.add((Component)logoPanel, "West");
        }
        this.add((Component)this.wizardComponents.getWizardPanelsContainer(), "Center");
        JPanel auxPanel = new JPanel(new BorderLayout());
        auxPanel.add((Component)new JSeparator(), "North");
        this.buttonPanel = new SimpleButtonPanel((JWizardComponents)this.wizardComponents);
        auxPanel.add(this.buttonPanel);
        this.add((Component)auxPanel, "South");
        this.wizardComponents.setFinishAction(new FinishAction((JWizardComponents)this.wizardComponents){

            public void performAction() {
            }
        });
        this.wizardComponents.setCancelAction(new CancelAction((JWizardComponents)this.wizardComponents){

            public void performAction() {
            }
        });
    }

    public void doAction(int action) {
        switch (action) {
            case 1: {
                this.getWizardComponents().getNextButton().getActionListeners()[0].actionPerformed(null);
                break;
            }
            case 0: {
                this.getWizardComponents().getBackButton().getActionListeners()[0].actionPerformed(null);
            }
        }
    }

    public DefaultJWizardComponents getWizardComponents() {
        return this.wizardComponents;
    }

    public void setWizardComponents(DefaultJWizardComponents aWizardComponents) {
        this.wizardComponents = aWizardComponents;
    }

    @Override
    public void show() {
        this.wizardComponents.updateComponents();
        super.setVisible(true);
    }

    public void updatePanel() {
        try {
            OptionPanelContainer page = (OptionPanelContainer)this.getWizardComponents().getCurrentPanel();
            page.update();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addOptionPanel(OptionPanel optionPanel) {
        this.getWizardComponents().addWizardPanel((JWizardPanel)new OptionPanelContainer(this, optionPanel));
    }

    public void setNextButtonEnabled(boolean isEnabled) {
        this.getWizardComponents().getNextButton().setEnabled(isEnabled);
    }

    public void setFinishButtonEnabled(boolean isVisible) {
        this.getWizardComponents().getFinishButton().setEnabled(isVisible);
    }

    public void setFinishButtonText(String text) {
        this.getWizardComponents().getFinishButton().setText(text);
    }

    public void setCancelButtonEnabled(boolean isVisible) {
        this.getWizardComponents().getCancelButton().setEnabled(isVisible);
    }

    public void setCancelButtonText(String text) {
        this.getWizardComponents().getCancelButton().setText(text);
    }

    private void setFinishAction(FinishAction finishAction) {
        this.getWizardComponents().setFinishAction(finishAction);
    }

    private void setCancelAction(CancelAction cancelAction) {
        this.getWizardComponents().setCancelAction(cancelAction);
    }

    public void setWizardListener(WizardPanel wizardPanel) {
        this.setFinishAction(new WizardPanelFinishAction((JWizardComponents)this.getWizardComponents(), wizardPanel));
        this.setCancelAction(new WizardPanelCancelAction((JWizardComponents)this.getWizardComponents(), wizardPanel));
    }

    public void setBackButtonEnabled(boolean isEnabled) {
        this.getWizardComponents().getBackButton().setEnabled(isEnabled);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public void skip() {
        int index = -1;
        try {
            this.doAction(this.getDirection());
        }
        catch (Exception ex) {
            LOG.warn("Can't skip current panel (" + index + ").", (Throwable)ex);
        }
    }
}

