/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.webbrowser.jfx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.webbrowser.WebBrowserPanel;
import org.gvsig.webbrowser.jfx.JFXWebBrowser;
import org.gvsig.webbrowser.jfx.JFXWebBrowserPanelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JFXWebBrowserPanel
extends JFXWebBrowserPanelView
implements WebBrowserPanel {
    protected static final Logger LOGGER = LoggerFactory.getLogger(JFXWebBrowserPanel.class);
    private WebBrowserPanel.WebBrowser browser;

    public JFXWebBrowserPanel() {
        this.initComponents();
    }

    protected WebBrowserPanel.WebBrowser createBrowserPanel() {
        return new JFXWebBrowser(this);
    }

    private void initComponents() {
        this.browser = this.createBrowserPanel();
        this.containerBrowser.setLayout(new BorderLayout());
        this.containerBrowser.add((Component)this.browser.asJComponent(), "Center");
        this.txtURL.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    JFXWebBrowserPanel.this.setPage(JFXWebBrowserPanel.this.txtURL.getText());
                }
            }
        });
        this.txtSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                JTextField jtext = JFXWebBrowserPanel.this.txtSearch;
                if (event.getKeyChar() == '\u001b') {
                    jtext.setText("");
                    JFXWebBrowserPanel.this.browser.find("", true);
                } else if (event.getKeyChar() == '\n') {
                    JFXWebBrowserPanel.this.browser.find(jtext.getText(), true);
                }
            }
        });
        this.btnSearchPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFXWebBrowserPanel.this.browser.find(JFXWebBrowserPanel.this.txtSearch.getText(), false);
            }
        });
        this.btnSearchNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFXWebBrowserPanel.this.browser.find(JFXWebBrowserPanel.this.txtSearch.getText(), true);
            }
        });
        this.btnPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFXWebBrowserPanel.this.browser.goPrevious();
            }
        });
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFXWebBrowserPanel.this.browser.goNext();
            }
        });
        this.setPreferredSize(new Dimension(600, 500));
    }

    public void setPage(String url) {
        try {
            this.setPage(new URL(url));
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setPage(final URL url) {
        this.txtURL.setText(url.toString());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    JFXWebBrowserPanel.this.browser.setPage(url);
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't load page from url '" + url + "'.", (Throwable)ex);
                }
            }
        });
    }

    public String getPage() {
        return this.browser.getPage();
    }

    public void setContent(String content, String contentType) {
        this.browser.setContent(content, contentType);
    }

    public String getTitle() {
        return this.browser.getTitle();
    }

    public JComponent asJComponent() {
        return this;
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return ToolsSwingUtils.loadImage((Object)this, (String)imageName);
    }

    public void setStatus(String msg) {
        this.lblStatus.setText(msg);
    }

    public void setURLText(String url) {
        this.txtURL.setText(url);
    }
}

