/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.spi.dynformfield;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;

public abstract class AbstractJDynFormFieldFactory
implements JDynFormFieldFactory {
    private String name = null;
    private int dataType;
    private String subtype;

    protected AbstractJDynFormFieldFactory(String name, int dataType, String subtype) {
        this.dataType = dataType;
        this.subtype = subtype;
        this.name = name;
    }

    protected AbstractJDynFormFieldFactory(String name, int dataType) {
        this(name, dataType, null);
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    @Override
    public String getSubtype() {
        return this.subtype;
    }

    @Override
    public boolean isApplicableTo(JDynForm.DynFormContext context, DynFormFieldDefinition fieldDefinition) {
        if (fieldDefinition.getDataType().getType() != this.dataType) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.subtype)) {
            return true;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)this.subtype, (CharSequence)fieldDefinition.getSubtype());
    }

    @Override
    public int compareTo(JDynFormFieldFactory other) {
        String this_key = String.format("%04d##%s##%04d", this.getPriority(), Objects.toString(this.getSubtype(), "''"), this.getDataType());
        String other_key = String.format("%04d##%s##%04d", other.getPriority(), Objects.toString(other.getSubtype(), "''"), other.getDataType());
        int n = other_key.compareToIgnoreCase(this_key);
        return n;
    }

    public String toString() {
        String this_key = String.format("%04d##%s##%04d##%s", this.getPriority(), Objects.toString(this.getSubtype(), "''"), this.getDataType(), this.getName());
        return this_key;
    }
}

