/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermColor;
import cz.vutbr.web.css.TermInteger;
import cz.vutbr.web.css.TermLength;
import cz.vutbr.web.css.TermLengthOrPercent;
import cz.vutbr.web.css.TermList;
import cz.vutbr.web.css.TermNumber;
import cz.vutbr.web.css.TermPercent;
import cz.vutbr.web.css.TermURI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.fit.cssbox.css.CSSUnits;
import org.fit.cssbox.layout.BackgroundImage;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.BoxTreeCreationStatus;
import org.fit.cssbox.layout.CSSDecoder;
import org.fit.cssbox.layout.LengthSet;
import org.fit.cssbox.layout.ReplacedBox;
import org.fit.cssbox.layout.StackingContext;
import org.fit.cssbox.layout.TextBox;
import org.fit.cssbox.layout.VisualContext;
import org.fit.cssbox.misc.CSSStroke;
import org.fit.net.DataURLHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class ElementBox
extends Box {
    private static Logger log = LoggerFactory.getLogger(ElementBox.class);
    public static final CSSProperty.Display DISPLAY_ANY = null;
    public static final CSSProperty.Display DISPLAY_NONE = CSSProperty.Display.NONE;
    public static final CSSProperty.Display DISPLAY_INLINE = CSSProperty.Display.INLINE;
    public static final CSSProperty.Display DISPLAY_BLOCK = CSSProperty.Display.BLOCK;
    public static final CSSProperty.Display DISPLAY_LIST_ITEM = CSSProperty.Display.LIST_ITEM;
    public static final CSSProperty.Display DISPLAY_RUN_IN = CSSProperty.Display.RUN_IN;
    public static final CSSProperty.Display DISPLAY_INLINE_BLOCK = CSSProperty.Display.INLINE_BLOCK;
    public static final CSSProperty.Display DISPLAY_TABLE = CSSProperty.Display.TABLE;
    public static final CSSProperty.Display DISPLAY_INLINE_TABLE = CSSProperty.Display.INLINE_TABLE;
    public static final CSSProperty.Display DISPLAY_TABLE_ROW_GROUP = CSSProperty.Display.TABLE_ROW_GROUP;
    public static final CSSProperty.Display DISPLAY_TABLE_HEADER_GROUP = CSSProperty.Display.TABLE_HEADER_GROUP;
    public static final CSSProperty.Display DISPLAY_TABLE_FOOTER_GROUP = CSSProperty.Display.TABLE_FOOTER_GROUP;
    public static final CSSProperty.Display DISPLAY_TABLE_ROW = CSSProperty.Display.TABLE_ROW;
    public static final CSSProperty.Display DISPLAY_TABLE_COLUMN_GROUP = CSSProperty.Display.TABLE_COLUMN_GROUP;
    public static final CSSProperty.Display DISPLAY_TABLE_COLUMN = CSSProperty.Display.TABLE_COLUMN;
    public static final CSSProperty.Display DISPLAY_TABLE_CELL = CSSProperty.Display.TABLE_CELL;
    public static final CSSProperty.Display DISPLAY_TABLE_CAPTION = CSSProperty.Display.TABLE_CAPTION;
    public static final CSSProperty.Position POS_STATIC = CSSProperty.Position.STATIC;
    public static final CSSProperty.Position POS_RELATIVE = CSSProperty.Position.RELATIVE;
    public static final CSSProperty.Position POS_ABSOLUTE = CSSProperty.Position.ABSOLUTE;
    public static final CSSProperty.Position POS_FIXED = CSSProperty.Position.FIXED;
    public static final CSSProperty.WhiteSpace WHITESPACE_NORMAL = CSSProperty.WhiteSpace.NORMAL;
    public static final CSSProperty.WhiteSpace WHITESPACE_PRE = CSSProperty.WhiteSpace.PRE;
    public static final CSSProperty.WhiteSpace WHITESPACE_NOWRAP = CSSProperty.WhiteSpace.NOWRAP;
    public static final CSSProperty.WhiteSpace WHITESPACE_PRE_WRAP = CSSProperty.WhiteSpace.PRE_WRAP;
    public static final CSSProperty.WhiteSpace WHITESPACE_PRE_LINE = CSSProperty.WhiteSpace.PRE_LINE;
    private static final float DEFAULT_LINE_HEIGHT = 1.12f;
    protected Element el;
    protected int firstDOMChild;
    protected int lastDOMChild;
    protected Box preadd;
    protected Vector<Box> postadd;
    protected BoxTreeCreationStatus curstat;
    protected ElementBox previousTwin;
    protected ElementBox nextTwin;
    protected NodeData style = null;
    protected Map<Selector.PseudoDeclaration, NodeData> pseudoStyle = new HashMap<Selector.PseudoDeclaration, NodeData>();
    protected Vector<BackgroundImage> bgimages;
    protected boolean textonly;
    protected Map<Selector.PseudoDeclaration, ElementBox> pseudoElements;
    protected CSSProperty.Display display;
    protected CSSProperty.Position position;
    protected LengthSet coords;
    protected boolean topset;
    protected boolean leftset;
    protected boolean bottomset;
    protected boolean rightset;
    protected CSSProperty.WhiteSpace whitespace;
    protected Color bgcolor;
    protected LengthSet margin;
    protected LengthSet emargin;
    protected LengthSet border;
    protected LengthSet padding;
    protected Dimension content;
    protected Rectangle minAbsBounds = null;
    protected int lineHeight;
    protected boolean zset;
    protected int zIndex;
    protected int startChild;
    protected int endChild;
    protected Vector<Box> nested;
    protected StackingContext scontext;

    public ElementBox(Element n, Graphics2D g, VisualContext ctx) {
        super(n, g, ctx);
        if (n != null) {
            this.el = n;
            this.firstDOMChild = 0;
            this.lastDOMChild = n.getChildNodes().getLength();
            this.previousTwin = null;
            this.nextTwin = null;
            this.nested = new Vector();
            this.pseudoElements = new HashMap<Selector.PseudoDeclaration, ElementBox>();
            this.startChild = 0;
            this.endChild = 0;
            this.isblock = false;
            this.textonly = true;
        }
        this.position = POS_STATIC;
        this.topset = false;
        this.leftset = false;
        this.bottomset = false;
        this.rightset = false;
    }

    public void copyValues(ElementBox src) {
        super.copyValues(src);
        this.nested.addAll(src.nested);
        this.textonly = src.textonly;
        this.pseudoElements = new HashMap<Selector.PseudoDeclaration, ElementBox>(src.pseudoElements);
        this.style = src.style;
        this.pseudoStyle = new HashMap<Selector.PseudoDeclaration, NodeData>(src.pseudoStyle);
        this.startChild = src.startChild;
        this.endChild = src.endChild;
        this.isblock = src.isblock;
        this.style = src.style;
        this.display = src.display;
        this.lineHeight = src.lineHeight;
        this.whitespace = src.whitespace;
        this.bgcolor = src.bgcolor == null ? null : new Color(src.bgcolor.getRed(), src.bgcolor.getGreen(), src.bgcolor.getBlue(), src.bgcolor.getAlpha());
        this.bgimages = src.bgimages == null ? null : new Vector<BackgroundImage>(src.bgimages);
        this.position = src.position;
        this.topset = src.topset;
        this.leftset = src.leftset;
        this.bottomset = src.bottomset;
        this.rightset = src.rightset;
        if (src.coords != null) {
            this.coords = new LengthSet(src.coords);
        }
        if (src.margin != null) {
            this.margin = new LengthSet(src.margin);
        }
        if (src.emargin != null) {
            this.emargin = new LengthSet(src.emargin);
        }
        if (src.border != null) {
            this.border = new LengthSet(src.border);
        }
        if (src.padding != null) {
            this.padding = new LengthSet(src.padding);
        }
        if (src.content != null) {
            this.content = new Dimension(src.content);
        }
    }

    public abstract ElementBox copyBox();

    @Override
    public void initSubtree() {
        this.initBox();
        this.loadSizes();
        for (int i = 0; i < this.getSubBoxNumber(); ++i) {
            this.getSubBox(i).initSubtree();
        }
        this.computeEfficientMargins();
    }

    public Element getElement() {
        return this.el;
    }

    public void setStyle(NodeData s) {
        this.style = s;
        this.loadBasicStyle();
    }

    public NodeData getStyle() {
        return this.style;
    }

    public String getStyleString() {
        if (this.style != null) {
            return this.style.toString();
        }
        return "";
    }

    public String getPositionString() {
        return this.position.toString();
    }

    public String getStylePropertyValue(String property) {
        Term t = this.style.getValue(Term.class, property);
        if (t == null) {
            return "";
        }
        return t.toString();
    }

    public TermLengthOrPercent getLengthValue(String name) {
        if (this.style != null) {
            return (TermLengthOrPercent)this.style.getValue(TermLengthOrPercent.class, name);
        }
        return null;
    }

    public int getBorderWidth(CSSDecoder dec, String property) {
        if (this.style != null) {
            CSSProperty.BorderWidth prop = (CSSProperty.BorderWidth)this.style.getProperty(property);
            if (prop == CSSProperty.BorderWidth.length) {
                return dec.getLength((TermLengthOrPercent)this.style.getValue(TermLengthOrPercent.class, property), false, 3, 0, 0);
            }
            return CSSUnits.convertBorderWidth(prop);
        }
        return 0;
    }

    public CSSProperty.Display getDisplay() {
        return this.display;
    }

    public String getDisplayString() {
        if (this.display != null) {
            return this.display.toString();
        }
        return "";
    }

    public CSSProperty.WhiteSpace getWhiteSpace() {
        return this.whitespace;
    }

    @Override
    public boolean collapsesSpaces() {
        return this.whitespace != WHITESPACE_PRE && this.whitespace != WHITESPACE_PRE_WRAP;
    }

    @Override
    public boolean preservesLineBreaks() {
        return this.whitespace != WHITESPACE_NORMAL && this.whitespace != WHITESPACE_NOWRAP;
    }

    @Override
    public boolean allowsWrapping() {
        return this.whitespace == WHITESPACE_NORMAL || this.whitespace == WHITESPACE_PRE_WRAP || this.whitespace == WHITESPACE_PRE_LINE;
    }

    public Color getBgcolor() {
        return this.bgcolor;
    }

    public List<BackgroundImage> getBackgroundImages() {
        return this.bgimages;
    }

    public void setBgcolor(Color bgcolor) {
        this.bgcolor = bgcolor;
    }

    public int getSubBoxNumber() {
        return this.nested.size();
    }

    public List<Box> getSubBoxList() {
        return this.nested;
    }

    public Box getSubBox(int index) {
        return this.nested.elementAt(index);
    }

    public void addSubBox(Box box) {
        box.setParent(this);
        this.nested.add(box);
        ++this.endChild;
        if (this.isDisplayed() && !box.isEmpty()) {
            this.isempty = false;
        }
        if (!(box instanceof TextBox)) {
            this.textonly = false;
        }
    }

    public void removeSubBox(Box box) {
        if (this.nested.remove(box)) {
            --this.endChild;
        }
    }

    public void removeAllSubBoxes() {
        this.nested.removeAllElements();
        this.endChild = 0;
    }

    public void insertSubBoxBefore(Box where, Box what) {
        int pos = this.nested.indexOf(where);
        this.nested.insertElementAt(what, pos);
        ++this.endChild;
    }

    public void insertSubBoxAfter(Box where, Box what) {
        int pos = this.nested.indexOf(where);
        this.nested.insertElementAt(what, pos + 1);
        ++this.endChild;
    }

    public void insertSubBox(int index, Box what) {
        this.nested.insertElementAt(what, index);
        ++this.endChild;
    }

    public StackingContext getStackingContext() {
        if (this.scontext == null) {
            if (this.formsStackingContext()) {
                this.scontext = new StackingContext(this);
            } else {
                log.warn("getStackingContext: obtaining a stacking context from element that does not create one");
            }
        }
        return this.scontext;
    }

    public void setPseudoElement(Selector.PseudoDeclaration pseudo, ElementBox box) {
        this.pseudoElements.put(pseudo, box);
    }

    public ElementBox getPseudoElement(Selector.PseudoDeclaration pseudo) {
        return this.pseudoElements.get(pseudo);
    }

    public boolean hasPseudoElement(Selector.PseudoDeclaration pseudo) {
        return this.pseudoElements.containsKey(pseudo);
    }

    @Override
    public int getContentWidth() {
        return this.content.width;
    }

    @Override
    public int getContentHeight() {
        return this.content.height;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public LengthSet getMargin() {
        return this.margin;
    }

    public LengthSet getEMargin() {
        return this.emargin;
    }

    public LengthSet getCoords() {
        return this.coords;
    }

    public LengthSet getBorder() {
        return this.border;
    }

    public LengthSet getPadding() {
        return this.padding;
    }

    public Dimension getContent() {
        return this.content;
    }

    public boolean hasZIndex() {
        return this.zset;
    }

    public int getZIndex() {
        return this.zIndex;
    }

    public boolean formsStackingContext() {
        return this.position != POS_STATIC;
    }

    public int getStartChild() {
        return this.startChild;
    }

    public void setStartChild(int index) {
        this.startChild = index;
    }

    public int getEndChild() {
        return this.endChild;
    }

    public void setEndChild(int index) {
        this.endChild = index;
    }

    public void adoptChildren() {
        for (int i = this.startChild; i < this.endChild; ++i) {
            this.nested.elementAt(i).setParent(this);
        }
    }

    public int getContentOffsetX() {
        return this.margin.left + this.border.left + this.padding.left;
    }

    public int getContentOffsetY() {
        return this.emargin.top + this.border.top + this.padding.top;
    }

    @Override
    public int getContentX() {
        return this.bounds.x + this.emargin.left + this.border.left + this.padding.left;
    }

    @Override
    public int getContentY() {
        return this.bounds.y + this.emargin.top + this.border.top + this.padding.top;
    }

    @Override
    public int getAbsoluteContentX() {
        return this.absbounds.x + this.emargin.left + this.border.left + this.padding.left;
    }

    @Override
    public int getAbsoluteContentY() {
        return this.absbounds.y + this.emargin.top + this.border.top + this.padding.top;
    }

    @Override
    public int totalWidth() {
        return this.emargin.left + this.border.left + this.padding.left + this.content.width + this.padding.right + this.border.right + this.emargin.right;
    }

    @Override
    public int getAvailableContentWidth() {
        return this.availwidth - this.emargin.left - this.border.left - this.padding.left - this.padding.right - this.border.right - this.emargin.right;
    }

    @Override
    public Rectangle getMinimalAbsoluteBounds() {
        if (this.minAbsBounds == null) {
            this.minAbsBounds = this.computeMinimalAbsoluteBounds();
        }
        return this.minAbsBounds;
    }

    private Rectangle computeMinimalAbsoluteBounds() {
        int rx1 = 0;
        int ry1 = 0;
        int rx2 = 0;
        int ry2 = 0;
        boolean valid = false;
        for (int i = this.startChild; i < this.endChild; ++i) {
            Box sub = this.getSubBox(i);
            Rectangle sb = sub.getMinimalAbsoluteBounds();
            if (!sub.isDisplayed() || !sub.isVisible() || sb.width <= 0 || sb.height <= 0) continue;
            if (sb.x < rx1 || !valid) {
                rx1 = sb.x;
            }
            if (sb.y < ry1 || !valid) {
                ry1 = sb.y;
            }
            if (sb.x + sb.width > rx2 || !valid) {
                rx2 = sb.x + sb.width;
            }
            if (sb.y + sb.height > ry2 || !valid) {
                ry2 = sb.y + sb.height;
            }
            valid = true;
        }
        return new Rectangle(rx1, ry1, rx2 - rx1, ry2 - ry1);
    }

    @Override
    public boolean affectsDisplay() {
        boolean ret;
        boolean bl = ret = !this.isEmpty();
        if (this.border.top > 0 || this.border.bottom > 0) {
            ret = true;
        }
        if (this.padding.top > 0 || this.padding.bottom > 0) {
            ret = true;
        }
        return ret;
    }

    @Override
    public boolean isVisible() {
        return this.visible && this.clipblock.isVisible() && this.clipblock.visibleInClip(this);
    }

    public boolean visibleInClip(Box box) {
        if (box instanceof ElementBox) {
            return this.getClippedContentBounds().intersects(((ElementBox)box).getAbsoluteBorderBounds());
        }
        return this.getClippedContentBounds().intersects(box.getAbsoluteBounds());
    }

    public Rectangle getAbsoluteBackgroundBounds() {
        return new Rectangle(this.absbounds.x + this.margin.left + this.border.left, this.absbounds.y + this.margin.top + this.border.top, this.content.width + this.padding.left + this.padding.right, this.content.height + this.padding.top + this.padding.bottom);
    }

    public Rectangle getAbsoluteBorderBounds() {
        return new Rectangle(this.absbounds.x + this.margin.left, this.absbounds.y + this.margin.top, this.content.width + this.padding.left + this.padding.right + this.border.left + this.border.right, this.content.height + this.padding.top + this.padding.bottom + this.border.top + this.border.bottom);
    }

    @Override
    public String getText() {
        String ret = "";
        for (int i = this.startChild; i < this.endChild; ++i) {
            ret = ret + this.getSubBox(i).getText();
        }
        return ret;
    }

    @Override
    public boolean isWhitespace() {
        for (int i = this.startChild; i < this.endChild; ++i) {
            if (this.getSubBox(i).isWhitespace()) continue;
            return false;
        }
        return true;
    }

    public boolean containsTextOnly() {
        for (Box child : this.nested) {
            if (child instanceof TextBox) continue;
            return false;
        }
        return true;
    }

    public boolean containsMixedContent() {
        boolean ctext = false;
        boolean celem = false;
        for (Box child : this.nested) {
            if (child instanceof TextBox) {
                ctext = true;
            } else {
                celem = true;
            }
            if (!ctext || !celem) continue;
            return true;
        }
        return false;
    }

    public void drawStackingContext(boolean include) {
        if (this.isDisplayed() && this.isDeclaredVisible()) {
            int zi;
            Integer[] clevels;
            Integer[] integerArray = clevels = this.formsStackingContext() ? this.getStackingContext().getZIndices() : new Integer[]{};
            if (this.formsStackingContext()) {
                this.getViewport().getRenderer().renderElementBackground(this);
            }
            this.getViewport().getRenderer().startElementContents(this);
            if (this.isReplaced() && this.formsStackingContext()) {
                this.getViewport().getRenderer().renderReplacedContent((ReplacedBox)((Object)this));
            }
            for (zi = 0; zi < clevels.length && clevels[zi] < 0; ++zi) {
                this.drawChildContexts(clevels[zi]);
            }
            this.drawChildren(Box.DrawStage.DRAW_NONINLINE);
            this.drawChildren(Box.DrawStage.DRAW_FLOAT);
            this.drawChildren(Box.DrawStage.DRAW_INLINE);
            if (zi < clevels.length && clevels[zi] == 0) {
                this.drawChildContexts(0);
                ++zi;
            }
            while (zi < clevels.length) {
                this.drawChildContexts(clevels[zi]);
                ++zi;
            }
            this.getViewport().getRenderer().finishElementContents(this);
        }
    }

    protected void drawChildren(Box.DrawStage turn) {
        for (int i = this.startChild; i < this.endChild; ++i) {
            Box subbox = this.getSubBox(i);
            subbox.draw(turn);
        }
    }

    protected void drawChildContexts(int zindex) {
        Vector<ElementBox> list = this.getStackingContext().getElementsForZIndex(zindex);
        if (list != null) {
            for (ElementBox elem : list) {
                elem.drawStackingContext(!elem.hasZIndex());
            }
        }
    }

    public void drawBackground(Graphics2D g) {
        Color color = g.getColor();
        Shape oldclip = g.getClip();
        if (this.clipblock != null) {
            g.setClip(this.applyClip(oldclip, this.clipblock.getClippedContentBounds()));
        }
        this.ctx.updateGraphics(g);
        int x = this.absbounds.x;
        int y = this.absbounds.y;
        int bx1 = x + this.margin.left;
        int by1 = y + this.margin.top;
        int bw = this.border.left + this.padding.left + this.content.width + this.padding.right + this.border.right;
        int bh = this.border.top + this.padding.top + this.content.height + this.padding.bottom + this.border.bottom;
        int bx2 = bx1 + bw - 1;
        int by2 = by1 + bh - 1;
        if (this.bgcolor != null) {
            g.setColor(this.bgcolor);
            g.fillRect(bx1, by1, bw, bh);
        }
        if (this.bgimages != null) {
            for (BackgroundImage img : this.bgimages) {
                BufferedImage bimg = img.getBufferedImage();
                if (bimg == null) continue;
                g.drawImage((Image)bimg, bx1 + this.border.left, by1 + this.border.top, null);
            }
        }
        this.drawBorders(g, bx1, by1, bx2, by2);
        g.setClip(oldclip);
        g.setColor(color);
    }

    protected void drawBorders(Graphics2D g, int bx1, int by1, int bx2, int by2) {
        if (this.border.top > 0 && bx2 > bx1) {
            this.drawBorder(g, bx1, by1, bx2, by1, this.border.top, 0, 0, "top", false);
        }
        if (this.border.right > 0 && by2 > by1) {
            this.drawBorder(g, bx2, by1, bx2, by2, this.border.right, -this.border.right + 1, 0, "right", true);
        }
        if (this.border.bottom > 0 && bx2 > bx1) {
            this.drawBorder(g, bx1, by2, bx2, by2, this.border.bottom, 0, -this.border.bottom + 1, "bottom", true);
        }
        if (this.border.left > 0 && by2 > by1) {
            this.drawBorder(g, bx1, by1, bx1, by2, this.border.left, 0, 0, "left", false);
        }
    }

    private void drawBorder(Graphics2D g, int x1, int y1, int x2, int y2, int width, int right, int down, String side, boolean reverse) {
        CSSProperty.BorderColor bclr = (CSSProperty.BorderColor)this.style.getProperty("border-" + side + "-color");
        TermColor tclr = (TermColor)this.style.getValue(TermColor.class, "border-" + side + "-color");
        CSSProperty.BorderStyle bst = (CSSProperty.BorderStyle)this.style.getProperty("border-" + side + "-style");
        if (bst != CSSProperty.BorderStyle.HIDDEN && bclr != CSSProperty.BorderColor.TRANSPARENT) {
            Color clr = null;
            if (tclr != null) {
                clr = (Color)tclr.getValue();
            }
            if (clr == null && (clr = this.ctx.getColor()) == null) {
                clr = Color.BLACK;
            }
            g.setColor(clr);
            g.setStroke(new CSSStroke(width, bst, reverse));
            g.draw(new Line2D.Double(x1 + right, y1 + down, x2 + right, y2 + down));
        }
    }

    @Override
    public void drawExtent(Graphics2D g) {
        g.setColor(Color.RED);
        g.drawRect(this.absbounds.x, this.absbounds.y, this.bounds.width, this.bounds.height);
        g.setColor(Color.ORANGE);
        g.drawRect(this.getAbsoluteContentX(), this.getAbsoluteContentY(), this.getContentWidth(), this.getContentHeight());
    }

    public abstract boolean mayContainBlocks();

    protected abstract void loadSizes();

    public abstract void updateSizes();

    public void updateChildSizes() {
        for (int i = 0; i < this.getSubBoxNumber(); ++i) {
            Box child = this.getSubBox(i);
            if (child instanceof BlockBox) {
                BlockBox block = (BlockBox)child;
                int oldw = block.getContentWidth();
                int oldh = block.getContentHeight();
                block.updateSizes();
                block.setSize(block.totalWidth(), block.totalHeight());
                if (block.getContentWidth() == oldw && block.getContentHeight() == oldh) continue;
                block.updateChildSizes();
                continue;
            }
            if (!(child instanceof ElementBox)) continue;
            ElementBox eb = (ElementBox)child;
            eb.updateSizes();
            eb.setSize(eb.totalWidth(), eb.totalHeight());
            eb.updateChildSizes();
        }
    }

    public abstract void computeEfficientMargins();

    public abstract boolean marginsAdjoin();

    protected boolean borderVisible(String dir) {
        CSSProperty.BorderStyle st = (CSSProperty.BorderStyle)this.style.getProperty("border-" + dir + "-style");
        return st != null && st != CSSProperty.BorderStyle.NONE && st != CSSProperty.BorderStyle.HIDDEN;
    }

    protected void loadBorders(CSSDecoder dec, int contw) {
        this.border = new LengthSet();
        this.border.top = this.borderVisible("top") ? this.getBorderWidth(dec, "border-top-width") : 0;
        this.border.right = this.borderVisible("right") ? this.getBorderWidth(dec, "border-right-width") : 0;
        this.border.bottom = this.borderVisible("bottom") ? this.getBorderWidth(dec, "border-bottom-width") : 0;
        this.border.left = this.borderVisible("left") ? this.getBorderWidth(dec, "border-left-width") : 0;
    }

    protected void loadBasicStyle() {
        TermLength len;
        CSSProperty.Float floating;
        this.ctx.updateForGraphics(this.style, this.g);
        this.display = (CSSProperty.Display)this.style.getProperty("display");
        if (this.display == null) {
            this.display = CSSProperty.Display.INLINE;
        }
        if ((floating = (CSSProperty.Float)this.style.getProperty("float")) == null) {
            floating = BlockBox.FLOAT_NONE;
        }
        this.position = (CSSProperty.Position)this.style.getProperty("position");
        if (this.position == null) {
            this.position = BlockBox.POS_STATIC;
        }
        if (this.display == DISPLAY_NONE) {
            this.position = BlockBox.POS_STATIC;
            floating = BlockBox.FLOAT_NONE;
        } else if (this.position == BlockBox.POS_ABSOLUTE || this.position == BlockBox.POS_FIXED) {
            floating = BlockBox.FLOAT_NONE;
        }
        if (floating != BlockBox.FLOAT_NONE || this.position == BlockBox.POS_ABSOLUTE || this.position == BlockBox.POS_FIXED || this.isRootElement()) {
            if (this.display == DISPLAY_INLINE_TABLE) {
                this.display = DISPLAY_TABLE;
            } else if (this.display == DISPLAY_INLINE || this.display == DISPLAY_RUN_IN || this.display == DISPLAY_TABLE_ROW_GROUP || this.display == DISPLAY_TABLE_COLUMN || this.display == DISPLAY_TABLE_COLUMN_GROUP || this.display == DISPLAY_TABLE_HEADER_GROUP || this.display == DISPLAY_TABLE_FOOTER_GROUP || this.display == DISPLAY_TABLE_ROW || this.display == DISPLAY_TABLE_CELL || this.display == DISPLAY_TABLE_CAPTION || this.display == DISPLAY_INLINE_BLOCK) {
                this.display = DISPLAY_BLOCK;
            }
        }
        this.isblock = this.display == DISPLAY_BLOCK;
        this.displayed = this.display != DISPLAY_NONE && this.display != DISPLAY_TABLE_COLUMN;
        this.visible = this.style.getProperty("visibility") != CSSProperty.Visibility.HIDDEN;
        CSSProperty.LineHeight lh = (CSSProperty.LineHeight)this.style.getProperty("line-height");
        if (lh == null || lh == CSSProperty.LineHeight.NORMAL) {
            this.lineHeight = Math.round(1.12f * (float)this.ctx.getFontHeight());
        } else if (lh == CSSProperty.LineHeight.length) {
            len = (TermLength)this.style.getValue(TermLength.class, "line-height");
            this.lineHeight = (int)this.ctx.pxLength((TermLengthOrPercent)len);
        } else if (lh == CSSProperty.LineHeight.percentage) {
            len = (TermPercent)this.style.getValue(TermPercent.class, "line-height");
            this.lineHeight = (int)this.ctx.pxLength((TermLengthOrPercent)len, this.ctx.getFontHeight());
        } else {
            len = this.style.getValue("line-height", true);
            float r = len instanceof TermInteger ? ((Float)((TermInteger)len).getValue()).floatValue() : ((Float)((TermNumber)len).getValue()).floatValue();
            this.lineHeight = Math.round(r * (float)this.ctx.getFontHeight());
        }
        this.whitespace = (CSSProperty.WhiteSpace)this.style.getProperty("white-space");
        if (this.whitespace == null) {
            this.whitespace = WHITESPACE_NORMAL;
        }
        this.loadBackground();
        CSSProperty.ZIndex z = (CSSProperty.ZIndex)this.style.getProperty("z-index");
        if (z != null && z != CSSProperty.ZIndex.AUTO) {
            this.zset = true;
            Term zterm = this.style.getValue("z-index", true);
            if (zterm instanceof TermInteger) {
                this.zIndex = ((Float)((TermInteger)zterm).getValue()).intValue();
            } else {
                this.zset = false;
            }
        } else {
            this.zset = false;
        }
    }

    protected void loadBackground() {
        CSSProperty.BackgroundColor bg = (CSSProperty.BackgroundColor)this.style.getProperty("background-color");
        if (bg == CSSProperty.BackgroundColor.color) {
            TermColor bgc = (TermColor)this.style.getValue(TermColor.class, "background-color");
            this.bgcolor = (Color)bgc.getValue();
        } else {
            this.bgcolor = null;
        }
        this.bgimages = this.loadBackgroundImages(this.style);
    }

    protected Vector<BackgroundImage> loadBackgroundImages(NodeData style) {
        CSSProperty.BackgroundImage img = (CSSProperty.BackgroundImage)style.getProperty("background-image");
        if (img == CSSProperty.BackgroundImage.uri) {
            try {
                CSSProperty.BackgroundAttachment attachment;
                Vector<BackgroundImage> bgimages = new Vector<BackgroundImage>(1);
                TermURI urlstring = (TermURI)style.getValue(TermURI.class, "background-image");
                URL url = DataURLHandler.createURL((URL)urlstring.getBase(), (String)((String)urlstring.getValue()));
                CSSProperty.BackgroundPosition position = (CSSProperty.BackgroundPosition)style.getProperty("background-position");
                TermList positionValues = (TermList)style.getValue(TermList.class, "background-position");
                CSSProperty.BackgroundRepeat repeat = (CSSProperty.BackgroundRepeat)style.getProperty("background-repeat");
                if (repeat == null) {
                    repeat = CSSProperty.BackgroundRepeat.REPEAT;
                }
                if ((attachment = (CSSProperty.BackgroundAttachment)style.getProperty("background-attachment")) == null) {
                    attachment = CSSProperty.BackgroundAttachment.SCROLL;
                }
                BackgroundImage bgimg = new BackgroundImage(this, url, position, positionValues, repeat, attachment);
                bgimages.add(bgimg);
                return bgimages;
            }
            catch (MalformedURLException e) {
                log.warn(e.getMessage());
                return null;
            }
        }
        return null;
    }

    protected void loadPosition() {
        CSSDecoder dec = new CSSDecoder(this.ctx);
        int contw = this.cblock.getContentWidth();
        int conth = this.cblock.getContentHeight();
        CSSProperty.Top ptop = (CSSProperty.Top)this.style.getProperty("top");
        CSSProperty.Right pright = (CSSProperty.Right)this.style.getProperty("right");
        CSSProperty.Bottom pbottom = (CSSProperty.Bottom)this.style.getProperty("bottom");
        CSSProperty.Left pleft = (CSSProperty.Left)this.style.getProperty("left");
        this.topset = ptop != null && ptop != CSSProperty.Top.AUTO;
        this.rightset = pright != null && pright != CSSProperty.Right.AUTO;
        this.bottomset = pbottom != null && pbottom != CSSProperty.Bottom.AUTO;
        this.leftset = pleft != null && pleft != CSSProperty.Left.AUTO;
        this.coords = new LengthSet();
        if (this.topset) {
            this.coords.top = dec.getLength(this.getLengthValue("top"), ptop == CSSProperty.Top.AUTO, 0, 0, conth);
        }
        if (this.rightset) {
            this.coords.right = dec.getLength(this.getLengthValue("right"), pright == CSSProperty.Right.AUTO, 0, 0, contw);
        }
        if (this.bottomset) {
            this.coords.bottom = dec.getLength(this.getLengthValue("bottom"), pbottom == CSSProperty.Bottom.AUTO, 0, 0, conth);
        }
        if (this.leftset) {
            this.coords.left = dec.getLength(this.getLengthValue("left"), pleft == CSSProperty.Left.AUTO, 0, 0, contw);
        }
    }

    @Override
    protected void updateStackingContexts() {
        super.updateStackingContexts();
        if (this.stackingParent != null && this.position != POS_STATIC) {
            this.stackingParent.getStackingContext().registerChildContext(this);
            if (this.scontext != null) {
                this.scontext.clear();
            }
        }
    }
}

