/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.bookmarksandhistory.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.gvsig.tools.bookmarksandhistory.History;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseHistory<T>
implements History<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseHistory.class);
    protected int maxsize;
    protected List<T> history;

    public BaseHistory(int size) {
        this.maxsize = size;
        this.history = new ArrayList<T>();
    }

    @Override
    public boolean add(T element) {
        T last;
        if (element == null) {
            LOG.warn("Element not been add to history because it's null.");
            return false;
        }
        if (!this.history.isEmpty() && element.equals(last = this.history.get(0))) {
            return true;
        }
        this.history.add(0, element);
        if (this.history.size() > this.maxsize) {
            this.history.remove(this.history.size() - 1);
        }
        return true;
    }

    @Override
    public List<T> toList() {
        return Collections.unmodifiableList(this.history);
    }

    @Override
    public void clear() {
        this.history.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.history.isEmpty();
    }

    @Override
    public int size() {
        return this.history.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.history.iterator();
    }

    @Override
    public T get(int position) {
        return this.history.get(position);
    }

    @Override
    public T getLatest() {
        if (this.history == null || this.history.isEmpty()) {
            return null;
        }
        return this.history.get(0);
    }
}

