/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dataTypes.impl.coercion;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.dataTypes.AbstractCoercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dataTypes.CoercionException;

public class CoerceToURI
extends AbstractCoercion {
    @Override
    public Object coerce(Object value, CoercionContext context) throws CoercionException {
        if (value == null || value instanceof URI) {
            return value;
        }
        if (value instanceof String) {
            if (((String)value).isEmpty()) {
                return null;
            }
            try {
                String strValue = StringUtils.trim((String)((String)value));
                String strValue2 = StringUtils.replace((String)strValue, (String)" ", (String)"%20");
                URI uri = new URI(strValue2);
                String scheme = uri.getScheme();
                if (StringUtils.isEmpty((CharSequence)scheme) || scheme.length() == 1) {
                    uri = new File(strValue).toURI();
                }
                value = uri;
            }
            catch (URISyntaxException e) {
                throw new CoercionException(e);
            }
        } else {
            String s = value.toString();
            if (s == null) {
                return null;
            }
            if ((s = s.trim().toLowerCase()).length() == 0) {
                return null;
            }
            throw new CoercionException();
        }
        return value;
    }
}

