/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dispose.impl;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableInfo;
import org.gvsig.tools.dispose.DisposableManager;
import org.gvsig.tools.dispose.impl.DefaultDisposableInfo;
import org.gvsig.tools.exception.BaseException;

public class DefaultDisposableManager
implements DisposableManager {
    private Map<Disposable, DisposableInfo> boundDisposables = new LinkedHashMap<Disposable, DisposableInfo>();
    private int stackLimit = 2;

    @Override
    public int getStackLimit() {
        return this.stackLimit;
    }

    @Override
    public void setStackLimit(int stackLimit) {
        this.stackLimit = stackLimit;
    }

    @Override
    public synchronized boolean bind(Disposable disposable) {
        DefaultDisposableInfo di = (DefaultDisposableInfo)this.boundDisposables.get(disposable);
        if (di != null) {
            di.incReferencesCount();
            di.addStackTrace("bind", new Throwable().getStackTrace());
            return false;
        }
        di = new DefaultDisposableInfo(disposable, new Throwable().getStackTrace(), this.stackLimit);
        di.incReferencesCount();
        return this.boundDisposables.put(disposable, di) == null;
    }

    @Override
    public synchronized boolean release(Disposable disposable) {
        DefaultDisposableInfo di = (DefaultDisposableInfo)this.boundDisposables.get(disposable);
        if (di != null) {
            di.decReferencesCount();
            if (di.getReferencesCount() > 0) {
                di.addStackTrace("release", new Throwable().getStackTrace());
                return false;
            }
            this.boundDisposables.remove(disposable);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void releaseAll() throws BaseException {
        Iterator<Disposable> iterator = this.boundDisposables.keySet().iterator();
        this.boundDisposables = new LinkedHashMap<Disposable, DisposableInfo>();
        while (iterator.hasNext()) {
            Disposable disposable = iterator.next();
            iterator.remove();
            disposable.dispose();
        }
    }

    @Override
    public synchronized int getBoundDisposableCount() {
        return this.boundDisposables.size();
    }

    @Override
    public synchronized Set<DisposableInfo> getBoundDisposables() {
        LinkedHashSet<DisposableInfo> disposableInfos = new LinkedHashSet<DisposableInfo>(this.boundDisposables.values());
        return disposableInfos;
    }

    @Override
    public DisposableInfo getDisposableInfo(Disposable disposable) {
        return this.boundDisposables.get(disposable);
    }
}

