/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.exception;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.exception.BaseExceptionIterator;
import org.gvsig.tools.exception.ExceptionTranslator;
import org.gvsig.tools.exception.IBaseException;

public abstract class BaseRuntimeException
extends RuntimeException
implements IBaseException {
    private static final long serialVersionUID = 2872163082105463370L;
    protected String messageKey;
    protected String formatString;
    protected long code;
    private Map values;

    public BaseRuntimeException(BaseException exception) {
        super(exception);
    }

    public BaseRuntimeException(Exception exception) {
        super(exception);
    }

    public BaseRuntimeException(String message, String key, long code) {
        super(message);
        this.values = null;
        this.formatString = message;
        this.messageKey = key;
        this.code = code;
    }

    public BaseRuntimeException(String message, Throwable cause, String key, long code) {
        super(message, cause);
        this.formatString = message;
        this.messageKey = key;
        this.code = code;
    }

    private String format(String formatString, Map values) {
        if (values != null) {
            if (formatString == null) {
                return "values = ".concat(values.toString());
            }
            Iterator keys = values.keySet().iterator();
            String message = formatString;
            while (keys.hasNext()) {
                String key;
                Object value = values.get(key = (String)keys.next());
                message = this.replaceVariable(message, key, value == null ? "" : value.toString());
            }
            return message;
        }
        return formatString;
    }

    private String replaceVariable(String text, String varName, String replacementString) {
        String searchString = "%(".concat(varName).concat(")");
        StringBuffer sBuffer = new StringBuffer();
        int pos = 0;
        while ((pos = text.indexOf(searchString)) != -1) {
            sBuffer.append(text.substring(0, pos) + replacementString);
            text = text.substring(pos + searchString.length());
        }
        sBuffer.append(text);
        return sBuffer.toString();
    }

    @Override
    public String getMessage() {
        return this.format(this.formatString, this.values());
    }

    @Override
    public String getMessage(int indent) {
        return BaseException.insertBlanksAtStart(this.format(this.formatString, this.values()), indent);
    }

    @Override
    public String getLocalizedMessage() {
        return this.getLocalizedMessage(BaseException.translator, 0);
    }

    @Override
    public String getLocalizedMessage(ExceptionTranslator translator, int indent) {
        String fmt;
        if (translator == null) {
            translator = BaseException.translator;
        }
        fmt = translator == null ? this.getFormatString() : ((fmt = this.getMessageKey()) == null ? this.getFormatString() : translator.getText(fmt));
        return BaseException.insertBlanksAtStart(this.format(fmt, this.values()), indent);
    }

    @Override
    public String getMessageStack() {
        return this.getMessageStack(0);
    }

    @Override
    public String getMessageStack(int indent) {
        Iterator iter = this.iterator();
        StringBuffer msgBuffer = new StringBuffer();
        int i = 1;
        while (iter.hasNext()) {
            Throwable ex = (Throwable)iter.next();
            if (msgBuffer.length() > 0) {
                msgBuffer.append("\n");
            }
            if (ex instanceof IBaseException) {
                IBaseException bex = (IBaseException)((Object)ex);
                msgBuffer.append(bex.getMessage(indent * i));
            } else {
                msgBuffer.append(BaseException.insertBlanksAtStart(ex.getMessage(), indent * i));
            }
            ++i;
        }
        return msgBuffer.toString();
    }

    @Override
    public String getLocalizedMessageStack() {
        return this.getLocalizedMessageStack(BaseException.translator, 0);
    }

    @Override
    public String getLocalizedMessageStack(ExceptionTranslator translator, int indent) {
        Iterator iter = this.iterator();
        StringBuffer msgBuffer = new StringBuffer();
        while (iter.hasNext()) {
            Exception ex = (Exception)iter.next();
            if (msgBuffer.length() > 0) {
                msgBuffer.append("\n");
            }
            if (ex instanceof IBaseException) {
                IBaseException bex = (IBaseException)((Object)ex);
                msgBuffer.append(bex.getLocalizedMessage(translator, indent));
                continue;
            }
            msgBuffer.append(ex.getLocalizedMessage());
        }
        return msgBuffer.toString();
    }

    @Override
    public long getCode() {
        return this.code;
    }

    public void setCode(long code) {
        this.code = code;
    }

    @Override
    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String formatString) {
        this.formatString = formatString;
    }

    @Override
    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    @Override
    public Iterator iterator() {
        return new BaseExceptionIterator(this);
    }

    protected Map values() {
        if (this.values == null) {
            this.values = new HashMap();
        }
        return this.values;
    }

    @Override
    public Object getValue(String name) {
        return this.values.get(name);
    }

    protected void setValue(String name, Object value) {
        if (this.values == null) {
            this.values = new HashMap();
        }
        this.values.put(name, value);
    }

    @Override
    public String toString() {
        return this.format(this.formatString, this.values());
    }
}

