/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.identitymanagement;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.identitymanagement.SimpleIdentity;
import org.gvsig.tools.identitymanagement.SimpleIdentityManager;
import org.gvsig.tools.identitymanagement.spi.AbstractSimpleIdentity;

public class UnauthorizedException
extends RuntimeException {
    private SimpleIdentity identity;
    private String actionName;
    private Object resource;
    private String resourceName;

    public UnauthorizedException(SimpleIdentity identity, String actionName, Object resource, String resourceName) {
        this.actionName = actionName;
        this.identity = identity;
        this.resource = resource;
        this.resourceName = resourceName;
        if (this.identity == null) {
            SimpleIdentityManager identityManager = ToolsLocator.getIdentityManager();
            this.identity = identityManager.getCurrentIdentity();
        }
    }

    public UnauthorizedException(final String identityId, String actionName, Object resource, String resourceName) {
        this(new AbstractSimpleIdentity(null){

            @Override
            public String getID() {
                return identityId;
            }
        }, actionName, resource, resourceName);
    }

    public UnauthorizedException(String actionName, Object resource, String resourceName) {
        this((SimpleIdentity)null, actionName, resource, resourceName);
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append("User '");
        builder.append(this.identity.getID());
        builder.append("' is not authorized to '");
        builder.append(this.actionName);
        builder.append("'");
        if (!StringUtils.isBlank((CharSequence)this.resourceName)) {
            builder.append(" to resource '");
            builder.append(this.resourceName);
            builder.append("'");
        }
        if (this.resource != null) {
            String s = null;
            try {
                s = this.resource.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (s != null) {
                builder.append(" (");
                builder.append(s);
                builder.append(" )");
            }
        }
        return builder.toString();
    }

    public SimpleIdentity getIdentity() {
        return this.identity;
    }

    public String getActionName() {
        return this.actionName;
    }

    public Object getResource() {
        return this.resource;
    }

    public String getResourceAsString() {
        String s = null;
        try {
            s = this.resource.toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return s;
    }

    public String getResourceName() {
        return this.resourceName;
    }
}

