/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.identitymanagement.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gvsig.tools.identitymanagement.Rule;
import org.gvsig.tools.identitymanagement.SimpleIdentity;
import org.gvsig.tools.identitymanagement.SimpleIdentityManager;

public abstract class AbstractSimpleIdentity
implements SimpleIdentity {
    protected final SimpleIdentityManager manager;

    public AbstractSimpleIdentity(SimpleIdentityManager manager) {
        this.manager = manager;
    }

    public SimpleIdentityManager getManager() {
        return this.manager;
    }

    @Override
    public boolean isAuthenticated() {
        return true;
    }

    @Override
    public String getName() {
        return this.getID();
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public List getAttributeNames() {
        return null;
    }

    @Override
    public String getAttribute(String name) {
        return null;
    }

    @Override
    public boolean isAuthorized(String actionName) {
        return this.isAuthorized(actionName, null, null);
    }

    @Override
    public boolean isAuthorized(String actionName, Object resource, String resourceName) {
        List<Rule> localRules;
        if (this.manager == null) {
            return false;
        }
        Collection<Rule> rules = this.manager.getRules();
        if (rules != null && !rules.isEmpty()) {
            for (Rule rule : rules) {
                if (!rule.accept(actionName) || rule.isAuthorized(this, actionName, resource, resourceName)) continue;
                return false;
            }
        }
        if ((localRules = this.getRules()) != null) {
            for (Rule rule : this.getRules()) {
                if (!rule.accept(actionName) || rule.isAuthorized(this, actionName, resource, resourceName)) continue;
                return false;
            }
        }
        return true;
    }

    protected List<Rule> getRules() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean canRead(Object resource, String resourceName) {
        return this.isAuthorized("access--read", resource, resourceName);
    }

    @Override
    public boolean canWrite(Object resource, String resourceName) {
        return this.isAuthorized("access--write", resource, resourceName);
    }

    @Override
    public List<String> getRoles() {
        return Collections.EMPTY_LIST;
    }
}

