/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.observer;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.gvsig.tools.observer.Notification;

public class BaseNotification
implements Notification {
    private final String type;
    protected Object[] values;
    protected boolean canceled = false;
    private boolean aborted;
    private Throwable abortCause;

    public BaseNotification(String type, int values) {
        this.type = type;
        this.values = new Object[values];
    }

    public BaseNotification(String type, Object[] values) {
        this.type = type;
        this.values = values;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isOfType(String type) {
        return type.equalsIgnoreCase(this.type);
    }

    @Override
    public Object getValue() {
        if (this.values == null) {
            return null;
        }
        return this.values[0];
    }

    @Override
    public Object getValue(int n) {
        if (this.values == null) {
            return null;
        }
        return this.values[n];
    }

    @Override
    public void setValue(Object value) {
        this.values[0] = value;
    }

    @Override
    public void setValue(int n, Object value) {
        this.values[n] = value;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public void abort() {
        this.aborted = true;
    }

    public String toString() {
        try {
            ToStringBuilder builder = new ToStringBuilder((Object)this);
            builder.append("type", (Object)this.type);
            builder.append("values", this.values);
            return builder.build();
        }
        catch (Throwable th) {
            return super.toString();
        }
    }

    @Override
    public void abort(Throwable cause) {
        this.abort();
        this.abortCause = cause;
    }

    @Override
    public Throwable getAbortCause() {
        return this.abortCause;
    }
}

