/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.packageutils.impl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.installer.lib.api.Dependencies;
import org.gvsig.installer.lib.api.Version;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.packageutils.PackageInfo;
import org.gvsig.tools.packageutils.PackageManager;
import org.gvsig.tools.packageutils.StringWithAlias;
import org.gvsig.tools.packageutils.impl.DefaultDependencies;
import org.gvsig.tools.packageutils.impl.DefaultStringWithAlias;
import org.gvsig.tools.packageutils.impl.DefaultVersion;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPackageInfo
implements PackageInfo {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPackageInfo.class);
    private static PackageManager packageManager = null;
    private static final String PACKAGE_NAME_FORMAT = "gvSIG-desktop-{0}-{1}-{2}-{4}-{5}-{6}-{7}.gvspkg";
    private static final String DEFAULT_MODEL_VERSION = "1.0.1";
    private static final String DEFAULT_TYPE = "unknow";
    private StringWithAlias code = null;
    private String name = null;
    private String description = null;
    private Version version = null;
    private boolean official;
    private String type = "unknow";
    private boolean broken = false;
    private String state = "devel";
    private String operatingSystemFamily = "all";
    private String operatingSystemName = null;
    private String operatingSystemVersion = null;
    private String architecture = "all";
    private String javaVM = "j1_5";
    private String owner = "";
    private URL ownerURL = null;
    private URL sources = null;
    private Version applicationVersion = null;
    private String defaultDownloadURL = null;
    private String modelVersion = "1.0.1";
    private Dependencies dependencies = null;
    private List categories = null;
    private URL webURL = null;
    private String postInstallScript = null;
    private Map aditionalProperties = null;
    private static final String SPACES256 = "                                                                                                                                                                                                                                                               ";

    public DefaultPackageInfo() {
        PackageManager manager = ToolsLocator.getPackageManager();
        this.version = manager.createVersion().parse("0.0.1");
        this.applicationVersion = manager.createVersion().parse("0.0.1");
        this.dependencies = manager.createDependencies();
        this.categories = new ArrayList();
        this.aditionalProperties = new HashMap();
    }

    private PackageManager getPackageManager() {
        if (packageManager == null) {
            packageManager = ToolsLocator.getPackageManager();
        }
        return packageManager;
    }

    @Override
    public String getCode() {
        if (this.code == null) {
            return null;
        }
        return this.code.toString();
    }

    @Override
    public StringWithAlias getAllCodes() {
        return this.code;
    }

    private String getAliasAsString() {
        if (this.code == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        Iterator alias = this.code.getAlias().iterator();
        while (alias.hasNext()) {
            String ss = (String)alias.next();
            s.append(ss);
            if (!alias.hasNext()) continue;
            s.append(", ");
        }
        return s.toString();
    }

    @Override
    public boolean hasThisCode(String code) {
        if (this.code == null) {
            return code == null;
        }
        return this.code.equalsIgnoreCase(code);
    }

    @Override
    public boolean hasThisCode(StringWithAlias code) {
        if (this.code == null) {
            return code == null;
        }
        return this.code.equalsIgnoreCase(code);
    }

    @Override
    public String getID() {
        String id = this.getCode() + "#" + this.getVersion() + "#" + this.getOperatingSystem() + "#" + this.getArchitecture();
        return id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public boolean isOfficial() {
        return this.official;
    }

    @Override
    public void setCode(String code) {
        this.code = code == null ? null : new DefaultStringWithAlias(code);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setVersion(Version version) {
        try {
            this.version = (Version)version.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setState(String state) {
        this.state = StringUtils.isBlank((CharSequence)state) ? "devel" : state;
    }

    @Override
    public void setOfficial(boolean official) {
        this.official = official;
    }

    @Override
    public String getOperatingSystem() {
        StringBuilder operatingSystem = new StringBuilder();
        operatingSystem.append(this.operatingSystemFamily);
        if (!StringUtils.isEmpty((CharSequence)this.operatingSystemName)) {
            operatingSystem.append("_");
            operatingSystem.append(this.operatingSystemName);
            if (!StringUtils.isEmpty((CharSequence)this.operatingSystemVersion)) {
                operatingSystem.append("_");
                operatingSystem.append(this.operatingSystemVersion);
            }
        }
        return operatingSystem.toString();
    }

    @Override
    public void setOperatingSystem(String operatingSystem) {
        if (StringUtils.isBlank((CharSequence)operatingSystem)) {
            this.operatingSystemFamily = "all";
            this.operatingSystemName = null;
            this.operatingSystemVersion = null;
        } else if (operatingSystem.contains("_")) {
            String[] s = operatingSystem.split("_");
            switch (s.length) {
                case 2: {
                    this.operatingSystemFamily = s[0];
                    this.operatingSystemName = s[1];
                    break;
                }
                case 3: {
                    this.operatingSystemFamily = s[0];
                    this.operatingSystemName = s[1];
                    this.operatingSystemVersion = s[2];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Can't parse OS '" + operatingSystem + "'.");
                }
            }
        } else {
            this.operatingSystemFamily = operatingSystem;
        }
    }

    @Override
    public String getOperatingSystemFamily() {
        return this.operatingSystemFamily;
    }

    @Override
    public String getOperatingSystemName() {
        return this.operatingSystemName;
    }

    @Override
    public String getOperatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    @Override
    public void setOperatingSystemFamily(String operatingSystemFamily) {
        this.operatingSystemFamily = operatingSystemFamily;
    }

    @Override
    public void setOperatingSystemName(String operatingSystemName) {
        this.operatingSystemName = operatingSystemName;
    }

    @Override
    public void setOperatingSystemVersion(String operatingSystemVersion) {
        this.operatingSystemVersion = operatingSystemVersion;
    }

    @Override
    public String getArchitecture() {
        return this.architecture;
    }

    @Override
    public void setArchitecture(String architecture) {
        this.architecture = StringUtils.isBlank((CharSequence)architecture) ? "all" : architecture;
    }

    @Override
    public String getJavaVM() {
        return this.javaVM;
    }

    @Override
    public void setJavaVM(String javaVM) {
        this.javaVM = StringUtils.isBlank((CharSequence)javaVM) ? "j1_5" : javaVM;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = StringUtils.isBlank((CharSequence)type) ? DEFAULT_TYPE : type;
    }

    @Override
    public Version getApplicationVersion() {
        return this.applicationVersion;
    }

    @Override
    public void setApplicationVersion(Version applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    @Override
    public URL getDownloadURL() {
        if (this.defaultDownloadURL == null) {
            return null;
        }
        try {
            return new URL(this.defaultDownloadURL);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public String getDownloadURLAsString() {
        return this.defaultDownloadURL;
    }

    @Override
    public void setDownloadURL(URL defaultDownloadURL) {
        this.defaultDownloadURL = defaultDownloadURL.toString();
    }

    @Override
    public void setDownloadURL(String defaultDownloadURL) {
        this.defaultDownloadURL = defaultDownloadURL;
    }

    @Override
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Override
    public void setModelVersion(String modelVersion) {
        this.modelVersion = StringUtils.isBlank((CharSequence)modelVersion) ? DEFAULT_MODEL_VERSION : modelVersion;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public URL getOwnerURL() {
        return this.ownerURL;
    }

    @Override
    public void setOwnerURL(URL sources) {
        this.ownerURL = sources;
    }

    @Override
    public URL getSourcesURL() {
        return this.sources;
    }

    @Override
    public void setSourcesURL(URL sources) {
        this.sources = sources;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString()).append(" (");
        this.append(buffer, "code", this.getCode());
        this.append(buffer, "name", this.getName());
        this.append(buffer, "description", this.getDescription());
        this.append(buffer, "application-version", this.getApplicationVersion());
        this.append(buffer, "version", this.getVersion());
        this.append(buffer, "operating-system", this.getOperatingSystem());
        this.append(buffer, "architecture", this.getArchitecture());
        this.append(buffer, "java-version", this.getJavaVM());
        this.append(buffer, "download-url", this.getDownloadURL());
        this.append(buffer, "state", this.getState());
        this.append(buffer, "official", this.isOfficial());
        this.append(buffer, "type", this.getType());
        this.append(buffer, "model-version", this.getModelVersion());
        this.append(buffer, "owner", this.getOwner());
        this.append(buffer, "owner-url", this.getOwnerURL());
        this.append(buffer, "sources-url", this.getSourcesURL());
        this.append(buffer, "dependencies", this.getDependencies());
        this.append(buffer, "web-url", this.getWebURL());
        this.append(buffer, "categories", this.getCategories());
        this.append(buffer, "code-alias", this.getAliasAsString());
        return buffer.append(')').toString();
    }

    @Override
    public String toStringCompact() {
        StringBuffer s = new StringBuffer();
        s.append(this.strformat(this.type, -8, -4));
        s.append(" ");
        s.append(this.strformat(this.code, -40, 0));
        s.append(" ");
        s.append(this.strformat(this.version, -20, -20));
        s.append(" ");
        s.append(this.strformat(this.state, -5, -5));
        s.append(" ");
        s.append(this.strformat(this.getOperatingSystem(), -5, -5));
        s.append(" ");
        s.append(this.strformat(this.architecture, -6, -6));
        s.append(" ");
        s.append(this.strformat(this.javaVM, -5, -5));
        s.append(" ");
        s.append(this.strformat(this.dependencies, -8, 0));
        s.append(" ");
        s.append(this.strformat(this.getAliasAsString(), -8, 0));
        return s.toString();
    }

    private String strformat(Object o, int min, int max) {
        boolean alignright = true;
        String s = o == null ? "null" : o.toString();
        if (min < 0) {
            min = -min;
            alignright = false;
        }
        if (max == 0) {
            if (s.length() < min) {
                if (alignright) {
                    s = SPACES256 + s;
                    s = s.substring(s.length() - min);
                } else {
                    s = (s + SPACES256).substring(0, min);
                }
            }
        } else {
            if (max > 225) {
                max = 256;
            } else if (max < 0) {
                max = -max;
                alignright = false;
            }
            if (alignright) {
                if (s.length() > max) {
                    s = s.substring(0, max);
                }
                if (s.length() < min) {
                    s = SPACES256.substring(0, min - s.length()) + s;
                }
            } else {
                if (s.length() > max) {
                    s = s.substring(0, max);
                }
                if (s.length() < min) {
                    s = s + SPACES256.substring(0, min - s.length());
                }
            }
        }
        return s;
    }

    private DefaultPackageInfo append(StringBuffer buffer, String key, Object value) {
        buffer.append("\n\t").append(key).append(": ").append(value == null ? "" : value);
        return this;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultPackageInfo other = (DefaultPackageInfo)super.clone();
        other.dependencies = this.dependencies == null ? null : (Dependencies)this.dependencies.clone();
        other.version = (Version)this.version.clone();
        other.applicationVersion = (Version)this.applicationVersion.clone();
        other.categories = new ArrayList();
        other.categories.addAll(this.categories);
        other.aditionalProperties = new HashMap(this.aditionalProperties);
        return other;
    }

    @Override
    public boolean matchID(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return false;
        }
        String id = this.getID();
        String[] stringParts = string.split("#");
        switch (stringParts.length) {
            case 1: {
                return stringParts[0].equals(this.getCode());
            }
            case 2: {
                if (!stringParts[0].equals(this.getCode())) {
                    return false;
                }
                DefaultVersion theVersion = new DefaultVersion();
                try {
                    theVersion.parse(stringParts[1]);
                }
                catch (InvalidParameterException ex) {
                    return false;
                }
                return ((Object)theVersion).equals(this.getVersion());
            }
            case 4: {
                if (!stringParts[0].equals(this.getCode())) {
                    return false;
                }
                if (!"any".equalsIgnoreCase(stringParts[1])) {
                    DefaultVersion theVersion = new DefaultVersion();
                    try {
                        theVersion.parse(stringParts[1]);
                    }
                    catch (InvalidParameterException ex) {
                        return false;
                    }
                    if (!((Object)theVersion).equals(this.getVersion())) {
                        return false;
                    }
                }
                if (!"any".equalsIgnoreCase(stringParts[2]) && ("current".equalsIgnoreCase(stringParts[2]) ? !this.getOperatingSystem().equalsIgnoreCase(this.getPackageManager().getOperatingSystem()) : !this.getOperatingSystem().equalsIgnoreCase(stringParts[2]))) {
                    return false;
                }
                return "any".equalsIgnoreCase(stringParts[3]) || !("current".equalsIgnoreCase(stringParts[3]) ? !this.getArchitecture().equalsIgnoreCase(this.getPackageManager().getArchitecture()) : !this.getArchitecture().equalsIgnoreCase(stringParts[3]));
            }
        }
        return string.equals(id);
    }

    @Override
    public Dependencies getDependencies() {
        return this.dependencies;
    }

    @Override
    public void setDependencies(Dependencies dependencies) {
        this.dependencies = dependencies;
    }

    @Override
    public void setDependencies(String dependencies) {
        this.dependencies = StringUtils.isBlank((CharSequence)dependencies) ? null : new DefaultDependencies().parse(dependencies);
    }

    public boolean equals(Object obj) {
        PackageInfo other;
        try {
            other = (PackageInfo)obj;
        }
        catch (Exception e) {
            return false;
        }
        if (!this.code.equalsIgnoreCase(other.getCode())) {
            return false;
        }
        if (!this.version.check("=", other.getVersion())) {
            return false;
        }
        if (!this.getOperatingSystem().equalsIgnoreCase(other.getOperatingSystem())) {
            return false;
        }
        if (!this.applicationVersion.equals(other.getApplicationVersion())) {
            return false;
        }
        if (!this.state.equalsIgnoreCase(other.getState())) {
            return false;
        }
        if (!this.architecture.equalsIgnoreCase(other.getArchitecture())) {
            return false;
        }
        if (!this.javaVM.equalsIgnoreCase(other.getJavaVM())) {
            return false;
        }
        if (!this.type.equalsIgnoreCase(other.getType())) {
            return false;
        }
        return this.official == other.isOfficial();
    }

    @Override
    public URL getWebURL() {
        return this.webURL;
    }

    @Override
    public void setWebURL(URL webURL) {
        this.webURL = webURL;
    }

    @Override
    public List getCategories() {
        return this.categories;
    }

    @Override
    public void setCategories(List categoriesList) {
        for (int i = 0; i < categoriesList.size(); ++i) {
            String s;
            if (this.categories.contains(categoriesList.get(i)) || StringUtils.isEmpty((CharSequence)(s = (String)categoriesList.get(i)))) continue;
            this.categories.add(s.trim());
        }
    }

    @Override
    public String getCategoriesAsString() {
        String categoriesString = "";
        for (int i = 0; i < this.categories.size(); ++i) {
            categoriesString = i + 1 < this.categories.size() ? categoriesString + this.categories.get(i) + "," : categoriesString + this.categories.get(i);
        }
        return categoriesString;
    }

    @Override
    public void addCategoriesAsString(String categoriesString) {
        if (StringUtils.isBlank((CharSequence)categoriesString)) {
            return;
        }
        String[] cadena = StringUtils.split((String)categoriesString.trim(), (String)",");
        for (int i = 0; i < cadena.length; ++i) {
            String category = cadena[i];
            if (StringUtils.isEmpty((CharSequence)category) || this.categories.contains(category = category.trim())) continue;
            this.categories.add(category);
        }
    }

    @Override
    public boolean isBroken() {
        return this.broken;
    }

    @Override
    public String getPostInstallScript() {
        return this.postInstallScript;
    }

    @Override
    public void setPostInstallScript(String script) {
        this.postInstallScript = script;
    }

    protected void setBroken(boolean broken) {
        this.broken = broken;
    }

    @Override
    public void setValue(String name, Object value) {
        this.aditionalProperties.put(name, value);
    }

    @Override
    public Object getValue(String name) {
        return this.aditionalProperties.get(name);
    }

    private Object[] getPackageNameFormatParameters() {
        Object[] parameters = new Object[]{this.getApplicationVersion().toString(), this.getCode(), this.getVersion(), this.getVersion().getBuild(), this.getState(), this.getOperatingSystem(), this.getArchitecture(), this.getJavaVM()};
        return parameters;
    }

    @Override
    public String getPreferedPackageFileName() {
        Object[] parameters = this.getPackageNameFormatParameters();
        return MessageFormat.format(PACKAGE_NAME_FORMAT, parameters);
    }

    @Override
    public int getBuild() {
        return this.getVersion().getBuild();
    }

    @Override
    public void setBuild(int build) {
        this.getVersion().setBuild(build);
    }

    @Override
    public String getGvSIGVersion() {
        Version v = this.getApplicationVersion();
        return v.getMajor() + "." + v.getMinor() + "." + v.getRevision();
    }

    @Override
    public void setGvSIGVersion(String gvSIGVersion) {
        this.getApplicationVersion().parse(gvSIGVersion);
    }

    @Override
    public URL getDownloadURL(URL baseURL) {
        logger.info("Deprecated method, ignore parameter baseURL.");
        return this.getOwnerURL();
    }

    @Override
    public String getAntScript() {
        return this.getPostInstallScript();
    }

    @Override
    public void setAntScript(String antScript) {
        this.setPostInstallScript(antScript);
    }

    @Override
    public File downloadFile() throws BaseException {
        throw new UnsupportedOperationException();
    }

    @Override
    public File downloadFile(SimpleTaskStatus taskStatus) throws BaseException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addFileToCopy(File file) {
        throw new UnsupportedOperationException();
    }

    @Override
    public File getFileToCopy(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeFileToCopy(File file) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearFilesToCopy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List getFilesToCopy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeInstallFolder(File folder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeFilesFolder(File folder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public void checkSignature(byte[] pkgdata) {
    }

    @Override
    public void setVersion(String version) {
        this.version.parse(version);
    }

    public static interface PACKAGE_FILE_NAME_FIELDS {
        public static final int GVSIG_VERSION = 0;
        public static final int NAME = 1;
        public static final int VERSION = 2;
        public static final int BUILD = 3;
        public static final int STATE = 4;
        public static final int OS = 5;
        public static final int ARCH = 6;
        public static final int JVM = 7;
    }
}

