/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.packageutils.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import org.gvsig.tools.packageutils.PackageInfo;

public class PackageInfoFileWriter {
    public void write(PackageInfo packageInfo, String fileName) throws IOException {
        this.write(packageInfo, new File(fileName));
    }

    public void write(PackageInfo packageInfo, File file) throws IOException {
        this.write(packageInfo, new FileOutputStream(file));
    }

    public void write(PackageInfo pkg, OutputStream os) throws IOException {
        Properties props = new Properties();
        props.setProperty("code", pkg.getCode());
        String codealias1 = null;
        List codealias2 = pkg.getAllCodes().getAlias();
        for (int i = 0; i < codealias2.size(); ++i) {
            codealias1 = codealias1 == null ? ((String)codealias2.get(i)).trim() : codealias1 + "," + ((String)codealias2.get(i)).trim();
        }
        if (codealias1 == null) {
            codealias1 = "";
        }
        props.setProperty("code-alias", this.toStr(codealias1));
        props.setProperty("name", this.toStr(pkg.getName()));
        props.setProperty("description", this.toStr(pkg.getDescription()));
        props.setProperty("version", pkg.getVersion().toString());
        props.setProperty("state", this.toStr(pkg.getState()));
        props.setProperty("official", Boolean.toString(pkg.isOfficial()));
        props.setProperty("type", this.toStr(pkg.getType()));
        props.setProperty("operating-system", this.toStr(pkg.getOperatingSystem()));
        props.setProperty("architecture", this.toStr(pkg.getArchitecture()));
        props.setProperty("java-version", this.toStr(pkg.getJavaVM()));
        props.setProperty("application-version", this.toStr(pkg.getApplicationVersion()));
        props.setProperty("owner", this.toStr(pkg.getOwner()));
        props.setProperty("categories", this.toStr(pkg.getCategoriesAsString()));
        props.setProperty("dependencies", this.toStr(pkg.getDependencies()));
        props.setProperty("sources-url", this.toStr(pkg.getSourcesURL()));
        props.setProperty("web-url", this.toStr(pkg.getWebURL()));
        props.setProperty("download-url", this.toStr(pkg.getDownloadURLAsString()));
        props.setProperty("owner-url", this.toStr(pkg.getOwnerURL()));
        props.setProperty("model-version", this.toStr(pkg.getModelVersion()));
        props.store(os, "");
        os.close();
    }

    private String toStr(Object s) {
        return s == null ? "" : s.toString();
    }
}

