/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.persistence.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableInt;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.dynobject.exception.DynMethodException;
import org.gvsig.tools.dynobject.exception.DynObjectValidateException;
import org.gvsig.tools.dynobject.impl.DefaultDynClassName;
import org.gvsig.tools.exception.ListBaseException;
import org.gvsig.tools.persistence.PersistenceFactory;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.AddDefinitionException;
import org.gvsig.tools.persistence.exception.DuplicatePersistentDefinitionException;
import org.gvsig.tools.persistence.exception.FieldNotDeclaredException;
import org.gvsig.tools.persistence.exception.PersistenceClassNotRegistered;
import org.gvsig.tools.persistence.exception.PersistenceCreateException;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.persistence.exception.PersistenceTypeNotSupportedException;
import org.gvsig.tools.persistence.exception.PersistenceValidateExceptions;
import org.gvsig.tools.persistence.exception.PersistenceWriteExeption;
import org.gvsig.tools.persistence.impl.DefaultFactories;
import org.gvsig.tools.persistence.impl.DefaultPersistentContext;
import org.gvsig.tools.persistence.impl.DelegatedList;
import org.gvsig.tools.persistence.impl.DelegatedMap;
import org.gvsig.tools.persistence.impl.DelegatedSet;
import org.gvsig.tools.persistence.impl.Domains;
import org.gvsig.tools.persistence.impl.SimplePersistenceFactory;
import org.gvsig.tools.persistence.impl.exception.CantFindDefinitionInStreamException;
import org.gvsig.tools.persistence.impl.exception.PersistenceDomainNotRegisterdException;
import org.gvsig.tools.persistence.impl.exception.PersistenceIllegalStateTheClassNameNotSetException;
import org.gvsig.tools.persistence.impl.exception.PersistenceInvalidValidateModeException;
import org.gvsig.tools.persistence.impl.exception.PersistenceValidateMissingDefinitionException;
import org.gvsig.tools.persistence.spi.PersistenceManagerServices;
import org.gvsig.tools.persistence.spi.PersistentContextServices;
import org.gvsig.tools.persistence.spi.PersistentStateServices;
import org.gvsig.tools.util.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;

public abstract class AbstractPersistenceManager
implements PersistenceManagerServices {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPersistenceManager.class);
    private PersistenceManager.Factories factories;
    private Domains domainsURL = new Domains();
    private int autoValidationMode = 0;
    private MutableInt globalReferenceCounter;

    protected AbstractPersistenceManager() {
        this.factories = new DefaultFactories();
        this.globalReferenceCounter = new MutableInt(0);
    }

    protected AbstractPersistenceManager(PersistenceManager.Factories factories) {
        this.factories = factories;
        this.globalReferenceCounter = new MutableInt(0);
    }

    @Override
    public void addAlias(String name, Class aClass) throws PersistenceClassNotRegistered {
        PersistenceFactory factory = this.factories.get(aClass.getName());
        this.factories.add(factory, aClass.getName());
    }

    @Override
    public PersistenceManager.Factories getFactories() {
        return this.factories;
    }

    @Override
    public PersistentContextServices getNewContext() {
        return new DefaultPersistentContext(this, this.globalReferenceCounter);
    }

    @Override
    public PersistentContextServices getNewContext(MutableInt referenceCounter) {
        return new DefaultPersistentContext(this, referenceCounter);
    }

    @Override
    public Object create(PersistentState state) throws PersistenceException {
        String className = state.getTheClassName();
        if (className == null) {
            throw new PersistenceIllegalStateTheClassNameNotSetException();
        }
        PersistentContextServices context = this.getContext(state);
        PersistentContextServices.ObjectReference ref = context.get(state);
        return ref.getObject();
    }

    @Override
    public Object getObject(InputStream is) {
        Object obj = null;
        PersistentState state = null;
        String theClassName = null;
        try {
            state = this.loadState(is);
            theClassName = state.getTheClassName();
            obj = this.create(state);
        }
        catch (PersistenceException e) {
            throw new PersistenceCreateException(theClassName, (Throwable)e);
        }
        return obj;
    }

    @Override
    public void putObject(OutputStream os, Object obj) {
        try {
            PersistentState state = this.getState(obj);
            this.saveState(state, os);
        }
        catch (PersistenceException e) {
            throw new PersistenceWriteExeption((Throwable)e);
        }
    }

    @Override
    public DynStruct getDefinition(Class persistentClass) {
        return this.getDefinition(persistentClass.getName());
    }

    @Override
    public DynStruct getDefinition(String className) {
        PersistenceFactory factory = this.factories.get(className);
        if (factory == null) {
            return null;
        }
        return factory.getDefinition(className);
    }

    @Override
    public DynStruct getDynObjectDefinition(String className) {
        DefaultDynClassName dynClassName = new DefaultDynClassName("PersistenceDynObject", className);
        PersistenceFactory factory = this.factories.get(dynClassName.getFullName());
        if (factory == null) {
            return null;
        }
        return factory.getDefinition(dynClassName.getFullName());
    }

    private PersistentContextServices getContext(PersistentState state) {
        return (PersistentContextServices)state.getContext();
    }

    @Override
    public void validate(PersistentState state, int mode) throws PersistenceValidateExceptions {
        if (mode == 0) {
            return;
        }
        ArrayList<ListBaseException> exceptions = new ArrayList<ListBaseException>();
        DynStruct definition = state.getDefinition();
        if (definition == null) {
            if (mode == 3) {
                exceptions.add(new PersistenceValidateMissingDefinitionException(state.getTheClassName()));
                throw new PersistenceValidateExceptions(state.getTheClassName(), exceptions);
            }
            return;
        }
        PersistentStateServices state2 = (PersistentStateServices)state;
        Iterator it = state2.getNames();
        while (it.hasNext()) {
            String name = (String)it.next();
            DynField field = definition.getDynField(name);
            if (field != null) continue;
            exceptions.add(new FieldNotDeclaredException(name, state.getTheClassName()));
        }
        DynObjectToPersistentStateAdapter dynAdapter = new DynObjectToPersistentStateAdapter(state, definition);
        try {
            definition.validate(dynAdapter);
        }
        catch (DynObjectValidateException e) {
            exceptions.add(e);
        }
        if (exceptions.size() > 0) {
            throw new PersistenceValidateExceptions(state.getTheClassName(), exceptions);
        }
    }

    @Override
    public void validateAll(PersistentState state, int mode) throws PersistenceValidateExceptions {
        if (mode == 0) {
            return;
        }
        PersistentContextServices context = this.getContext(state);
        context.validate(this.autoValidationMode);
    }

    @Override
    public int getAutoValidation() {
        return this.autoValidationMode;
    }

    @Override
    public void setAutoValidation(int validationMode) throws PersistenceException {
        switch (validationMode) {
            case 0: 
            case 2: 
            case 3: {
                this.autoValidationMode = validationMode;
                break;
            }
            default: {
                throw new PersistenceInvalidValidateModeException(validationMode);
            }
        }
    }

    @Override
    public PersistentState getState(Object obj) throws PersistenceException, PersistenceValidateExceptions, PersistenceTypeNotSupportedException {
        return this.getState(obj, false, this.globalReferenceCounter);
    }

    @Override
    public PersistentState getState(Object obj, boolean collectAllErrors) throws PersistenceException {
        return this.getState(obj, collectAllErrors, this.globalReferenceCounter);
    }

    @Override
    public PersistentState getState(Object obj, boolean collectAllErrors, MutableInt referenceCounter) throws PersistenceException {
        PersistentStateServices state = null;
        if (collectAllErrors) {
            PersistentContextServices context = this.getNewContext(referenceCounter);
            context.setCollectErrors(true);
            try {
                state = this.createState(obj, context);
                context.setRootId(state.getId());
                if (this.autoValidationMode != 0) {
                    context.validate(this.autoValidationMode);
                }
            }
            catch (PersistenceException ex) {
                context.addError(ex);
            }
        } else {
            PersistentContextServices context = this.getNewContext(referenceCounter);
            state = this.createState(obj, context);
            context.setRootId(state.getId());
            this.validateAll(state, this.autoValidationMode);
        }
        return state;
    }

    @Override
    public PersistentStateServices createState(Object object, PersistentContextServices context) throws PersistenceException {
        if (object instanceof Validator && !((Validator)object).isValid(object, new Object[0])) {
            throw new PersistenceValidateExceptions(object.getClass().getName(), Collections.singletonList(((Validator)object).getCause()));
        }
        PersistentStateServices state = this.createPersistentState(context);
        state.setTheClassName(object.getClass().getName());
        context.add(state, object);
        PersistenceFactory factory = this.factories.get(object);
        if (factory == null) {
            throw new PersistenceTypeNotSupportedException(object.getClass());
        }
        state.setFactory(factory);
        state.setTheClassName(factory.getManagedClassName(object));
        factory.saveToState(state, object);
        return state;
    }

    @Override
    public List getWrappedList(List list, PersistentContextServices context) {
        return new DelegatedList(list, (PersistenceManagerServices)this, context);
    }

    @Override
    public Map getWrappedMap(Map map, PersistentContextServices context) {
        return new DelegatedMap(map, this, context);
    }

    @Override
    public Set getWrappedSet(Set set, PersistentContextServices context) {
        return new DelegatedSet(set, (PersistenceManagerServices)this, context);
    }

    @Override
    public Map getDomains() {
        return Collections.unmodifiableMap(this.domainsURL);
    }

    @Override
    public List getDomainDefinitions(String domainName) {
        if (!this.domainsURL.containsKey(domainName)) {
            throw new PersistenceDomainNotRegisterdException(domainName);
        }
        ArrayList definitions = new ArrayList();
        for (PersistenceFactory factory : this.factories) {
            List factDefinitions;
            if (!factory.getDomainName().equals(domainName) || (factDefinitions = factory.getDefinitions()) == null) continue;
            definitions.addAll(factDefinitions);
        }
        return definitions;
    }

    @Override
    public DynStruct addDefinition(Class theClass, String name, String description, String domainName, String domainUrl) {
        DynObjectManager dynman = ToolsLocator.getDynObjectManager();
        DynClass definition = dynman.createDynClass("Persistence", name, description);
        return this.addDefinition(theClass, definition, domainName, domainUrl);
    }

    @Override
    public DynStruct addDefinition(Class theClass, String name, InputStream definitions, ClassLoader loader, String domainName, String domainUrl) {
        Map x;
        DynObjectManager dynman = ToolsLocator.getDynObjectManager();
        try {
            x = dynman.importDynClassDefinitions(definitions, loader, "Persistence");
        }
        catch (XmlPullParserException e) {
            throw new AddDefinitionException(e);
        }
        catch (IOException e) {
            throw new AddDefinitionException((Throwable)e);
        }
        DynClass definition = (DynClass)x.get(name);
        if (definition == null) {
            throw new CantFindDefinitionInStreamException(name, this.getKeys(x));
        }
        return this.addDefinition(theClass, definition, domainName, domainUrl);
    }

    @Override
    public DynStruct updateDefinition(Class theClass, String name, InputStream definitions, ClassLoader loader, String domainName, String domainUrl) {
        Map x;
        DynObjectManager dynman = ToolsLocator.getDynObjectManager();
        try {
            x = dynman.importDynClassDefinitions(definitions, loader, "Persistence");
        }
        catch (XmlPullParserException e) {
            throw new AddDefinitionException(e);
        }
        catch (IOException e) {
            throw new AddDefinitionException((Throwable)e);
        }
        DynClass definition = (DynClass)x.get(name);
        if (definition == null) {
            throw new CantFindDefinitionInStreamException(name, this.getKeys(x));
        }
        definition.setNamespace("PersistenceDynObject");
        dynman.remove(definition);
        return this.addDefinition(theClass, definition, domainName, domainUrl);
    }

    private String getKeys(Map theMap) {
        ArrayList l = new ArrayList(theMap.keySet());
        return ((Object)l).toString();
    }

    @Override
    public DynStruct addDefinition(Class theClass, String name, Map definitions, String domainName, String domainUrl) {
        DynClass definition = (DynClass)definitions.get(name);
        return this.addDefinition(theClass, definition, domainName, domainUrl);
    }

    protected DynStruct addDefinition(Class theClass, DynClass definition, String domainName, String domainUrl) {
        if (theClass == DynObject.class) {
            return this.addDefinition(definition, domainName, domainUrl);
        }
        DynObjectManager dynman = ToolsLocator.getDynObjectManager();
        if (theClass.equals(DynObject.class)) {
            definition.setNamespace("PersistenceDynObject");
        } else {
            definition.setNamespace("Persistence");
        }
        if (dynman.get(definition.getNamespace(), definition.getName()) != null) {
            throw new DuplicatePersistentDefinitionException(definition.getName());
        }
        dynman.add(definition);
        SimplePersistenceFactory factory = new SimplePersistenceFactory(theClass, definition, domainName, domainUrl);
        this.factories.add(factory);
        this.domainsURL.add(factory.getDomainName(), factory.getDomainURL());
        LOG.trace("Add persistence definition {}.", new Object[]{definition.getFullName()});
        return definition;
    }

    @Override
    public DynStruct addDefinition(DynStruct definition, String domainName, String domainUrl) throws AddDefinitionException {
        DynObjectManager dynman = ToolsLocator.getDynObjectManager();
        definition.setNamespace("PersistenceDynObject");
        if (dynman.get(definition.getNamespace(), definition.getName()) != null) {
            throw new DuplicatePersistentDefinitionException(definition.getFullName());
        }
        dynman.add((DynClass)definition);
        PersistenceFactory factory = this.factories.get(definition.getFullName());
        this.domainsURL.add(factory.getDomainName(), factory.getDomainURL());
        LOG.trace("Add persistence definition {}.", new Object[]{definition.getFullName()});
        return definition;
    }

    @Override
    public void registerFactory(PersistenceFactory factory) {
        this.factories.add(factory);
        this.domainsURL.add(factory.getDomainName(), factory.getDomainURL());
        LOG.trace("Add persistence factory {}.", new Object[]{factory.getClass().getName()});
    }

    @Override
    public void unregisterClass(Class theClass) {
        PersistenceFactory factory = this.factories.get(theClass.getName());
        if (factory == null) {
            return;
        }
        DynObjectManager dynman = ToolsLocator.getDynObjectManager();
        DynStruct definition = factory.getDefinition(theClass.getName());
        dynman.remove(definition);
        this.factories.remove(factory);
        this.domainsURL.remove(factory.getDomainName());
    }

    @Override
    public void unregisterClass(String name) {
        PersistenceFactory factory = this.factories.get(name);
        if (factory == null) {
            return;
        }
        DynObjectManager dynman = ToolsLocator.getDynObjectManager();
        this.factories.remove(factory);
        this.domainsURL.remove(factory.getDomainName());
        DynStruct definition = factory.getDefinition(name);
        dynman.remove(definition);
    }

    @Override
    public void unregisterFactory(PersistenceFactory factory) {
        DynObjectManager dynman = ToolsLocator.getDynObjectManager();
        this.factories.remove(factory);
        this.domainsURL.remove(factory.getDomainName());
        List definitions = factory.getDefinitions();
        if (definitions != null) {
            for (DynStruct definition : definitions) {
                dynman.remove(definition);
            }
        }
    }

    @Override
    public PersistentStateServices createPersistentState(PersistentContextServices context) {
        return this.createPersistentState(context, context.getNewIdentifier());
    }

    @Override
    public PersistentState loadState(InputStream in) throws PersistenceException {
        return this.loadState(in, this.getNewContext());
    }

    @Override
    public void addDefinition(Class theClass, String name, String resourceName) {
        if (this.getDefinition(name) == null) {
            InputStream resource = theClass.getResourceAsStream(resourceName);
            if (resource == null) {
                throw new IllegalArgumentException("Resource '" + resourceName + "' not found as a resource of '" + theClass.getName() + "'.");
            }
            this.addDefinition(theClass, name, resource, theClass.getClassLoader(), null, null);
        }
    }

    @Override
    public void addDefinition(Class theClass, String name, InputStream resource) {
        if (this.getDefinition(name) == null) {
            if (resource == null) {
                throw new IllegalArgumentException("resource null not allowed.");
            }
            this.addDefinition(theClass, name, resource, theClass.getClassLoader(), null, null);
        }
    }

    private class DynObjectToPersistentStateAdapter
    implements DynObject {
        private PersistentState state;
        private DynStruct struct;

        DynObjectToPersistentStateAdapter(PersistentState state, DynStruct struct) {
            this.state = state;
            this.struct = struct;
        }

        @Override
        public void delegate(DynObject dynObject) {
        }

        @Override
        public DynClass getDynClass() {
            return null;
        }

        @Override
        public Object getDynValue(String name) throws DynFieldNotFoundException {
            try {
                return this.state.get(name);
            }
            catch (PersistenceException e) {
                throw new DynFieldNotFoundException(name, this.struct.getName());
            }
        }

        @Override
        public boolean hasDynValue(String name) {
            return this.state.hasValue(name);
        }

        @Override
        public void implement(DynClass dynClass) {
        }

        @Override
        public Object invokeDynMethod(String name, Object[] args) throws DynMethodException {
            return null;
        }

        @Override
        public Object invokeDynMethod(int code, Object[] args) throws DynMethodException {
            return null;
        }

        @Override
        public void setDynValue(String name, Object value) throws DynFieldNotFoundException {
        }

        @Override
        public void clear() {
        }
    }
}

