/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.persistence.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.gvsig.tools.persistence.impl.DelegatedContainer;
import org.gvsig.tools.persistence.spi.PersistenceManagerServices;
import org.gvsig.tools.persistence.spi.PersistentContextServices;

public class DelegatedCollection
extends DelegatedContainer
implements Collection {
    private final Collection delegated;

    public DelegatedCollection(Collection delegated, PersistenceManagerServices manager, PersistentContextServices context) {
        super(manager, context);
        this.delegated = delegated;
    }

    public boolean add(Object arg0) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegated.contains(this.getWrapper(o));
    }

    public boolean containsAll(Collection arg0) {
        Iterator iter = arg0.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.delegated.isEmpty();
    }

    @Override
    public Iterator iterator() {
        Iterator it = this.delegated.iterator();
        return this.getWrappedIterator(it);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection arg0) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        Object[] r = new Object[this.size()];
        Iterator iter = this.iterator();
        int i = 0;
        while (iter.hasNext()) {
            r[i] = iter.next();
            ++i;
        }
        return r;
    }

    public Object[] toArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator iter = this.iterator();
        int i = 0;
        while (iter.hasNext()) {
            a[i] = iter.next();
            ++i;
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public int size() {
        return this.delegated.size();
    }

    protected ListIterator getWrappedIterator(Iterator iterator) {
        class DelegatedIterator
        implements ListIterator {
            private final Iterator delegated;
            private ListIterator delegatedListIterator;

            public DelegatedIterator(Iterator deletaged) {
                this.delegated = deletaged;
                if (deletaged instanceof ListIterator) {
                    this.delegatedListIterator = (ListIterator)deletaged;
                }
            }

            @Override
            public boolean hasNext() {
                return this.delegated.hasNext();
            }

            @Override
            public Object next() {
                Object o = null;
                while (this.delegated.hasNext()) {
                    Object referece = this.delegated.next();
                    try {
                        o = DelegatedCollection.this.getObject(referece);
                    }
                    catch (Exception ex) {
                        if (DelegatedCollection.this.getContext().getCollectErrors()) {
                            DelegatedCollection.this.getContext().addError(ex);
                        }
                        throw ex;
                    }
                    if (o == null) continue;
                    break;
                }
                return o;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void add(Object arg0) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasPrevious() {
                if (this.delegatedListIterator == null) {
                    throw new UnsupportedOperationException();
                }
                return this.delegatedListIterator.hasPrevious();
            }

            @Override
            public int nextIndex() {
                if (this.delegatedListIterator == null) {
                    throw new UnsupportedOperationException();
                }
                return this.delegatedListIterator.nextIndex();
            }

            public Object previous() {
                if (this.delegatedListIterator == null) {
                    throw new UnsupportedOperationException();
                }
                return DelegatedCollection.this.getObject(this.delegatedListIterator.previous());
            }

            @Override
            public int previousIndex() {
                if (this.delegatedListIterator == null) {
                    throw new UnsupportedOperationException();
                }
                return this.delegatedListIterator.previousIndex();
            }

            public void set(Object arg0) {
                throw new UnsupportedOperationException();
            }
        }
        return new DelegatedIterator(iterator);
    }
}

