/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.persistence.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistentContext;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.persistence.exception.PersistenceValidateExceptions;
import org.gvsig.tools.persistence.spi.PersistentContextServices;
import org.gvsig.tools.persistence.spi.PersistentStateServices;
import org.gvsig.tools.persistence.xml.XMLPersistenceManager;
import org.gvsig.tools.persistence.xml.XMLPersistentStateWriter;
import org.gvsig.tools.persistence.xml.ZipXMLSchemaConstants;
import org.gvsig.tools.persistence.xml.exception.PersistenceMissingEntryInZIPException;
import org.gvsig.tools.persistence.xml.exception.PersistenceUnssuportedDefinitionTypeException;

public class ZipXMLPersistenceManager
extends XMLPersistenceManager {
    private static final String PERSISTENT_ZIP_ENTRY_NAME = "state.xml";
    private static final String BASE_SCHEMA_ENTRY_NAME = "state_base.xsd";

    @Override
    public PersistentState loadState(InputStream in, PersistentContext context) throws PersistenceException {
        ZipInputStream zIn = new ZipInputStream(in);
        try {
            ZipEntry zEntry;
            while ((zEntry = zIn.getNextEntry()) != null) {
                if (!zEntry.getName().equals(PERSISTENT_ZIP_ENTRY_NAME)) continue;
                return super.loadState(zIn, context);
            }
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        throw new PersistenceMissingEntryInZIPException(PERSISTENT_ZIP_ENTRY_NAME);
    }

    @Override
    public void saveState(PersistentState state, OutputStream out, boolean collectErrors) throws PersistenceException, PersistenceValidateExceptions {
        ((PersistentContextServices)state.getContext()).setCollectErrors(collectErrors);
        ZipOutputStream zOut = out instanceof ZipOutputStream ? (ZipOutputStream)out : new ZipOutputStream(out);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        PersistentContextServices context = (PersistentContextServices)state.getContext();
        try {
            int readed;
            if (this.getAutoValidation() != 0) {
                try {
                    context.validate(this.getAutoValidation());
                }
                catch (PersistenceValidateExceptions ex) {
                    exceptions.add(ex);
                }
            }
            zOut.putNextEntry(new ZipEntry(PERSISTENT_ZIP_ENTRY_NAME));
            XMLPersistentStateWriter xmlWriter = this.getWriterInstance();
            xmlWriter.write((PersistentStateServices)state, zOut, this.getDomains());
            zOut.putNextEntry(new ZipEntry(BASE_SCHEMA_ENTRY_NAME));
            InputStream baseSchemaIs = ZipXMLPersistenceManager.class.getResourceAsStream("persistentState_base.xsd");
            byte[] buff = new byte[5120];
            while ((readed = baseSchemaIs.read(buff)) > 0) {
                zOut.write(buff, 0, readed);
            }
            baseSchemaIs.close();
            Map domains = this.getDomains();
            for (Map.Entry entry : domains.entrySet()) {
                zOut.putNextEntry(new ZipEntry(entry.getKey() + ".xsd"));
                try {
                    this.writeSchema(zOut, (String)entry.getKey(), (String)entry.getValue());
                }
                catch (CantGenerateXMLSchemaForDomainException ex) {
                    exceptions.add(ex);
                }
            }
            if (!(out instanceof ZipOutputStream)) {
                zOut.finish();
            }
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        if (exceptions.size() > 0) {
            if (context.getCollectErrors()) {
                context.addError(new CantSaveStateException(exceptions));
            } else {
                throw new CantSaveStateException(exceptions);
            }
        }
    }

    private void writeSchema(OutputStream out, String domainName, String domainURL) throws PersistenceException {
        PrintWriter printer = new PrintWriter(out);
        printer.println(MessageFormat.format(ZipXMLSchemaConstants.XSD_HEAD_VALUE, domainName, domainURL));
        ArrayList<CantGenerateXMLSchemaForDefinitionException> exceptions = new ArrayList<CantGenerateXMLSchemaForDefinitionException>();
        List domainDefinitions = this.getDomainDefinitions(domainName);
        for (DynStruct definition : domainDefinitions) {
            try {
                this.writeClassDefinitionSchema(printer, definition.getName(), definition);
            }
            catch (CantGenerateXMLSchemaForDefinitionException ex) {
                exceptions.add(ex);
            }
        }
        printer.println("</xs:schema>");
        printer.flush();
        if (exceptions.size() > 0) {
            throw new CantGenerateXMLSchemaForDomainException(domainName, exceptions);
        }
    }

    private void writeClassDefinitionSchema(PrintWriter printer, String className, DynStruct definition) throws PersistenceException {
        ArrayList<PersistenceUnssuportedDefinitionTypeException> exceptions = new ArrayList<PersistenceUnssuportedDefinitionTypeException>();
        printer.print(MessageFormat.format("    <xs:element name=\"{0}\">\n      <xs:complexType>\n        <xs:all>\n", className));
        DynField[] fields = definition.getDynFields();
        String typeId = "";
        for (int i = 0; i < fields.length; ++i) {
            boolean allowNull;
            DynField field = fields[i];
            if (!field.isPersistent()) continue;
            boolean bl = allowNull = field.isMandatory() && field.getDefaultValue() == null;
            if (field.getDataType().isObject() || field.getDataType().isDynObject()) {
                typeId = allowNull ? "tools:state_attribute_ObjectReference" : "tools:state_attribute_ObjectReference_notNull";
            } else {
                switch (field.getType()) {
                    case 8: 
                    case 13: 
                    case 14: 
                    case 16: 
                    case 17: {
                        if (allowNull) {
                            typeId = "tools:state_attribute_String";
                            break;
                        }
                        typeId = "tools:state_attribute_String_notNull";
                        break;
                    }
                    case 1: {
                        if (allowNull) {
                            typeId = "tools:state_attribute_Boolean";
                            break;
                        }
                        typeId = "tools:state_attribute_Boolean_notNull";
                        break;
                    }
                    case 4: {
                        if (allowNull) {
                            typeId = "tools:state_attribute_Integer";
                            break;
                        }
                        typeId = "tools:state_attribute_Integer_notNull";
                        break;
                    }
                    case 5: {
                        if (allowNull) {
                            typeId = "tools:state_attribute_Long";
                            break;
                        }
                        typeId = "tools:state_attribute_Long_notNull";
                        break;
                    }
                    case 6: {
                        if (allowNull) {
                            typeId = "tools:state_attribute_Float";
                            break;
                        }
                        typeId = "tools:state_attribute_Float_notNull";
                        break;
                    }
                    case 7: {
                        if (allowNull) {
                            typeId = "tools:state_attribute_Float";
                            break;
                        }
                        typeId = "tools:state_attribute_Float_notNull";
                        break;
                    }
                    case 35: {
                        if (allowNull) {
                            typeId = "tools:state_attribute_Set";
                            break;
                        }
                        typeId = "tools:state_attribute_Set_notNull";
                        break;
                    }
                    case 34: {
                        if (allowNull) {
                            typeId = "tools:state_attribute_List";
                            break;
                        }
                        typeId = "tools:state_attribute_List_notNull";
                        break;
                    }
                    case 33: {
                        if (allowNull) {
                            typeId = "tools:state_attribute_List";
                            break;
                        }
                        typeId = "tools:state_attribute_List_notNull";
                        break;
                    }
                    case 36: {
                        if (allowNull) {
                            typeId = "tools:state_attribute_Map";
                            break;
                        }
                        typeId = "tools:state_attribute_Map_notNull";
                        break;
                    }
                    case 9: {
                        if (allowNull) {
                            typeId = "tools:state_attribute_Date";
                            break;
                        }
                        typeId = "tools:state_attribute_Date_notNull";
                        break;
                    }
                    default: {
                        exceptions.add(new PersistenceUnssuportedDefinitionTypeException(className, definition, field));
                    }
                }
            }
            if (field.isMandatory()) {
                printer.print(MessageFormat.format("          <xs:element name=\"{0}\" type=\"{1}\" minOccurs=\"1\"/>\n", field.getName(), typeId));
                continue;
            }
            printer.print(MessageFormat.format("          <xs:element name=\"{0}\" type=\"{1}\"/>\n", field.getName(), typeId));
        }
        printer.println("        </xs:all>\n        <xs:attributeGroup ref=\"tools:state_attributes\"/>\n      </xs:complexType>\n    </xs:element>\n");
        if (exceptions.size() > 0) {
            throw new CantGenerateXMLSchemaForDefinitionException(className, exceptions);
        }
    }

    public class CantSaveStateException
    extends PersistenceException {
        private static final long serialVersionUID = 7255882015705477288L;

        CantSaveStateException(List exceptions) {
            super("Can't save state.", "_Cant_save_state", 7255882015705477288L);
            this.addAll((Collection)exceptions);
        }
    }

    public class CantGenerateXMLSchemaForDomainException
    extends PersistenceException {
        private static final long serialVersionUID = 2828756207089264709L;

        CantGenerateXMLSchemaForDomainException(String domainName, List exceptions) {
            super("Can't generate xml schema definition for domain '%(domain).", "_Cant_generate_xml_schema_definition_for_domain_XdomainX", 2828756207089264709L);
            this.addAll((Collection)exceptions);
            this.setValue("domain", domainName);
        }
    }

    public class CantGenerateXMLSchemaForDefinitionException
    extends PersistenceException {
        private static final long serialVersionUID = 2828756207089264709L;

        CantGenerateXMLSchemaForDefinitionException(String className, List exceptions) {
            super("Can't generate xml schema definition for the class %(classname).", "_Cant_generate_xml_schema_definition_for_the_class_XclassnameX", 2828756207089264709L);
            this.addAll((Collection)exceptions);
            this.setValue("classname", className);
        }
    }
}

