/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.resourcesstorage;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;

public abstract class AbstractResourcesStorage
extends AbstractDisposable
implements ResourcesStorage {
    @Override
    public String getSeparator() {
        return ".";
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public List<ResourcesStorage.Resource> getResources(String resourceName) {
        String multiresourceName;
        ResourcesStorage.Resource res;
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<ResourcesStorage.Resource> ress = new ArrayList<ResourcesStorage.Resource>();
        int n = 0;
        while ((res = this.getResource(multiresourceName = n == 0 ? resourceName : String.valueOf(n) + this.getSeparator() + resourceName)).exists()) {
            ress.add(res);
            ++n;
        }
        if (ress.isEmpty()) {
            return null;
        }
        return ress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String name) {
        if (this.isEmpty()) {
            return false;
        }
        try (ResourcesStorage.Resource res = null;){
            res = this.getResource(name);
            boolean bl = res.exists();
            return bl;
        }
    }

    @Override
    public ResourcesStorage.Resource getLocalizedResource(String resourceName) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        Locale currentlocale = i18n.getCurrentLocale();
        if (currentlocale != null) {
            String localizedName = currentlocale.getLanguage() + this.getSeparator() + resourceName;
            if (this.exists(localizedName)) {
                return this.getResource(localizedName);
            }
            List<Locale> locales = i18n.getPreferredLocales();
            if (locales != null) {
                for (Locale locale : locales) {
                    localizedName = locale.getLanguage() + this.getSeparator() + resourceName;
                    if (!this.exists(localizedName)) continue;
                    return this.getResource(localizedName);
                }
            }
        }
        return this.getResource(resourceName);
    }

    @Override
    public List<ResourcesStorage.Resource> getLocalizedResources(String resourceName) {
        String multiresourceName;
        ResourcesStorage.Resource res;
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<ResourcesStorage.Resource> ress = new ArrayList<ResourcesStorage.Resource>();
        int n = 0;
        while ((res = this.getLocalizedResource(multiresourceName = n == 0 ? resourceName : resourceName + this.getSeparator() + String.valueOf(n))).exists()) {
            ress.add(res);
            ++n;
        }
        if (ress.isEmpty()) {
            return null;
        }
        return ress;
    }

    @Override
    public List<String> getResourceNames() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean add(String resourceName, InputStream is) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean remove(String resourceName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean allowRemove() {
        return false;
    }

    @Override
    protected void doDispose() throws BaseException {
    }

    @Override
    public void clearCache() {
    }

    public static abstract class AbstractResource
    implements ResourcesStorage.Resource {
        protected String name;

        protected AbstractResource(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

