/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.resourcesstorage;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.resourcesstorage.MultiResourcesStorage;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;

public class BaseMultiResourcesStorage
extends AbstractDisposable
implements MultiResourcesStorage {
    private final List<ResourcesStorage> storages = new ArrayList<ResourcesStorage>();

    @Override
    public List<ResourcesStorage> getResourcesPaths() {
        return this.storages;
    }

    @Override
    public String getSeparator() {
        if (this.storages.isEmpty()) {
            return ".";
        }
        return this.storages.get(0).getSeparator();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ResourcesStorage.Resource getResource(String resourceName) {
        for (ResourcesStorage storage : this.storages) {
            ResourcesStorage.Resource res = storage.getResource(resourceName);
            if (!res.exists()) continue;
            return res;
        }
        return null;
    }

    @Override
    public List<ResourcesStorage.Resource> getResources(String resourceName) {
        for (ResourcesStorage storage : this.storages) {
            List<ResourcesStorage.Resource> res = storage.getResources(resourceName);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    @Override
    public ResourcesStorage.Resource getLocalizedResource(String resourceName) {
        ResourcesStorage.Resource res = null;
        for (ResourcesStorage storage : this.storages) {
            res = storage.getResource(resourceName);
            if (!res.exists()) continue;
            return res;
        }
        return res;
    }

    @Override
    public List<ResourcesStorage.Resource> getLocalizedResources(String resourceName) {
        for (ResourcesStorage storage : this.storages) {
            List<ResourcesStorage.Resource> res = storage.getLocalizedResources(resourceName);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    @Override
    public boolean exists(String resourceName) {
        for (ResourcesStorage storage : this.storages) {
            if (!storage.exists(resourceName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getResourceNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (ResourcesStorage storage : this.storages) {
            names.addAll(storage.getResourceNames());
        }
        return names;
    }

    @Override
    public boolean remove(String resourceName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean add(String resourceName, InputStream is) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean allowRemove() {
        return false;
    }

    @Override
    protected void doDispose() throws BaseException {
        for (ResourcesStorage storage : this.storages) {
            storage.dispose();
        }
        this.storages.clear();
    }

    @Override
    public void clearCache() {
        if (this.storages == null) {
            return;
        }
        for (ResourcesStorage storage : this.storages) {
            if (storage == null) continue;
            storage.clearCache();
        }
    }
}

