/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.service;

import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.service.Service;
import org.gvsig.tools.service.ServiceException;
import org.gvsig.tools.service.spi.AbstractProviderServices;
import org.gvsig.tools.service.spi.Provider;
import org.gvsig.tools.service.spi.ProviderManager;
import org.gvsig.tools.service.spi.ProviderServices;

public abstract class AbstractService
implements Service {
    private DynObject serviceParameters;
    private ProviderServices providerServices;
    private Provider provider;

    public AbstractService() {
    }

    public AbstractService(DynObject serviceParameters) throws ServiceException {
        this.init(serviceParameters, this.createProviderServices());
    }

    public DynObject getServiceParameters() {
        return this.serviceParameters;
    }

    protected void init(DynObject serviceParameters, ProviderServices providerServices) throws ServiceException {
        this.setServiceParameters(serviceParameters);
        this.setProviderServices(providerServices);
        this.setProvider(this.createProvider(serviceParameters));
        ((AbstractProviderServices)providerServices).setService(this);
    }

    protected Provider getProvider() {
        return this.provider;
    }

    protected ProviderServices getProviderServices() {
        return this.providerServices;
    }

    protected abstract ProviderManager getProviderManager();

    private void setServiceParameters(DynObject serviceParameters) {
        this.serviceParameters = serviceParameters;
    }

    private void setProvider(Provider provider) {
        this.provider = provider;
    }

    private Provider createProvider(DynObject serviceParameters) throws ServiceException {
        return this.getProviderManager().createProvider(serviceParameters, this.providerServices);
    }

    private ProviderServices createProviderServices() {
        return this.getProviderManager().createProviderServices(this);
    }

    private void setProviderServices(ProviderServices providerServices) {
        this.providerServices = providerServices;
    }
}

