/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.service.spi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.service.Service;
import org.gvsig.tools.service.ServiceException;
import org.gvsig.tools.service.spi.NotRegisteredException;
import org.gvsig.tools.service.spi.ParametersException;
import org.gvsig.tools.service.spi.ServiceFactory;
import org.gvsig.tools.service.spi.ServiceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceManager
implements ServiceManager {
    private static final Logger logger = LoggerFactory.getLogger(AbstractServiceManager.class);

    @Override
    public void addServiceFactory(ServiceFactory serviceFactory) {
        ExtensionPointManager epm = ToolsLocator.getExtensionPointManager();
        ExtensionPoint ep = epm.add(this.getRegistryKey(), this.getRegistryDescription());
        ep.append(serviceFactory.getName(), null, serviceFactory);
        serviceFactory.initialize();
        logger.info(this.getName() + " register service '" + serviceFactory.getName() + "' factory " + serviceFactory.getClass().getName() + ".");
    }

    protected String getName() {
        String s = this.getClass().getName();
        try {
            String[] x = s.split(".");
            return x[x.length - 1];
        }
        catch (Exception ex) {
            return s;
        }
    }

    protected abstract String getRegistryKey();

    protected abstract String getRegistryDescription();

    @Override
    public Service createService(DynObject serviceParameters) throws ServiceException {
        String serviceName = serviceParameters.getDynClass().getName();
        ServiceFactory factory = this.getServiceFactory(serviceName);
        return factory == null ? null : factory.create(serviceParameters, this);
    }

    @Override
    public DynObject createServiceParameters(String serviceName) throws ServiceException {
        return this.getServiceFactory(serviceName).createParameters();
    }

    protected ServiceFactory getServiceFactory(String serviceName) throws ParametersException, NotRegisteredException {
        ExtensionPointManager epm = ToolsLocator.getExtensionPointManager();
        ExtensionPoint ep = epm.get(this.getRegistryKey());
        ServiceFactory factory = null;
        try {
            factory = (ServiceFactory)ep.create(serviceName);
        }
        catch (InstantiationException e) {
            throw new ParametersException("Can't instance service factory", e);
        }
        catch (IllegalAccessException e) {
            throw new ParametersException("Can't access service factory", e);
        }
        if (factory == null) {
            throw new NotRegisteredException(serviceName);
        }
        return factory;
    }

    public List getServiceFactories() {
        ArrayList<ServiceFactory> factories = new ArrayList<ServiceFactory>();
        ExtensionPointManager epm = ToolsLocator.getExtensionPointManager();
        ExtensionPoint ep = epm.add(this.getRegistryKey(), this.getRegistryDescription());
        Iterator it = ep.iterator();
        while (it.hasNext()) {
            ExtensionPoint.Extension extension = (ExtensionPoint.Extension)it.next();
            try {
                ServiceFactory factory = (ServiceFactory)extension.create();
                factories.add(factory);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return factories;
    }
}

