/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.util.CompareUtils;
import org.gvsig.tools.util.GetItem;
import org.gvsig.tools.util.GetItem64;
import org.gvsig.tools.util.GetItemByKey;
import org.gvsig.tools.util.GetKeys;
import org.gvsig.tools.util.IsEmpty;
import org.gvsig.tools.util.Size;
import org.gvsig.tools.util.Size64;
import org.gvsig.tools.util.UnmodifiableBasicCollection;

public class ContainerUtils {
    public static final Comparator<String> EQUALS_IGNORECASE_COMPARATOR = (o1, o2) -> StringUtils.compareIgnoreCase((String)o1, (String)o2);

    private ContainerUtils() {
    }

    public static long size64(Size64 x) {
        return x.size64();
    }

    public static long size64(Size x) {
        return x.size();
    }

    public static long size64(Collection x) {
        return x.size();
    }

    public static long size64(Map x) {
        return x.size();
    }

    public static long size64(Object[] x) {
        return x.length;
    }

    public static long size64(Object x) {
        if (x instanceof Size64) {
            return ((Size64)x).size64();
        }
        if (x instanceof Collection) {
            return ((Collection)x).size();
        }
        if (x instanceof Map) {
            return ((Map)x).size();
        }
        if (x instanceof Size) {
            return ((Size)x).size();
        }
        if (x instanceof Object[]) {
            return ((Object[])x).length;
        }
        if (x instanceof Iterator) {
            long i = 0L;
            while (((Iterator)x).hasNext()) {
                ((Iterator)x).next();
                ++i;
            }
            return i;
        }
        if (x instanceof Iterable) {
            Iterator it = ((Iterable)x).iterator();
            long i = 0L;
            while (it.hasNext()) {
                it.next();
                ++i;
            }
            return i;
        }
        return -1L;
    }

    public static int size(Size x) {
        return x.size();
    }

    public static long size(Size64 x) {
        return x.size64();
    }

    public static long size(Collection x) {
        return x.size();
    }

    public static long size(Map x) {
        return x.size();
    }

    public static long size(Object[] x) {
        return x.length;
    }

    public static int size(Object x) {
        long sz;
        if (x instanceof Size) {
            return ((Size)x).size();
        }
        if (x instanceof Collection) {
            return ((Collection)x).size();
        }
        if (x instanceof Map) {
            return ((Map)x).size();
        }
        if (x instanceof Size64 && (sz = ((Size64)x).size64()) <= Integer.MAX_VALUE) {
            return (int)sz;
        }
        if (x instanceof Object[]) {
            return ((Object[])x).length;
        }
        if (x instanceof Iterator) {
            int i = 0;
            while (((Iterator)x).hasNext()) {
                ((Iterator)x).next();
                ++i;
            }
            return i;
        }
        if (x instanceof Iterable) {
            Iterator it = ((Iterable)x).iterator();
            int i = 0;
            while (it.hasNext()) {
                it.next();
                ++i;
            }
            return i;
        }
        return -1;
    }

    public static Boolean isEmpty(IsEmpty x, boolean defaultValue) {
        return x.isEmpty();
    }

    public static Boolean isEmpty(Collection x, boolean defaultValue) {
        return x.isEmpty();
    }

    public static Boolean isEmpty(Map x, boolean defaultValue) {
        return x.isEmpty();
    }

    public static Boolean isEmpty(Object x, boolean defaultValue) {
        if (x instanceof IsEmpty) {
            return ((IsEmpty)x).isEmpty();
        }
        if (x instanceof Collection) {
            return ((Collection)x).isEmpty();
        }
        if (x instanceof Map) {
            return ((Map)x).isEmpty();
        }
        if (x instanceof Iterator) {
            return ((Iterator)x).hasNext();
        }
        if (x instanceof Iterable) {
            Iterator it = ((Iterable)x).iterator();
            return it.hasNext();
        }
        return defaultValue;
    }

    public static Object get64(GetItem64 x, long position) {
        return x.get64(position);
    }

    public static Object get64(GetItem x, long position) {
        if (position > Integer.MAX_VALUE) {
            return null;
        }
        return x.get((int)position);
    }

    public static Object get64(List x, long position) {
        if (position > Integer.MAX_VALUE) {
            return null;
        }
        return x.get((int)position);
    }

    public static Object get64(Object[] x, long position) {
        if (position > Integer.MAX_VALUE) {
            return null;
        }
        return x[(int)position];
    }

    public static Object get64(Object x, long position) {
        if (x instanceof GetItem64) {
            return ((GetItem64)x).get64(position);
        }
        if (position > Integer.MAX_VALUE) {
            return null;
        }
        if (x instanceof List) {
            return ((List)x).get((int)position);
        }
        if (x instanceof GetItem) {
            return ((GetItem)x).get((int)position);
        }
        if (x instanceof Object[]) {
            return ((Object[])x)[(int)position];
        }
        return null;
    }

    public static Object get64(Object x, Object key) {
        return ContainerUtils.get(x, key);
    }

    public static Object get(GetItem x, int position) {
        return x.get(position);
    }

    public static Object get(Object x, int position) {
        if (x instanceof GetItem) {
            return ((GetItem)x).get(position);
        }
        if (x instanceof List) {
            return ((List)x).get(position);
        }
        if (x instanceof GetItem64) {
            return ((GetItem64)x).get64(position);
        }
        if (x instanceof Object[]) {
            return ((Object[])x)[position];
        }
        return null;
    }

    public static Object get(Object x, Object key) {
        if (x instanceof GetItemByKey) {
            return ((GetItemByKey)x).get(key);
        }
        if (x instanceof Map) {
            return ((Map)x).get(key);
        }
        if (key instanceof Number) {
            if (x instanceof GetItem) {
                return ((GetItem)x).get(((Number)key).intValue());
            }
            if (x instanceof List) {
                return ((List)x).get(((Number)key).intValue());
            }
            if (x instanceof GetItem64) {
                return ((GetItem64)x).get64(((Number)key).longValue());
            }
            if (x instanceof Object[]) {
                return ((Object[])x)[((Number)key).intValue()];
            }
        }
        return null;
    }

    public static List getKeys(GetKeys x) {
        return x.getKeys();
    }

    public static List getKeys(Object x) {
        if (x instanceof GetKeys) {
            return ((GetKeys)x).getKeys();
        }
        if (x instanceof Map) {
            return new ArrayList(((Map)x).keySet());
        }
        return null;
    }

    public static Iterator getKeysIterator(Object x) {
        if (x instanceof GetKeys) {
            return ((GetKeys)x).getKeys().iterator();
        }
        if (x instanceof Map) {
            return ((Map)x).keySet().iterator();
        }
        return null;
    }

    public static boolean notContains(Collection collection, Object value, Comparator comparator) {
        if (collection == null) {
            return false;
        }
        if (comparator == null) {
            comparator = EQUALS_IGNORECASE_COMPARATOR;
        }
        for (Object item : collection) {
            if (comparator.compare((String)item, (String)value) != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Collection collection, Object value, Comparator comparator) {
        if (collection == null) {
            return false;
        }
        if (comparator == null) {
            comparator = EQUALS_IGNORECASE_COMPARATOR;
        }
        for (Object item : collection) {
            if (comparator.compare((String)item, (String)value) != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(UnmodifiableBasicCollection collection, Object value, Comparator comparator) {
        if (collection == null) {
            return false;
        }
        for (Object item : collection) {
            if (CompareUtils.compare(comparator, item, item, true) != 0) continue;
            return true;
        }
        return false;
    }
}

