/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.tika.detect.AutoDetectReader;
import org.xml.sax.InputSource;

public class IOTools {
    private IOTools() {
    }

    public static InputSource createReaderInputSource(File file) {
        try {
            return IOTools.createReaderInputSource(new FileInputStream(file), file.getAbsolutePath());
        }
        catch (FileNotFoundException ex) {
            return null;
        }
    }

    public static InputSource createReaderInputSource(InputStream in) {
        return IOTools.createReaderInputSource(in, null);
    }

    public static InputSource createReaderInputSource(InputStream in, String publicId) {
        try {
            AutoDetectReader reader = new AutoDetectReader(in);
            Charset charset = reader.getCharset();
            InputSource is = new InputSource();
            is.setPublicId(publicId);
            is.setCharacterStream((Reader)reader);
            if (charset != null) {
                is.setEncoding(charset.name());
            }
            return is;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static InputSource createStreamInputSource(InputStream in, String publicId) {
        try {
            BufferedInputStream bin = new BufferedInputStream(in);
            bin.mark(4096);
            AutoDetectReader reader = new AutoDetectReader((InputStream)bin);
            bin.reset();
            Charset charset = reader.getCharset();
            InputSource is = new InputSource();
            is.setPublicId(publicId);
            is.setByteStream(bin);
            if (charset != null) {
                is.setEncoding(charset.name());
            }
            return is;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static void closeQuietly(InputSource is) {
        if (is == null) {
            return;
        }
        IOUtils.closeQuietly((InputStream)is.getByteStream());
        IOUtils.closeQuietly((Reader)is.getCharacterStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Charset detectCharset(File file) {
        Charset charset;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            charset = IOTools.detectCharset(is);
        }
        catch (Exception ex) {
            Charset charset2;
            try {
                charset2 = StandardCharsets.UTF_8;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            return charset2;
        }
        IOUtils.closeQuietly((InputStream)is);
        return charset;
    }

    public static String detectCharsetName(File file) {
        Charset charset = IOTools.detectCharset(file);
        if (charset == null) {
            return null;
        }
        return charset.name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Charset detectCharset(InputStream is) {
        Charset charset;
        AutoDetectReader reader = null;
        try {
            reader = new AutoDetectReader(is);
            charset = reader.getCharset();
        }
        catch (Throwable t) {
            Charset charset2;
            try {
                charset2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)reader);
            return charset2;
        }
        IOUtils.closeQuietly((Reader)reader);
        return charset;
    }

    public static String detectCharsetName(InputStream is) {
        Charset charset = IOTools.detectCharset(is);
        if (charset == null) {
            return null;
        }
        return charset.name();
    }
}

