/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.border;

import ch.randelshofer.quaqua.util.Images;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.border.Border;

public class ImageBevelBorder
implements Border {
    private static final boolean VERBOSE = false;
    private Image image;
    private Insets borderInsets;
    private Insets imageInsets;
    private boolean fillContentArea;
    private Color fillColor;

    public ImageBevelBorder(Image img, Insets borderInsets) {
        this(img, borderInsets, borderInsets, true, null);
    }

    public ImageBevelBorder(Image img, Insets imageInsets, Insets borderInsets) {
        this(img, imageInsets, borderInsets, true, null);
    }

    public ImageBevelBorder(Image img, Insets imageInsets, Insets borderInsets, boolean fillContentArea) {
        this(img, imageInsets, borderInsets, fillContentArea, null);
    }

    public ImageBevelBorder(Image img, Insets imageInsets, Insets borderInsets, boolean fillContentArea, Color fillColor) {
        this.image = img;
        this.imageInsets = imageInsets;
        this.borderInsets = borderInsets;
        this.fillContentArea = fillContentArea;
        this.fillColor = fillColor;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return (Insets)this.borderInsets.clone();
    }

    @Override
    public void paintBorder(Component c, Graphics gr, int x, int y, int width, int height) {
        TexturePaint paint;
        if (this.image == null) {
            return;
        }
        if (gr.getClipBounds() != null && !gr.getClipBounds().intersects(x, y, width, height)) {
            return;
        }
        this.image = Images.toBufferedImage(this.image);
        BufferedImage bufImg = (BufferedImage)this.image;
        Graphics2D g = (Graphics2D)gr.create();
        int top = this.imageInsets.top;
        int left = this.imageInsets.left;
        int bottom = this.imageInsets.bottom;
        int right = this.imageInsets.right;
        int imgWidth = bufImg.getWidth();
        int imgHeight = bufImg.getHeight();
        if (this.fillContentArea && width == imgWidth && height == imgHeight) {
            g.drawImage(this.image, x, y, c);
            g.dispose();
            return;
        }
        if (width == imgWidth) {
            left = imgWidth;
            right = 0;
        }
        if (height == imgHeight) {
            top = imgHeight;
            bottom = 0;
        }
        if (width < left + right) {
            left = Math.min(left, width / 2);
            right = width - left;
        }
        if (height < top + bottom) {
            top = Math.min(top, height / 2);
            bottom = height - top;
        }
        if (top > 0 && left > 0) {
            g.drawImage(this.image, x, y, x + left, y + top, 0, 0, left, top, c);
        }
        if (top > 0 && right > 0) {
            g.drawImage(this.image, x + width - right, y, x + width, y + top, imgWidth - right, 0, imgWidth, top, c);
        }
        if (bottom > 0 && left > 0) {
            g.drawImage(this.image, x, y + height - bottom, x + left, y + height, 0, imgHeight - bottom, left, imgHeight, c);
        }
        if (bottom > 0 && right > 0) {
            g.drawImage(this.image, x + width - right, y + height - bottom, x + width, y + height, imgWidth - right, imgHeight - bottom, imgWidth, imgHeight, c);
        }
        BufferedImage subImg = null;
        if (top > 0 && left + right < width && imgWidth > right + left) {
            subImg = bufImg.getSubimage(left, 0, imgWidth - right - left, top);
            paint = new TexturePaint(subImg, new Rectangle(x + left, y, imgWidth - left - right, top));
            g.setPaint(paint);
            g.fillRect(x + left, y, width - left - right, top);
        }
        if (bottom > 0 && left + right < width && imgHeight > bottom && imgWidth > right + left) {
            subImg = bufImg.getSubimage(left, imgHeight - bottom, imgWidth - right - left, bottom);
            paint = new TexturePaint(subImg, new Rectangle(x + left, y + height - bottom, imgWidth - left - right, bottom));
            g.setPaint(paint);
            g.fillRect(x + left, y + height - bottom, width - left - right, bottom);
        }
        if (left > 0 && top + bottom < height && imgHeight > top + bottom) {
            subImg = bufImg.getSubimage(0, top, left, imgHeight - top - bottom);
            paint = new TexturePaint(subImg, new Rectangle(x, y + top, left, imgHeight - top - bottom));
            g.setPaint(paint);
            g.fillRect(x, y + top, left, height - top - bottom);
        }
        if (right > 0 && top + bottom < height && imgWidth > right + right && imgHeight > top + bottom) {
            subImg = bufImg.getSubimage(imgWidth - right, top, right, imgHeight - top - bottom);
            paint = new TexturePaint(subImg, new Rectangle(x + width - right, y + top, right, imgHeight - top - bottom));
            g.setPaint(paint);
            g.fillRect(x + width - right, y + top, right, height - top - bottom);
        }
        if (this.fillContentArea && left + right < width && top + bottom < height) {
            if (this.fillColor != null) {
                g.setColor(this.fillColor);
                g.fillRect(x + left, y + top, width - right - left, height - top - bottom);
            } else if (imgWidth - right - left > 0 && imgHeight - top - bottom > 0) {
                subImg = bufImg.getSubimage(left, top, imgWidth - right - left, imgHeight - top - bottom);
                paint = new TexturePaint(subImg, new Rectangle(x + left, y + top, imgWidth - right - left, imgHeight - top - bottom));
                g.setPaint(paint);
                g.fillRect(x + left, y + top, width - right - left, height - top - bottom);
            }
        }
        g.dispose();
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public static class UIResource
    extends ImageBevelBorder
    implements javax.swing.plaf.UIResource {
        public UIResource(Image img, Insets borderInsets) {
            super(img, borderInsets);
        }

        public UIResource(Image img, Insets imageInsets, Insets borderInsets) {
            super(img, imageInsets, borderInsets);
        }

        public UIResource(Image img, Insets imageInsets, Insets borderInsets, boolean fillContentArea) {
            super(img, imageInsets, borderInsets, fillContentArea);
        }

        public UIResource(Image img, Insets imageInsets, Insets borderInsets, boolean fillContentArea, Color fillColor) {
            super(img, imageInsets, borderInsets, fillContentArea, fillColor);
        }
    }
}

