/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.subset;

import ch.randelshofer.quaqua.LookAndFeelProxy;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.color.AlphaColorUIResource;
import ch.randelshofer.quaqua.color.InactivatableColorUIResource;
import ch.randelshofer.quaqua.osx.OSXPreferences;
import ch.randelshofer.quaqua.util.Images;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;

public class QuaquaLeopardFileChooserLAF
extends LookAndFeelProxy {
    protected static final String commonDir = "/ch/randelshofer/quaqua/images/";
    protected static final String jaguarDir = "/ch/randelshofer/quaqua/jaguar/images/";
    protected static final String leopardDir = "/ch/randelshofer/quaqua/leopard/images/";
    private UIDefaults myDefaults;
    protected static final FontUIResource SMALL_SYSTEM_FONT = new FontUIResource("Lucida Grande", 0, 11);

    public QuaquaLeopardFileChooserLAF() {
        String targetClassName = "apple.laf.AquaLookAndFeel";
        try {
            this.setTarget((LookAndFeel)Class.forName(targetClassName).newInstance());
        }
        catch (Exception e) {
            throw new InternalError("Unable to instanciate target Look and Feel \"" + targetClassName + "\". " + e.getMessage());
        }
    }

    @Override
    public String getDescription() {
        return "The Quaqua Leopard FileChooser Look and Feel for Java 1.5";
    }

    @Override
    public String getName() {
        return "Quaqua Leopard FileChooser-only LAF";
    }

    @Override
    public void initialize() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                QuaquaLeopardFileChooserLAF.this.target.initialize();
                QuaquaLeopardFileChooserLAF.this.myDefaults = QuaquaLeopardFileChooserLAF.this.target.getDefaults();
                QuaquaLeopardFileChooserLAF.this.initResourceBundle(QuaquaLeopardFileChooserLAF.this.myDefaults);
                QuaquaLeopardFileChooserLAF.this.initClassDefaults(QuaquaLeopardFileChooserLAF.this.myDefaults);
                QuaquaLeopardFileChooserLAF.this.initFontDefaults(QuaquaLeopardFileChooserLAF.this.myDefaults);
                QuaquaLeopardFileChooserLAF.this.initGeneralDefaults(QuaquaLeopardFileChooserLAF.this.myDefaults);
                QuaquaLeopardFileChooserLAF.this.initComponentDefaults(QuaquaLeopardFileChooserLAF.this.myDefaults);
                return null;
            }
        });
    }

    @Override
    public UIDefaults getDefaults() {
        return this.myDefaults;
    }

    protected void initResourceBundle(UIDefaults table) {
        ResourceBundle bundle = ResourceBundle.getBundle("ch.randelshofer.quaqua.Labels", Locale.getDefault(), this.getClass().getClassLoader());
        Enumeration<String> i = bundle.getKeys();
        while (i.hasMoreElements()) {
            String key = i.nextElement();
            table.put(key, bundle.getObject(key));
        }
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        String basicPrefix = "javax.swing.plaf.basic.Basic";
        String quaquaPrefix = "ch.randelshofer.quaqua.Quaqua";
        String quaquaLeopardPrefix = "ch.randelshofer.quaqua.leopard.QuaquaLeopard";
        Object[] uiDefaults = new Object[]{"BrowserUI", quaquaPrefix + "BrowserUI", "FileChooserUI", quaquaLeopardPrefix + "FileChooserUI"};
        table.putDefaults(uiDefaults);
    }

    protected void initGeneralDefaults(UIDefaults table) {
        Object[] uiDefaults = new Object[]{"ClassLoader", this.getClass().getClassLoader()};
        table.putDefaults(uiDefaults);
    }

    protected Font getBaseSystemFont() {
        return new Font("Lucida Grande", 0, 13);
    }

    protected void initFontDefaults(UIDefaults table) {
        Font baseSystemFont = this.getBaseSystemFont();
        float fourteen = 14.0f;
        float thirteen = 13.0f;
        float twelve = 12.0f;
        float eleven = 11.0f;
        float ten = 11.0f;
        float nine = 9.0f;
        int fontPlain = 0;
        int fontBold = 1;
        UIDefaults.ProxyLazyValue systemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontPlain, thirteen)});
        UIDefaults.ProxyLazyValue emphasizedSystemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontBold, thirteen)});
        UIDefaults.ProxyLazyValue smallSystemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontPlain, eleven)});
        UIDefaults.ProxyLazyValue emphasizedSmallSystemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontBold, eleven)});
        UIDefaults.ProxyLazyValue miniSystemFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontPlain, nine)});
        Object applicationFont = baseSystemFont;
        UIDefaults.ProxyLazyValue labelFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontPlain, ten)});
        UIDefaults.ProxyLazyValue viewFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontPlain, twelve)});
        UIDefaults.ProxyLazyValue menuFont = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{baseSystemFont.deriveFont(fontPlain, fourteen)});
        if (QuaquaManager.getProperty("Quaqua.sizeStyle", "regular").equals("small")) {
            viewFont = smallSystemFont;
            systemFont = smallSystemFont;
            emphasizedSystemFont = emphasizedSmallSystemFont;
            menuFont = smallSystemFont;
            applicationFont = smallSystemFont;
        }
        Object[] uiDefaults = new Object[]{"SystemFont", systemFont, "EmphasizedSystemFont", emphasizedSystemFont, "SmallSystemFont", smallSystemFont, "EmphasizedSmallSystemFont", emphasizedSmallSystemFont, "MiniSystemFont", miniSystemFont, "EmphasizedMiniSystemFont", miniSystemFont, "ApplicationFont", applicationFont, "LabelFont", labelFont, "ViewFont", viewFont, "MenuFont", menuFont, "Browser.font", viewFont, "Button.font", systemFont, "Button.smallFont", smallSystemFont, "FileChooser.previewLabelFont", emphasizedSmallSystemFont, "FileChooser.previewValueFont", smallSystemFont};
        this.putDefaults(table, uiDefaults);
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        boolean isOrderByType = false;
        String prefValue = OSXPreferences.getString(OSXPreferences.FINDER_PREFERENCES, "AppleShowAllFiles", "false").toLowerCase();
        boolean isFileHidingEnabled = prefValue.equals("false") || prefValue.equals("no");
        boolean isQuickLookEnabled = Boolean.valueOf(QuaquaManager.getProperty("Quaqua.FileChooser.quickLookEnabled", "true"));
        Color grayedFocusCellBorderColor = (Color)table.get("listHighlight");
        String sideBarIconsStart = "/System/Library/CoreServices/CoreTypes.bundle/Contents/Resources/Toolbar";
        String sideBarIconsEnd = "FolderIcon.icns";
        BorderUIResource.CompoundBorderUIResource browserCellBorder = new BorderUIResource.CompoundBorderUIResource(new BorderUIResource.MatteBorderUIResource(0, 0, 1, 0, new ColorUIResource(0xFFFFFF)), new BorderUIResource.EmptyBorderUIResource(0, 4, 1, 0));
        Object[] uiDefaults = new Object[]{"Browser.expandedIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/jaguar/images/Browser.disclosureIcons.png", 6, Boolean.TRUE, 0}), "Browser.expandingIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/jaguar/images/Browser.disclosureIcons.png", 6, Boolean.TRUE, 1}), "Browser.focusedSelectedExpandedIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/jaguar/images/Browser.disclosureIcons.png", 6, Boolean.TRUE, 2}), "Browser.focusedSelectedExpandingIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/jaguar/images/Browser.disclosureIcons.png", 6, Boolean.TRUE, 3}), "Browser.selectedExpandedIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/jaguar/images/Browser.disclosureIcons.png", 6, Boolean.TRUE, 4}), "Browser.selectedExpandingIcon", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createIcon", new Object[]{"/ch/randelshofer/quaqua/jaguar/images/Browser.disclosureIcons.png", 6, Boolean.TRUE, 5}), "Browser.selectionBackground", new ColorUIResource(56, 117, 215), "Browser.selectionForeground", new ColorUIResource(255, 255, 255), "Browser.inactiveSelectionBackground", new ColorUIResource(208, 208, 208), "Browser.inactiveSelectionForeground", new ColorUIResource(0, 0, 0), "Browser.sizeHandleIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/images/Browser.sizeHandleIcon.png"), "FileChooser.autovalidate", Boolean.TRUE, "FileChooser.enforceQuaquaTreeUI", Boolean.TRUE, "FileChooser.fileHidingEnabled", isFileHidingEnabled, "FileChooser.quickLookEnabled", isQuickLookEnabled, "FileChooser.orderByType", isOrderByType, "FileChooser.previewLabelForeground", new ColorUIResource(0x808080), "FileChooser.previewValueForeground", new ColorUIResource(0), "FileChooser.previewLabelInsets", new InsetsUIResource(1, 0, 0, 4), "FileChooser.previewLabelDelimiter", "", "FileChooser.cellTipOrigin", new Point(18, 1), "FileChooser.splitPaneDividerSize", 1, "FileChooser.splitPaneBackground", new ColorUIResource(0xA5A5A5), "FileChooser.browserCellFocusBorder", browserCellBorder, "FileChooser.browserCellFocusBorderGrayed", browserCellBorder, "FileChooser.browserCellBorder", browserCellBorder, "FileChooser.browserUseUnselectedExpandIconForLabeledFile", Boolean.FALSE, "FileChooser.browserCellColorLabelInsets", new InsetsUIResource(0, 1, -1, 1), "FileChooser.browserCellSelectedColorLabelInsets", new InsetsUIResource(1, 0, 0, 0), "FileChooser.browserCellTextIconGap", 6, "FileChooser.browserCellTextArrowIconGap", 5, "FileChooser.browserUseUnselectedExpandIconForLabeledFile", Boolean.TRUE, "FileChooser.sideBarIcon.Applications", QuaquaLeopardFileChooserLAF.makeNativeIcon(sideBarIconsStart + "Apps" + sideBarIconsEnd, 16), "FileChooser.sideBarIcon.Desktop", QuaquaLeopardFileChooserLAF.makeNativeIcon(sideBarIconsStart + "Desktop" + sideBarIconsEnd, 16), "FileChooser.sideBarIcon.Documents", QuaquaLeopardFileChooserLAF.makeNativeIcon(sideBarIconsStart + "Documents" + sideBarIconsEnd, 16), "FileChooser.sideBarIcon.Downloads", QuaquaLeopardFileChooserLAF.makeNativeIcon(sideBarIconsStart + "Downloads" + sideBarIconsEnd, 16), "FileChooser.sideBarIcon.Library", QuaquaLeopardFileChooserLAF.makeNativeIcon(sideBarIconsStart + "Library" + sideBarIconsEnd, 16), "FileChooser.sideBarIcon.Movies", QuaquaLeopardFileChooserLAF.makeNativeIcon(sideBarIconsStart + "Movie" + sideBarIconsEnd, 16), "FileChooser.sideBarIcon.Music", QuaquaLeopardFileChooserLAF.makeNativeIcon(sideBarIconsStart + "Music" + sideBarIconsEnd, 16), "FileChooser.sideBarIcon.Pictures", QuaquaLeopardFileChooserLAF.makeNativeIcon(sideBarIconsStart + "Pictures" + sideBarIconsEnd, 16), "FileChooser.sideBarIcon.Public", QuaquaLeopardFileChooserLAF.makeNativeIcon(sideBarIconsStart + "Public" + sideBarIconsEnd, 16), "FileChooser.sideBarIcon.Sites", QuaquaLeopardFileChooserLAF.makeNativeIcon(sideBarIconsStart + "Sites" + sideBarIconsEnd, 16), "FileChooser.sideBarIcon.Utilities", QuaquaLeopardFileChooserLAF.makeNativeIcon(sideBarIconsStart + "Utilities" + sideBarIconsEnd, 16), "FileView.computerIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/leopard/images/FileView.computerIcon.png"), "FileView.fileIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/leopard/images/FileView.fileIcon.png"), "FileView.directoryIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/leopard/images/FileView.directoryIcon.png"), "FileView.hardDriveIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/leopard/images/FileView.hardDriveIcon.png"), "FileView.floppyDriveIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/leopard/images/FileView.floppyDriveIcon.png"), "FileChooser.browserFocusCellHighlightBorder", new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$EmptyBorderUIResource", new Object[]{new Insets(1, 1, 1, 1)}), "FileChooser.browserFocusCellHighlightBorderGrayed", new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$MatteBorderUIResource", new Object[]{1, 1, 1, 1, grayedFocusCellBorderColor}), "Label.embossForeground", new AlphaColorUIResource(0x7EFFFFFF), "Label.shadowForeground", new AlphaColorUIResource(0x7E000000), "Tree.collapsedIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/leopard/images/Tree.collapsedIcon.png"), "Tree.expandedIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/leopard/images/Tree.expandedIcon.png"), "Tree.leafIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/leopard/images/Tree.leafIcon.png"), "Tree.openIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/leopard/images/Tree.openIcon.png"), "Tree.closedIcon", QuaquaLeopardFileChooserLAF.makeIcon(this.getClass(), "/ch/randelshofer/quaqua/leopard/images/Tree.closedIcon.png"), "Tree.sideBar.background", new InactivatableColorUIResource(0xD5DDE5, 0xE8E8E8), "Tree.sideBar.selectionBorder", new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.leopard.QuaquaLeopardSideBarSelectionBorder"), "Tree.leftChildIndent", 8, "Tree.rightChildIndent", 12, "Tree.icons", this.makeIcons("/ch/randelshofer/quaqua/leopard/images/Tree.icons.png", 15, true), "Tree.sideBar.icons", this.makeIcons("/ch/randelshofer/quaqua/leopard/images/Tree.sideBar.icons.png", 15, true), "Tree.sideBarCategory.foreground", new InactivatableColorUIResource(7504276, 0x5F5F5F), "Tree.sideBarCategory.selectionForeground", new InactivatableColorUIResource(0xFFFFFF, 0xFFFFFF), "Tree.sideBarCategory.font", new FontUIResource("Lucida Grande", 1, 11), "Tree.sideBarCategory.selectionFont", new FontUIResource("Lucida Grande", 1, 11), "Tree.sideBar.foreground", new InactivatableColorUIResource(0, 0), "Tree.sideBar.selectionForeground", new InactivatableColorUIResource(0xFFFFFF, 0xFFFFFF), "Tree.sideBar.font", new FontUIResource("Lucida Grande", 0, 11), "Tree.sideBar.selectionFont", new FontUIResource("Lucida Grande", 1, 11), "Tree.sideBarCategory.selectionForeground", new InactivatableColorUIResource(0xFFFFFF, 0xFFFFFF), "Sheet.showAsSheet", Boolean.TRUE};
        table.putDefaults(uiDefaults);
    }

    protected URL getResource(String location) {
        URL url = this.getClass().getResource(location);
        if (url == null) {
            throw new InternalError("image resource missing: " + location);
        }
        return url;
    }

    protected Image createImage(String location) {
        return Toolkit.getDefaultToolkit().createImage(this.getResource(location));
    }

    protected Icon[] makeIcons(String location, int count, boolean horizontal) {
        Icon[] icons = new Icon[count];
        BufferedImage[] images = Images.split(this.createImage(location), count, horizontal);
        for (int i = 0; i < count; ++i) {
            icons[i] = new IconUIResource(new ImageIcon(images[i]));
        }
        return icons;
    }

    protected void putDefaults(UIDefaults table, Object[] keyValueList) {
        Set included = QuaquaManager.getIncludedUIs();
        Set excluded = QuaquaManager.getExcludedUIs();
        if (excluded == null) {
            return;
        }
        if (included == null && excluded.isEmpty()) {
            table.putDefaults(keyValueList);
        } else if (included != null && excluded.isEmpty()) {
            for (int i = 0; i < keyValueList.length; i += 2) {
                if (keyValueList[i] instanceof String) {
                    String name = (String)keyValueList[i];
                    int p = name.indexOf(46);
                    if (p == -1 && name.endsWith("UI")) {
                        name = name.substring(0, name.length() - 2);
                        p = 1;
                    } else if (p != -1) {
                        name = name.substring(0, p);
                    }
                    if (p != -1 && !included.contains(name)) continue;
                    table.put(keyValueList[i], keyValueList[i + 1]);
                    continue;
                }
                table.put(keyValueList[i], keyValueList[i + 1]);
            }
        } else if (included == null) {
            for (int i = 0; i < keyValueList.length; i += 2) {
                table.put(keyValueList[i], keyValueList[i + 1]);
            }
        } else {
            for (int i = 0; i < keyValueList.length; i += 2) {
                table.put(keyValueList[i], keyValueList[i + 1]);
            }
        }
    }

    public static Object makeNativeIcon(String path, int size) {
        return new UIDefaults.ProxyLazyValue("ch.randelshofer.quaqua.QuaquaIconFactory", "createNativeIcon", new Object[]{path, size});
    }

    @Override
    public String getID() {
        return "Aqua";
    }
}

