/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.coreplugin.mdiManager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.KeyEventDispatcher;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.ToolsWindowManager;
import org.gvsig.andami.ui.mdiFrame.GlassPane;
import org.gvsig.andami.ui.mdiFrame.MDIFrame;
import org.gvsig.andami.ui.mdiFrame.MainFrame;
import org.gvsig.andami.ui.mdiFrame.NewStatusBar;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.IWindowListener;
import org.gvsig.andami.ui.mdiManager.MDIManager;
import org.gvsig.andami.ui.mdiManager.MDIUtilities;
import org.gvsig.andami.ui.mdiManager.SingletonDialogAlreadyShownException;
import org.gvsig.andami.ui.mdiManager.SingletonWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.coreplugin.mdiManager.DialogStackSupport;
import org.gvsig.coreplugin.mdiManager.FrameWindowSupport;
import org.gvsig.coreplugin.mdiManager.MDIDesktopPane;
import org.gvsig.coreplugin.mdiManager.SingletonWindowSupport;
import org.gvsig.coreplugin.mdiManager.WindowInfoSupport;
import org.gvsig.coreplugin.mdiManager.WindowStackSupport;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.task.RunnableWithParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewSkin
extends Extension
implements MDIManager {
    private static final int DefaultXMargin = 20;
    private static final int DefaultYMargin = 20;
    private static final int MinimumXMargin = 130;
    private static final int MinimumYMargin = 60;
    private static final DesktopManager desktopManager = new DefaultDesktopManager();
    private static final Logger logger = LoggerFactory.getLogger((String)NewSkin.class.getName());
    private final JDesktopPane panel = new MDIDesktopPane();
    private MDIFrame mainFrame;
    private final GlassPane glassPane = new GlassPane();
    private DialogStackSupport dss;
    private FrameWindowSupport fws;
    private WindowInfoSupport wis;
    private WindowStackSupport wss;
    private SingletonWindowSupport sws;
    private Cursor lastCursor = null;
    private ImageIcon image;
    private String typeDesktop;
    private int alignCounter = 1;

    private void addScrolledDesktopPanel(JFrame parent, JDesktopPane desktopPane) {
        JPanel toppanel = new JPanel();
        toppanel.setLayout(new BorderLayout());
        toppanel.setPreferredSize(new Dimension(200, 200));
        toppanel.setBackground(Color.RED);
        JScrollPane scrollPanel = new JScrollPane(desktopPane);
        toppanel.add((Component)scrollPanel, "Center");
        parent.getContentPane().add((Component)toppanel, "Center");
    }

    public JDesktopPane getDesktopPane() {
        return this.panel;
    }

    public BufferedImage getImagePreview() {
        BufferedImage img = new BufferedImage(this.panel.getWidth(), this.panel.getHeight(), 1);
        Graphics2D g = img.createGraphics();
        this.panel.paint(g);
        g.dispose();
        return img;
    }

    public void init(MDIFrame f) {
        this.mainFrame = f;
        this.mainFrame.setGlassPane((Component)this.glassPane);
        this.panel.setDragMode(1);
        this.addScrolledDesktopPanel((JFrame)this.mainFrame, this.panel);
        this.panel.setDesktopManager(desktopManager);
        this.fws = this.createFrameWindowSupport(this.mainFrame);
        this.dss = new DialogStackSupport(this.mainFrame);
        this.sws = new SingletonWindowSupport(this.wis, this.fws);
        this.wis = new WindowInfoSupport((MainFrame)this.mainFrame, this.fws, this.sws);
        this.fws.setVis(this.wis);
        this.wss = new WindowStackSupport(this.wis);
        KeyStroke controlTab = KeyStroke.getKeyStroke(9, 2);
        PluginServices.registerKeyStroke((KeyStroke)controlTab, (KeyEventDispatcher)new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                IWindow[] views = NewSkin.this.getAllWindows();
                if (views.length <= 0 || e.getID() == 401) {
                    return false;
                }
                int current = 0;
                for (int i = 0; i < views.length; ++i) {
                    if (!views[i].equals(NewSkin.this.getActiveWindow())) continue;
                    current = i;
                    break;
                }
                NewSkin.this.addWindow(views[(current + 1) % views.length]);
                return true;
            }
        });
    }

    protected FrameWindowSupport createFrameWindowSupport(MDIFrame mainFrame) {
        return new FrameWindowSupport(mainFrame);
    }

    public IWindow addWindow(final IWindow p) throws SingletonDialogAlreadyShownException {
        SingletonWindow sw;
        if (!SwingUtilities.isEventDispatchThread()) {
            RunnableWithParameters action = new RunnableWithParameters(){

                public void run() {
                    this.returnValue = NewSkin.this.addWindow(p);
                }
            };
            try {
                SwingUtilities.invokeAndWait((Runnable)action);
            }
            catch (Exception e2) {
                logger.info("Can't add window from othrer thread that EventDispatch", (Throwable)e2);
                IllegalThreadStateException e22 = new IllegalThreadStateException();
                e22.initCause(e2);
                throw e22;
            }
            return (IWindow)action.getReturnValue();
        }
        WindowInfo wi = this.wis.getWindowInfo(p);
        MDIUtilities.checkWindowInfo((WindowInfo)wi);
        if (p instanceof SingletonWindow && wi.isModal()) {
            throw new RuntimeException("A modal view cannot be a SingletonView");
        }
        boolean singletonPreviouslyAdded = false;
        if (p instanceof SingletonWindow && this.sws.registerWindow((sw = (SingletonWindow)p).getClass(), sw.getWindowModel(), wi)) {
            singletonPreviouslyAdded = true;
        }
        if (singletonPreviouslyAdded) {
            JInternalFrame frame;
            if (!this.sws.contains((SingletonWindow)p)) {
                frame = this.fws.getJInternalFrame(p);
                this.sws.openSingletonWindow((SingletonWindow)p, frame);
                this.addJInternalFrame(frame, wi);
                this.wss.add(p, e -> {
                    IWindow v = this.wis.getWindowById(Integer.parseInt(e.getActionCommand()));
                    JInternalFrame f = this.fws.getJInternalFrame(v);
                    this.activateJInternalFrame(f);
                });
                return p;
            }
            frame = (JInternalFrame)this.sws.getFrame((SingletonWindow)p);
            this.activateJInternalFrame(frame);
            this.wss.setActive(p);
            return this.fws.getWindow(frame);
        }
        if (wi.isModal()) {
            this.addJDialog(p);
        } else {
            this.wss.add(p, e -> {
                IWindow v = this.wis.getWindowById(Integer.parseInt(e.getActionCommand()));
                JInternalFrame f = this.fws.getJInternalFrame(v);
                this.activateJInternalFrame(f);
            });
            this.addJInternalFrame(p);
        }
        return p;
    }

    public SingletonWindow getSingletonWindow(Class windowClass, Object model) {
        JInternalFrame frame = (JInternalFrame)this.sws.getFrame(windowClass, model);
        if (frame == null) {
            return null;
        }
        return (SingletonWindow)this.fws.getWindow(frame);
    }

    public IWindow addCentredWindow(IWindow p) throws SingletonDialogAlreadyShownException {
        IWindow window = this.addWindow(p);
        if (!p.getWindowInfo().isModal()) {
            this.centreFrame(window);
        }
        return window;
    }

    public IWindow addWindow(IWindow p, int align) throws SingletonDialogAlreadyShownException {
        SingletonWindow sw;
        if (p == null) {
            throw new IllegalArgumentException("p (IWindow) can't bu null.");
        }
        boolean singletonPreviouslyAdded = false;
        WindowInfo wi = this.wis.getWindowInfo(p);
        if (p instanceof SingletonWindow && this.sws.registerWindow((sw = (SingletonWindow)p).getClass(), sw.getWindowModel(), wi)) {
            singletonPreviouslyAdded = true;
        }
        if (!singletonPreviouslyAdded) {
            Point new_loc = this.getLocationForAlignment(p, align);
            p.getWindowInfo().setX(new_loc.x);
            p.getWindowInfo().setY(new_loc.y);
        }
        IWindow window = this.addWindow(p);
        return window;
    }

    public void move(IWindow panel, int x, int y) {
        if (panel == null) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.move(panel, x, y));
            return;
        }
        Component window = this.fws.getFrame(panel);
        if (window == null) {
            return;
        }
        Point p = new Point();
        p.setLocation(x, y);
        window.setLocation(p);
    }

    public synchronized void centreFrame(IWindow panel) {
        if (panel == null) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.centreFrame(panel));
            return;
        }
        Component window = this.fws.getFrame(panel);
        if (window == null) {
            return;
        }
        Point newReferencePoint = new Point();
        Dimension visibleSize = this.getInternalSize();
        int freeWidth = visibleSize.width - window.getWidth();
        int freeHeight = visibleSize.height - window.getHeight();
        newReferencePoint.x = freeWidth < 0 ? (visibleSize.width > 130 ? 20 : 0) : freeWidth / 2;
        newReferencePoint.y = freeHeight < 0 ? (visibleSize.height > 60 ? 20 : 0) : freeHeight / 2;
        window.setLocation(newReferencePoint);
    }

    public Dimension getInternalSize() {
        Container contentPane = ((JFrame)PluginServices.getMainFrame()).getContentPane();
        NewStatusBar newStatusBar = (NewStatusBar)contentPane.getComponent(1);
        JDesktopPane jDesktopPane = this.getDesktopPane();
        int visibleWidth = contentPane.getWidth() - contentPane.getX();
        int visibleHeight = contentPane.getHeight() - newStatusBar.getHeight() - contentPane.getY() - Math.abs(jDesktopPane.getY() - contentPane.getY());
        return new Dimension(visibleWidth, visibleHeight);
    }

    public synchronized void alignFrame(IWindow panel, int mode) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.alignFrame(panel, mode));
            return;
        }
        Component window = this.fws.getFrame(panel);
        if (window == null) {
            return;
        }
        Point newReferencePoint = new Point();
        Container contentPane = ((JFrame)PluginServices.getMainFrame()).getContentPane();
        NewStatusBar newStatusBar = (NewStatusBar)contentPane.getComponent(1);
        JDesktopPane jDesktopPane = this.getDesktopPane();
        int visibleWidth = contentPane.getWidth() - contentPane.getX();
        int visibleHeight = contentPane.getHeight() - newStatusBar.getHeight() - contentPane.getY() - Math.abs(jDesktopPane.getY() - contentPane.getY());
        switch (mode) {
            case 23: {
                newReferencePoint.x = 20;
                newReferencePoint.y = 20;
                break;
            }
            case 19: {
                newReferencePoint.x = visibleWidth / 2;
                newReferencePoint.y = 20;
                break;
            }
            case 24: {
                newReferencePoint.x = visibleWidth - window.getWidth() - 20;
                newReferencePoint.y = 20;
                break;
            }
            case 1816: {
                newReferencePoint.x = visibleWidth - window.getWidth() - (int)(20.0 + 30.0 * (double)this.alignCounter);
                newReferencePoint.y = 20 + (int)(30.0 * (double)this.alignCounter);
                if (++this.alignCounter <= 5) break;
                this.alignCounter = 0;
                break;
            }
            case 21: {
                newReferencePoint.x = 20;
                newReferencePoint.y = visibleHeight / 2;
                break;
            }
            case 22: {
                newReferencePoint.x = visibleWidth - window.getWidth() - 20;
                newReferencePoint.y = visibleHeight / 2;
                break;
            }
            case 25: {
                newReferencePoint.x = 20;
                newReferencePoint.y = visibleHeight - window.getHeight() - 20;
                break;
            }
            case 20: {
                newReferencePoint.x = visibleWidth / 2;
                newReferencePoint.y = visibleHeight - window.getHeight() - 20;
                break;
            }
            case 26: {
                newReferencePoint.x = visibleWidth - window.getWidth() - 20;
                newReferencePoint.y = visibleHeight - window.getHeight() - 20;
                break;
            }
            default: {
                newReferencePoint.x = visibleWidth / 2;
                newReferencePoint.y = visibleHeight / 2;
            }
        }
        if (newReferencePoint.x < 0) {
            newReferencePoint.x = 20;
        }
        if (newReferencePoint.y < 0) {
            newReferencePoint.y = 20;
        }
        window.setLocation(newReferencePoint);
    }

    private void addJInternalFrame(JInternalFrame wnd, WindowInfo wi) {
        wnd.setDefaultCloseOperation(2);
        wnd.addInternalFrameListener(new FrameListener());
        if (wi.isModeless() || wi.isPalette()) {
            this.panel.add((Component)wnd, JDesktopPane.PALETTE_LAYER);
            if (wi.isPalette()) {
                wnd.setFocusable(false);
            }
        } else {
            this.panel.add(wnd);
        }
        this.updateFrameProperties(wnd, wi);
        this.activateJInternalFrame(wnd);
        try {
            wnd.setMaximum(wi.isMaximized());
        }
        catch (Exception ex) {
            String title = "unknow";
            try {
                title = wi.getTitle();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            logger.warn("Can't maximize window (" + title + ").", (Throwable)ex);
        }
    }

    private void updateFrameProperties(JInternalFrame frame, WindowInfo wi) {
        if (wi.isMaximized()) {
            int width = wi.getNormalWidth() != -1 ? wi.getNormalWidth() : frame.getNormalBounds().width;
            int height = wi.getNormalHeight() != -1 ? wi.getNormalHeight() : frame.getNormalBounds().height;
            frame.setSize(width, height);
            frame.setLocation(wi.getNormalX(), wi.getNormalY());
        } else {
            int width = wi.getWidth() != -1 ? wi.getWidth() : frame.getWidth();
            int height = wi.getHeight() != -1 ? wi.getHeight() : frame.getHeight();
            frame.setSize(width, height);
            frame.setLocation(wi.getX(), wi.getY());
        }
        frame.setTitle(wi.getTitle());
        frame.setVisible(wi.isVisible());
        frame.setResizable(wi.isResizable());
        frame.setIconifiable(wi.isIconifiable());
        frame.setMaximizable(wi.isMaximizable());
        try {
            frame.setMaximum(wi.isMaximized());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void addJInternalFrame(IWindow p) {
        WindowInfo wi = this.wis.getWindowInfo(p);
        JInternalFrame wnd = this.fws.getJInternalFrame(p);
        if (p instanceof SingletonWindow) {
            SingletonWindow sv = (SingletonWindow)p;
            this.sws.openSingletonWindow(sv, wnd);
        }
        this.addJInternalFrame(wnd, wi);
    }

    private void activateJInternalFrame(JInternalFrame wnd) {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        try {
            wnd.moveToFront();
            logger.debug("Activando " + wnd.getTitle());
            wnd.setSelected(true);
            wnd.setIcon(false);
        }
        catch (PropertyVetoException e) {
            logger.error(e.toString());
        }
    }

    public void moveToFrom(IWindow win) {
        if (win == null) {
            return;
        }
        Component frame = this.fws.getFrame(win);
        if (frame instanceof JInternalFrame) {
            this.activateJInternalFrame((JInternalFrame)frame);
        }
    }

    private void centerDialog(JDialog d) {
        int offSetX = d.getWidth() / 2;
        int offSetY = d.getHeight() / 2;
        Point o = this.mainFrame.getLocation();
        int x = o.x + this.mainFrame.getWidth() / 2 - offSetX;
        int y = o.y + this.mainFrame.getHeight() / 2 - offSetY;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        d.setLocation(x, y);
    }

    private void addJDialog(IWindow p) {
        JDialog dlg = this.fws.getJDialog(p);
        dlg.addWindowListener(new DialogWindowListener());
        this.centerDialog(dlg);
        this.dss.pushDialog(dlg);
        dlg.setVisible(this.wis.getWindowInfo(p).isVisible());
    }

    public IWindow getActiveWindow() {
        JInternalFrame jif = this.panel.getSelectedFrame();
        if (jif != null) {
            IWindow theWindow = this.fws.getWindow(jif);
            if (theWindow == null) {
                return null;
            }
            if (theWindow.getWindowInfo().isPalette()) {
                return this.wss.getActiveWindow();
            }
            return this.fws.getWindow(jif);
        }
        return null;
    }

    public IWindow getFocusWindow() {
        JInternalFrame jif = this.panel.getSelectedFrame();
        if (jif != null) {
            IWindow theView = this.fws.getWindow(jif);
            if (theView == null) {
                return null;
            }
            return this.fws.getWindow(jif);
        }
        return null;
    }

    public void closeWindow(IWindow p) {
        if (p == null) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.closeWindow(p));
            return;
        }
        if (p.getWindowInfo().isModal()) {
            this.closeJDialog();
        } else {
            this.closeJInternalFrame(this.fws.getJInternalFrame(p));
        }
    }

    public void closeAllWindows() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.closeAllWindows());
            return;
        }
        ArrayList<IWindow> eliminar = new ArrayList<IWindow>();
        Iterator i = this.fws.getWindowIterator();
        while (i.hasNext()) {
            eliminar.add((IWindow)i.next());
        }
        for (IWindow vista : eliminar) {
            this.closeWindow(vista);
        }
    }

    public WindowInfo getWindowInfo(IWindow w) {
        WindowInfo wi = this.wis.getWindowInfo(w);
        return wi;
    }

    private void closeJDialog() {
        JDialog dlg = this.dss.popDialog();
        if (dlg == null) {
            return;
        }
        dlg.setVisible(false);
        IWindow s = this.fws.getWindow(dlg);
        this.callWindowClosed(s);
        this.fws.closeWindow(s);
        if (s instanceof SingletonWindow) {
            this.sws.closeWindow((SingletonWindow)s);
        }
    }

    private void callWindowClosed(IWindow window) {
        if (window == null) {
            return;
        }
        if (window instanceof IWindowListener) {
            ((IWindowListener)window).windowClosed();
        }
        try {
            ToolsWindowManager.Window wwin = (ToolsWindowManager.Window)window;
            wwin.fireClosingWindow();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void callWindowActivated(IWindow window) {
        if (window instanceof IWindowListener) {
            ((IWindowListener)window).windowActivated();
        }
    }

    private void closeJInternalFrame(JInternalFrame frame) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.closeJInternalFrame(frame));
            return;
        }
        try {
            IWindow s = this.fws.getWindow(frame);
            frame.setClosed(true);
            this.callWindowClosed(s);
        }
        catch (PropertyVetoException e) {
            logger.warn("Not compatible with property veto's. Use ViewInfo instead.", (Throwable)e);
        }
    }

    public void initialize() {
    }

    public void execute(String actionCommand) {
        if ("window-cascade".equalsIgnoreCase(actionCommand)) {
            logger.info("action window-cascade not implemented.");
        } else if ("window-tile".equalsIgnoreCase(actionCommand)) {
            logger.info("action window-tile not implemented.");
        }
    }

    public boolean isEnabled() {
        return false;
    }

    public boolean isVisible() {
        return true;
    }

    public void setWaitCursor() {
        if (this.mainFrame != null) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(() -> this.setWaitCursor());
                return;
            }
            this.glassPane.setVisible(true);
            this.lastCursor = this.mainFrame.getCursor();
            this.dss.setWaitCursor();
            this.glassPane.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public void restoreCursor() {
        if (this.mainFrame != null) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(() -> this.restoreCursor());
                return;
            }
            this.glassPane.setVisible(false);
            this.dss.restoreCursor();
            this.glassPane.setCursor(this.lastCursor);
        }
    }

    public boolean closeSingletonWindow(Class viewClass, Object model) {
        JInternalFrame frame = (JInternalFrame)this.sws.getFrame(viewClass, model);
        if (frame == null) {
            return false;
        }
        this.closeJInternalFrame(frame);
        return true;
    }

    public boolean closeSingletonWindow(Object model) {
        if (model == null) {
            return false;
        }
        JInternalFrame[] frames = (JInternalFrame[])this.sws.getFrames(model);
        if (frames.length == 0) {
            return false;
        }
        for (JInternalFrame frame : frames) {
            this.closeJInternalFrame(frame);
        }
        return true;
    }

    public IWindow[] getAllWindows() {
        if (this.fws == null) {
            return null;
        }
        ArrayList<IWindow> windows = new ArrayList<IWindow>();
        Iterator i = this.fws.getWindowIterator();
        while (i.hasNext()) {
            windows.add((IWindow)i.next());
        }
        return windows.toArray(new IWindow[0]);
    }

    public IWindow[] getOrderedWindows() {
        TreeMap<Integer, IWindow> windows = new TreeMap<Integer, IWindow>();
        Iterator winIterator = this.fws.getWindowIterator();
        while (winIterator.hasNext()) {
            IWindow win = (IWindow)winIterator.next();
            Component frame = this.fws.getFrame(win);
            int zPosition = this.panel.getPosition(frame);
            if (zPosition == -1 && !frame.isFocusOwner()) {
                zPosition = 1000;
            }
            int layer = this.panel.getLayer(frame);
            if (!(frame instanceof JDialog)) {
                if (layer == JLayeredPane.DEFAULT_LAYER) {
                    zPosition += 50000;
                } else if (layer == JLayeredPane.PALETTE_LAYER) {
                    zPosition += 40000;
                } else if (layer == JLayeredPane.MODAL_LAYER) {
                    zPosition += 30000;
                } else if (layer == JLayeredPane.POPUP_LAYER) {
                    zPosition += 20000;
                } else if (layer == JLayeredPane.DRAG_LAYER) {
                    zPosition += 10000;
                }
            }
            windows.put(zPosition, win);
        }
        winIterator = windows.values().iterator();
        ArrayList winList = new ArrayList();
        while (winIterator.hasNext()) {
            winList.add(winIterator.next());
        }
        return winList.toArray(new IWindow[0]);
    }

    public void setMaximum(IWindow v, boolean bMaximum) throws PropertyVetoException {
        if (v == null) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> {
                try {
                    this.setMaximum(v, bMaximum);
                }
                catch (PropertyVetoException e) {
                    logger.info("Error not in event dispatch thread", (Throwable)e);
                }
            });
            return;
        }
        JInternalFrame f = this.fws.getJInternalFrame(v);
        f.setMaximum(bMaximum);
    }

    public void changeWindowInfo(IWindow w, WindowInfo wi) {
        JInternalFrame f = this.fws.getJInternalFrame(w);
        f.setDefaultCloseOperation(2);
        JDesktopPane pnl = f.getDesktopPane();
        pnl.remove(f);
        int width = wi.getWidth() != -1 ? wi.getWidth() : f.getWidth();
        int height = wi.getHeight() != -1 ? wi.getHeight() : f.getHeight();
        f.setSize(new Dimension(width, height));
        f.setLocation(wi.getX(), wi.getY());
        if (wi.isPalette()) {
            pnl.add((Component)f, JDesktopPane.PALETTE_LAYER);
            f.setFocusable(false);
        } else {
            pnl.add((Component)f, JDesktopPane.DEFAULT_LAYER);
            f.setFocusable(true);
            if (wi.isClosed()) {
                this.closeWindow(w);
            }
        }
        if (wi.isMaximized()) {
            try {
                f.setMaximum(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            f.setNormalBounds(wi.getNormalBounds());
        }
        this.activateJInternalFrame(f);
    }

    public void refresh(IWindow win) {
        if (win == null) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.refresh(win));
            return;
        }
        Component frame = this.fws.getFrame(win);
        if (frame != null) {
            frame.setVisible(true);
        }
    }

    public void setBackgroundImage(ImageIcon image, String typeDesktop) {
        this.image = image;
        this.typeDesktop = typeDesktop;
    }

    public void showWindow(JPanel panel, String title, WindowManager.MODE mode) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.showWindow(panel, title, mode));
            return;
        }
        ToolsSwingLocator.getWindowManager().showWindow((JComponent)panel, title, mode);
    }

    public IWindow getWindow(JPanel panel) {
        for (Container component = panel; component != null; component = component.getParent()) {
            if (!(component instanceof IWindow)) continue;
            return (IWindow)component;
        }
        return null;
    }

    private Point getLocationForAlignment(IWindow panel, int mode) {
        Point newReferencePoint = new Point();
        Container contentPane = ((JFrame)PluginServices.getMainFrame()).getContentPane();
        NewStatusBar newStatusBar = (NewStatusBar)contentPane.getComponent(1);
        JDesktopPane dpane = this.getDesktopPane();
        int visibleWidth = contentPane.getWidth() - contentPane.getX();
        int visibleHeight = contentPane.getHeight() - newStatusBar.getHeight() - contentPane.getY() - Math.abs(dpane.getY() - contentPane.getY());
        int win_h = panel.getWindowInfo().getHeight();
        int win_w = panel.getWindowInfo().getWidth();
        switch (mode) {
            case 23: {
                newReferencePoint.x = visibleWidth <= win_w + 20 ? 0 : 20;
                if (visibleHeight <= win_h + 20) {
                    newReferencePoint.y = 0;
                    break;
                }
                newReferencePoint.y = 20;
                break;
            }
            case 19: {
                newReferencePoint.x = visibleWidth / 2 - win_w / 2;
                newReferencePoint.y = 20;
                break;
            }
            case 24: {
                newReferencePoint.x = visibleWidth - win_w - 20;
                newReferencePoint.y = 20;
                break;
            }
            case 1816: {
                newReferencePoint.x = visibleWidth - win_w - (int)(20.0 + 30.0 * (double)this.alignCounter);
                newReferencePoint.y = 20 + (int)(30.0 * (double)this.alignCounter);
                if (++this.alignCounter <= 5) break;
                this.alignCounter = 0;
                break;
            }
            case 21: {
                newReferencePoint.x = 20;
                newReferencePoint.y = visibleHeight / 2 - win_h / 2;
                break;
            }
            case 22: {
                newReferencePoint.x = visibleWidth - win_w - 20;
                newReferencePoint.y = visibleHeight / 2 - win_h / 2;
                break;
            }
            case 25: {
                newReferencePoint.x = 20;
                newReferencePoint.y = visibleHeight - win_h - 20;
                break;
            }
            case 20: {
                newReferencePoint.x = visibleWidth / 2 - win_w / 2;
                newReferencePoint.y = visibleHeight - win_h - 20;
                break;
            }
            case 26: {
                newReferencePoint.x = visibleWidth - win_w - 20;
                newReferencePoint.y = visibleHeight - win_h - 20;
                break;
            }
            default: {
                newReferencePoint.x = visibleWidth / 2 - win_w / 2;
                newReferencePoint.y = visibleHeight / 2 - win_h / 2;
            }
        }
        if (newReferencePoint.x < 0) {
            newReferencePoint.x = 20;
        }
        if (newReferencePoint.y < 0) {
            newReferencePoint.y = 20;
        }
        return newReferencePoint;
    }

    public void setLocale(Locale locale) {
        IWindow[] win = this.getAllWindows();
        if (win == null) {
            return;
        }
        for (IWindow win1 : win) {
            if (!(win1 instanceof Component)) continue;
            try {
                ((Component)win1).setLocale(locale);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isModalDialogShowing() {
        Window[] windows = Window.getWindows();
        if (windows != null) {
            for (Window w : windows) {
                if (!w.isShowing() || !(w instanceof Dialog) || !((Dialog)w).isModal()) continue;
                return true;
            }
        }
        return false;
    }

    public class FrameListener
    implements InternalFrameListener {
        @Override
        public void internalFrameActivated(InternalFrameEvent e) {
            IWindow panel = NewSkin.this.fws.getWindow((JInternalFrame)e.getSource());
            WindowInfo wi = NewSkin.this.wis.getWindowInfo(panel);
            if (wi.isPalette()) {
                return;
            }
            NewSkin.this.wss.setActive(panel);
            JInternalFrame frame = NewSkin.this.fws.getJInternalFrame(panel);
            if (wi.isMaximizable()) {
                frame.setMaximizable(true);
            }
            if (!frame.isMaximizable() && frame.isMaximum()) {
                try {
                    frame.setMaximum(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            NewSkin.this.mainFrame.enableControls();
            if (wi.getSelectedTools() == null) {
                wi.setSelectedTools(new HashMap(NewSkin.this.mainFrame.getInitialSelectedTools()));
            }
            NewSkin.this.mainFrame.setSelectedTools(wi.getSelectedTools());
            NewSkin.this.callWindowActivated(panel);
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent e) {
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent e) {
            JInternalFrame c = (JInternalFrame)e.getSource();
            WindowInfo wi = NewSkin.this.wis.getWindowInfo(NewSkin.this.fws.getWindow(c));
            IWindow win = NewSkin.this.fws.getWindow(c);
            NewSkin.this.callWindowClosed(win);
            if (win instanceof SingletonWindow) {
                NewSkin.this.sws.closeWindow((SingletonWindow)win);
            }
            NewSkin.this.fws.closeWindow(win);
            NewSkin.this.panel.remove(c);
            NewSkin.this.wss.remove(win);
            if (!wi.isPalette()) {
                NewSkin.this.mainFrame.enableControls();
            }
            NewSkin.this.panel.repaint();
            IWindow lastWindow = NewSkin.this.wss.getActiveWindow();
            if (lastWindow != null) {
                logger.debug(PluginServices.getText((Object)this, (String)"Devuelvo_el_foco_a_") + lastWindow.getWindowInfo().getTitle());
                JInternalFrame frame = NewSkin.this.fws.getJInternalFrame(lastWindow);
                try {
                    frame.setSelected(true);
                }
                catch (PropertyVetoException e1) {
                    logger.debug("Can0t activate frame", (Throwable)e1);
                }
            }
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent e) {
            WindowInfo wi;
            JInternalFrame c = (JInternalFrame)e.getSource();
            IWindow win = NewSkin.this.fws.getWindow(c);
            if (win != null && (wi = NewSkin.this.wis.getWindowInfo(win)).isPalette()) {
                return;
            }
        }

        @Override
        public void internalFrameDeiconified(InternalFrameEvent e) {
            NewSkin.this.mainFrame.enableControls();
        }

        @Override
        public void internalFrameIconified(InternalFrameEvent e) {
            NewSkin.this.mainFrame.enableControls();
        }

        @Override
        public void internalFrameOpened(InternalFrameEvent e) {
        }
    }

    public class DialogWindowListener
    extends WindowAdapter {
        @Override
        public void windowActivated(WindowEvent e) {
            IWindow window = NewSkin.this.fws.getWindow((Component)e.getSource());
            NewSkin.this.callWindowActivated(window);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            NewSkin.this.closeJDialog();
        }
    }
}

