/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.coreplugin.mdiManager;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import javax.swing.JInternalFrame;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.SingletonDialogAlreadyShownException;
import org.gvsig.andami.ui.mdiManager.SingletonWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.coreplugin.mdiManager.FrameWindowSupport;
import org.gvsig.coreplugin.mdiManager.WindowInfoSupport;

public class SingletonWindowSupport {
    private static int singletonViewInfoID = 0;
    private HashMap contentWindowInfo = new HashMap();
    private WindowInfoSupport vis;
    private FrameWindowSupport frameWindowSupport;
    private HashMap contentFrame = new HashMap();

    public SingletonWindowSupport(WindowInfoSupport vis, FrameWindowSupport fvs) {
        this.vis = vis;
        this.frameWindowSupport = fvs;
    }

    public boolean registerWindow(Class windowClass, Object model, WindowInfo wi) {
        SingletonWindowInfo swi = new SingletonWindowInfo(windowClass, model);
        if (this.contentWindowInfo.containsKey(swi)) {
            if (wi.isModal()) {
                throw new SingletonDialogAlreadyShownException();
            }
            String new_tit = wi.getTitle();
            WindowInfo previous_wi = (WindowInfo)this.contentWindowInfo.get(swi);
            previous_wi.setTitle(new_tit);
            wi.setWindowInfo(previous_wi);
            return true;
        }
        this.contentWindowInfo.put(swi, wi);
        return false;
    }

    public void openSingletonWindow(SingletonWindow sw, Component frame) {
        SingletonWindowInfo swi = new SingletonWindowInfo(sw.getClass(), sw.getWindowModel());
        this.contentFrame.put(swi, frame);
    }

    public boolean contains(SingletonWindow sw) {
        SingletonWindowInfo swi = new SingletonWindowInfo(sw.getClass(), sw.getWindowModel());
        return this.contentFrame.containsKey(swi);
    }

    public boolean contains(Class windowClass, Object model) {
        SingletonWindowInfo swi = new SingletonWindowInfo(windowClass, model);
        return this.contentFrame.containsKey(swi);
    }

    public void closeWindow(SingletonWindow sw) {
        SingletonWindowInfo swi = new SingletonWindowInfo(sw.getClass(), sw.getWindowModel());
        WindowInfo windowInfo = (WindowInfo)this.contentWindowInfo.get(swi);
        if (windowInfo != null) {
            this.frameWindowSupport.updateWindowInfo((IWindow)sw, windowInfo);
        }
        this.contentFrame.remove(swi);
    }

    private Component getFrame(SingletonWindowInfo svi) {
        WindowInfo vi = (WindowInfo)this.contentWindowInfo.get(svi);
        return (JInternalFrame)this.contentFrame.get(svi);
    }

    public Component getFrame(Class viewClass, Object model) {
        SingletonWindowInfo svi = new SingletonWindowInfo(viewClass, model);
        return this.getFrame(svi);
    }

    public Component[] getFrames(Object model) {
        ArrayList<Object> ret = new ArrayList<Object>();
        ArrayList keys = this.contentFrame.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            SingletonWindowInfo svi = (SingletonWindowInfo)keys.get(i);
            if (svi.modelo != model) continue;
            ret.add(this.contentFrame.get(svi));
        }
        return ret.toArray(new JInternalFrame[0]);
    }

    public Component getFrame(SingletonWindow sv) {
        SingletonWindowInfo svi = new SingletonWindowInfo(sv.getClass(), sv.getWindowModel());
        return this.getFrame(svi);
    }

    public void setX(SingletonWindow sv, int x) {
        JInternalFrame o = (JInternalFrame)this.contentFrame.get(new SingletonWindowInfo(sv.getClass(), sv.getWindowModel()));
        if (o == null) {
            return;
        }
        o.setLocation(x, o.getY());
    }

    public void setY(SingletonWindow sv, int y) {
        JInternalFrame o = (JInternalFrame)this.contentFrame.get(new SingletonWindowInfo(sv.getClass(), sv.getWindowModel()));
        if (o == null) {
            return;
        }
        o.setLocation(o.getX(), y);
    }

    public void setHeight(SingletonWindow sv, int height) {
        JInternalFrame o = (JInternalFrame)this.contentFrame.get(new SingletonWindowInfo(sv.getClass(), sv.getWindowModel()));
        if (o == null) {
            return;
        }
        o.setSize(o.getWidth(), height);
    }

    public void setWidth(SingletonWindow sv, int width) {
        JInternalFrame o = (JInternalFrame)this.contentFrame.get(new SingletonWindowInfo(sv.getClass(), sv.getWindowModel()));
        if (o == null) {
            return;
        }
        o.setSize(width, o.getHeight());
    }

    public void setMaximized(SingletonWindow sw, boolean maximized) {
        JInternalFrame frame = (JInternalFrame)this.contentFrame.get(new SingletonWindowInfo(sw.getClass(), sw.getWindowModel()));
        if (frame == null) {
            return;
        }
        try {
            frame.setMaximum(maximized);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void setNormalBounds(SingletonWindow sw, Rectangle normalBounds) {
        JInternalFrame frame = (JInternalFrame)this.contentFrame.get(new SingletonWindowInfo(sw.getClass(), sw.getWindowModel()));
        if (frame == null) {
            return;
        }
        frame.setNormalBounds(normalBounds);
    }

    public void setMinimumSize(SingletonWindow sw, Dimension minSize) {
        JInternalFrame frame = (JInternalFrame)this.contentFrame.get(new SingletonWindowInfo(sw.getClass(), sw.getWindowModel()));
        if (frame == null) {
            return;
        }
        frame.setMinimumSize(minSize);
    }

    public void setTitle(SingletonWindow sv, String title) {
        JInternalFrame o = (JInternalFrame)this.contentFrame.get(new SingletonWindowInfo(sv.getClass(), sv.getWindowModel()));
        if (o == null) {
            return;
        }
        o.setTitle(title);
    }

    private class HashMap {
        private ArrayList keys = new ArrayList();
        private ArrayList values = new ArrayList();

        private HashMap() {
        }

        public void put(SingletonWindowInfo key, Object value) {
            int index = -1;
            for (int i = 0; i < this.keys.size(); ++i) {
                if (!this.keys.get(i).equals(key)) continue;
                index = i;
                break;
            }
            if (index != -1) {
                this.keys.add(index, key);
                this.values.add(index, value);
            } else {
                this.keys.add(key);
                this.values.add(value);
            }
        }

        public boolean containsKey(SingletonWindowInfo key) {
            for (int i = 0; i < this.keys.size(); ++i) {
                if (!this.keys.get(i).equals(key)) continue;
                return true;
            }
            return false;
        }

        public Object get(SingletonWindowInfo key) {
            for (int i = 0; i < this.keys.size(); ++i) {
                if (!this.keys.get(i).equals(key)) continue;
                return this.values.get(i);
            }
            return null;
        }

        public void remove(SingletonWindowInfo key) {
            for (int i = 0; i < this.keys.size(); ++i) {
                if (!this.keys.get(i).equals(key)) continue;
                this.keys.remove(i);
                this.values.remove(i);
            }
        }

        public ArrayList getKeys() {
            return this.keys;
        }
    }

    public class SingletonWindowInfo {
        public int id;
        public Class clase;
        public Object modelo;

        public SingletonWindowInfo(Class clase, Object modelo) {
            this.clase = clase;
            this.modelo = modelo;
            this.id = singletonViewInfoID;
            singletonViewInfoID++;
        }

        public boolean equals(Object obj) {
            if (obj.getClass() != SingletonWindowInfo.class) {
                return false;
            }
            SingletonWindowInfo s = (SingletonWindowInfo)obj;
            return this.clase == s.clase && this.modelo == s.modelo;
        }
    }
}

