/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vfsjfilechooser2.plaf.metal;

import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import com.googlecode.vfsjfilechooser2.filechooser.AbstractVFSFileFilter;
import com.googlecode.vfsjfilechooser2.filechooser.AbstractVFSFileSystemView;
import com.googlecode.vfsjfilechooser2.filechooser.PopupHandler;
import com.googlecode.vfsjfilechooser2.filepane.VFSFilePane;
import com.googlecode.vfsjfilechooser2.plaf.VFSFileChooserUIAccessorIF;
import com.googlecode.vfsjfilechooser2.plaf.basic.BasicVFSDirectoryModel;
import com.googlecode.vfsjfilechooser2.plaf.basic.BasicVFSFileChooserUI;
import com.googlecode.vfsjfilechooser2.plaf.metal.AlignedLabel;
import com.googlecode.vfsjfilechooser2.plaf.metal.ButtonAreaLayout;
import com.googlecode.vfsjfilechooser2.plaf.metal.FilterComboBoxRenderer;
import com.googlecode.vfsjfilechooser2.plaf.metal.IndentIcon;
import com.googlecode.vfsjfilechooser2.utils.VFSResources;
import com.googlecode.vfsjfilechooser2.utils.VFSUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;

public class MetalVFSFileChooserUI
extends BasicVFSFileChooserUI {
    private static final Dimension hstrut5 = new Dimension(5, 1);
    private static final Dimension vstrut5 = new Dimension(1, 5);
    private static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    private static int PREF_WIDTH = 500;
    private static int PREF_HEIGHT = 326;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static int MIN_WIDTH = 500;
    private static int MIN_HEIGHT = 326;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    private static int LIST_PREF_WIDTH = 405;
    private static int LIST_PREF_HEIGHT = 135;
    private static Dimension LIST_PREF_SIZE = new Dimension(LIST_PREF_WIDTH, LIST_PREF_HEIGHT);
    private JLabel lookInLabel;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField fileNameTextField;
    private VFSFilePane filePane;
    private JToggleButton listViewButton;
    private JToggleButton detailsViewButton;
    private boolean useShellFolder;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JComboBox filterComboBox;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private String fileNameLabelText = null;
    private String folderNameLabelText = null;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String homeFolderToolTipText = null;
    private String homeFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String newFolderAccessibleName = null;
    private String listViewButtonToolTipText = null;
    private String listViewButtonAccessibleName = null;
    private String detailsViewButtonToolTipText = null;
    private String detailsViewButtonAccessibleName = null;
    private VFSJFileChooser chooser;
    private AlignedLabel fileNameLabel;
    private JPanel topButtonPanel;
    private JButton upFolderButton;
    private JButton homeFolderButton;
    private JButton newFolderButton;

    public MetalVFSFileChooserUI(VFSJFileChooser filechooser) {
        super(filechooser);
        this.chooser = filechooser;
    }

    private void populateFileNameLabel() {
        if (this.getFileChooser().getFileSelectionMode() == VFSJFileChooser.SELECTION_MODE.DIRECTORIES_ONLY) {
            this.fileNameLabel.setText(this.folderNameLabelText);
        } else {
            this.fileNameLabel.setText(this.fileNameLabelText);
        }
    }

    public static ComponentUI createUI(JComponent c) {
        MetalVFSFileChooserUI mui = new MetalVFSFileChooserUI((VFSJFileChooser)c);
        return mui;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    public void uninstallComponents(VFSJFileChooser fc) {
        fc.removeAll();
        this.bottomPanel = null;
        this.buttonPanel = null;
    }

    public JPanel getNavigationButtonsPanel() {
        return this.topButtonPanel;
    }

    public JButton getUpFolderButton() {
        return this.upFolderButton;
    }

    public JButton getHomeFolderButton() {
        return this.homeFolderButton;
    }

    public JButton getNewFolderButton() {
        return this.newFolderButton;
    }

    @Override
    public void installComponents(VFSJFileChooser fc) {
        AbstractVFSFileSystemView fsv = fc.getFileSystemView();
        fc.setBorder(new EmptyBorder(12, 12, 11, 11));
        fc.setLayout(new BorderLayout(0, 11));
        this.filePane = new VFSFilePane(new MetalVFSFileChooserUIAccessor());
        fc.addPropertyChangeListener(this.filePane);
        this.updateUseShellFolder();
        JPanel topPanel = new JPanel(new BorderLayout(11, 0));
        this.topButtonPanel = new JPanel();
        this.topButtonPanel.setLayout(new BoxLayout(this.topButtonPanel, 2));
        topPanel.add((Component)this.topButtonPanel, "After");
        fc.add((Component)topPanel, "North");
        this.lookInLabel = new JLabel(this.lookInLabelText);
        topPanel.add((Component)this.lookInLabel, "Before");
        this.directoryComboBox = new JComboBox(){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = 150;
                return d;
            }
        };
        this.directoryComboBox.putClientProperty("AccessibleDescription", this.lookInLabelText);
        this.directoryComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.lookInLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(fc);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(fc));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.0f);
        this.directoryComboBox.setMaximumRowCount(8);
        topPanel.add((Component)this.directoryComboBox, "Center");
        this.upFolderButton = new JButton(this.getChangeToParentDirectoryAction());
        this.upFolderButton.setText(null);
        this.upFolderButton.setIcon(this.upFolderIcon);
        this.upFolderButton.setToolTipText(this.upFolderToolTipText);
        this.upFolderButton.putClientProperty("AccessibleName", this.upFolderAccessibleName);
        this.upFolderButton.setAlignmentX(0.0f);
        this.upFolderButton.setAlignmentY(0.5f);
        this.upFolderButton.setMargin(shrinkwrap);
        this.topButtonPanel.add(this.upFolderButton);
        this.topButtonPanel.add(Box.createRigidArea(hstrut5));
        FileObject homeDir = fsv.getHomeDirectory();
        String toolTipText = this.homeFolderToolTipText;
        if (fsv.isRoot(homeDir)) {
            toolTipText = this.getFileView(fc).getName(homeDir);
        }
        JButton b = new JButton(this.homeFolderIcon);
        b.setToolTipText(toolTipText);
        b.putClientProperty("AccessibleName", this.homeFolderAccessibleName);
        b.setAlignmentX(0.0f);
        b.setAlignmentY(0.5f);
        b.setMargin(shrinkwrap);
        b.addActionListener(this.getGoHomeAction());
        this.topButtonPanel.add(b);
        this.topButtonPanel.add(Box.createRigidArea(hstrut5));
        if (!UIManager.getBoolean("FileChooser.readOnly")) {
            b = new JButton(this.filePane.getNewFolderAction());
            b.setText(null);
            b.setIcon(this.newFolderIcon);
            b.setToolTipText(this.newFolderToolTipText);
            b.putClientProperty("AccessibleName", this.newFolderAccessibleName);
            b.setAlignmentX(0.0f);
            b.setAlignmentY(0.5f);
            b.setMargin(shrinkwrap);
        }
        this.topButtonPanel.add(b);
        this.topButtonPanel.add(Box.createRigidArea(hstrut5));
        ButtonGroup viewButtonGroup = new ButtonGroup();
        this.listViewButton = new JToggleButton(this.listViewIcon);
        this.listViewButton.setToolTipText(this.listViewButtonToolTipText);
        this.listViewButton.putClientProperty("AccessibleName", this.listViewButtonAccessibleName);
        this.listViewButton.setSelected(true);
        this.listViewButton.setAlignmentX(0.0f);
        this.listViewButton.setAlignmentY(0.5f);
        this.listViewButton.setMargin(shrinkwrap);
        this.listViewButton.addActionListener(this.filePane.getViewTypeAction(0));
        this.topButtonPanel.add(this.listViewButton);
        viewButtonGroup.add(this.listViewButton);
        this.detailsViewButton = new JToggleButton(this.detailsViewIcon);
        this.detailsViewButton.setToolTipText(this.detailsViewButtonToolTipText);
        this.detailsViewButton.putClientProperty("AccessibleName", this.detailsViewButtonAccessibleName);
        this.detailsViewButton.setAlignmentX(0.0f);
        this.detailsViewButton.setAlignmentY(0.5f);
        this.detailsViewButton.setMargin(shrinkwrap);
        this.detailsViewButton.addActionListener(this.filePane.getViewTypeAction(1));
        this.topButtonPanel.add(this.detailsViewButton);
        viewButtonGroup.add(this.detailsViewButton);
        this.filePane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("viewType".equals(e.getPropertyName())) {
                    int viewType = MetalVFSFileChooserUI.this.filePane.getViewType();
                    if (viewType == 0) {
                        MetalVFSFileChooserUI.this.listViewButton.setSelected(true);
                    } else if (viewType == 1) {
                        MetalVFSFileChooserUI.this.detailsViewButton.setSelected(true);
                    }
                }
            }
        });
        fc.add((Component)this.getAccessoryPanel(), "After");
        JComponent accessory = fc.getAccessory();
        if (accessory != null) {
            this.getAccessoryPanel().add(accessory);
        }
        this.filePane.setPreferredSize(LIST_PREF_SIZE);
        fc.add((Component)this.filePane, "Center");
        this.bottomPanel = this.getBottomPanel();
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 1));
        fc.add((Component)this.bottomPanel, "South");
        JPanel fileNamePanel = new JPanel();
        fileNamePanel.setLayout(new BoxLayout(fileNamePanel, 2));
        this.bottomPanel.add(fileNamePanel);
        this.bottomPanel.add(Box.createRigidArea(vstrut5));
        this.fileNameLabel = new AlignedLabel();
        this.populateFileNameLabel();
        fileNamePanel.add(this.fileNameLabel);
        this.fileNameTextField = new JTextField(35){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        PopupHandler.installDefaultMouseListener(this.fileNameTextField);
        fileNamePanel.add(this.fileNameTextField);
        this.fileNameLabel.setLabelFor(this.fileNameTextField);
        this.fileNameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!MetalVFSFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                    MetalVFSFileChooserUI.this.filePane.clearSelection();
                }
            }
        });
        if (fc.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(fc.getSelectedFileObjects()));
        } else {
            this.setFileName(this.fileNameString(fc.getSelectedFileObject()));
        }
        JPanel filesOfTypePanel = new JPanel();
        filesOfTypePanel.setLayout(new BoxLayout(filesOfTypePanel, 2));
        this.bottomPanel.add(filesOfTypePanel);
        AlignedLabel filesOfTypeLabel = new AlignedLabel(this.filesOfTypeLabelText);
        filesOfTypePanel.add(filesOfTypeLabel);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        fc.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        this.filterComboBox.putClientProperty("AccessibleDescription", this.filesOfTypeLabelText);
        filesOfTypeLabel.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        filesOfTypePanel.add(this.filterComboBox);
        this.getButtonPanel().setLayout(new ButtonAreaLayout());
        this.approveButton = new JButton(this.getApproveButtonText(fc));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    MetalVFSFileChooserUI.this.getApproveSelectionAction().actionPerformed(null);
                } else if (e.getKeyCode() == 27) {
                    MetalVFSFileChooserUI.this.getFileChooser().cancelSelection();
                }
            }
        });
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        this.getButtonPanel().add(this.approveButton);
        this.cancelButton = new JButton(this.cancelButtonText);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.getButtonPanel().add(this.cancelButton);
        if (fc.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
        MetalVFSFileChooserUI.groupLabels(new AlignedLabel[]{this.fileNameLabel, filesOfTypeLabel});
    }

    private void updateUseShellFolder() {
        VFSJFileChooser fc = this.getFileChooser();
        Boolean prop = (Boolean)fc.getClientProperty("FileChooser.useShellFolder");
        this.useShellFolder = prop != null ? prop.booleanValue() : fc.getFileSystemView().equals(AbstractVFSFileSystemView.getFileSystemView());
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
        }
        return this.buttonPanel;
    }

    protected JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
        }
        return this.bottomPanel;
    }

    @Override
    protected void installStrings(VFSJFileChooser fc) {
        super.installStrings(fc);
        this.lookInLabelText = VFSResources.getMessage("VFSJFileChooser.lookInLabelText");
        this.saveInLabelText = VFSResources.getMessage("VFSJFileChooser.saveInLabelText");
        this.folderNameLabelText = this.fileNameLabelText = VFSResources.getMessage("VFSJFileChooser.fileNameLabelText");
        this.filesOfTypeLabelText = VFSResources.getMessage("VFSJFileChooser.filesOfTypeLabelText");
        this.upFolderToolTipText = VFSResources.getMessage("VFSJFileChooser.upFolderToolTipText");
        this.upFolderAccessibleName = VFSResources.getMessage("VFSJFileChooser.upFolderAccessibleName");
        this.homeFolderToolTipText = VFSResources.getMessage("VFSJFileChooser.homeFolderToolTipText");
        this.homeFolderAccessibleName = VFSResources.getMessage("VFSJFileChooser.homeFolderAccessibleName");
        this.newFolderToolTipText = VFSResources.getMessage("VFSJFileChooser.newFolderToolTipText");
        this.newFolderAccessibleName = VFSResources.getMessage("VFSJFileChooser.newFolderAccessibleName");
        this.listViewButtonToolTipText = VFSResources.getMessage("VFSJFileChooser.listViewButtonToolTipText");
        this.listViewButtonAccessibleName = VFSResources.getMessage("VFSJFileChooser.listViewButtonAccessibleName");
        this.detailsViewButtonToolTipText = VFSResources.getMessage("VFSJFileChooser.detailsViewButtonToolTipText");
        this.detailsViewButtonAccessibleName = VFSResources.getMessage("VFSJFileChooser.detailsViewButtonAccessibleName");
    }

    @Override
    protected void installListeners(VFSJFileChooser fc) {
        super.installListeners(fc);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(fc, actionMap);
    }

    @Override
    protected ActionMap getActionMap() {
        return this.createActionMap();
    }

    @Override
    protected ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        VFSFilePane.addActionsToMap(map, this.filePane.getActions());
        return map;
    }

    protected JPanel createList(VFSJFileChooser fc) {
        return this.filePane.createList();
    }

    protected JPanel createDetailsView(VFSJFileChooser fc) {
        return this.filePane.createDetailsView();
    }

    @Override
    public ListSelectionListener createListSelectionListener(VFSJFileChooser fc) {
        return super.createListSelectionListener(fc);
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.filterComboBoxModel);
        c.removePropertyChangeListener(this.filePane);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.removeActionListener(this.getApproveSelectionAction());
        if (this.filePane != null) {
            this.filePane.uninstallUI();
            this.filePane = null;
        }
        super.uninstallUI(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int prefWidth = MetalVFSFileChooserUI.PREF_SIZE.width;
        Dimension d = c.getLayout().preferredLayoutSize(c);
        if (d != null) {
            return new Dimension(d.width < prefWidth ? prefWidth : d.width, d.height < MetalVFSFileChooserUI.PREF_SIZE.height ? MetalVFSFileChooserUI.PREF_SIZE.height : d.height);
        }
        return new Dimension(prefWidth, MetalVFSFileChooserUI.PREF_SIZE.height);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return MIN_SIZE;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private String fileNameString(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        VFSJFileChooser fc = this.getFileChooser();
        if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled() || fc.isDirectorySelectionEnabled() && fc.isFileSelectionEnabled() && fc.getFileSystemView().isFileSystemRoot(fileObject)) {
            String url = null;
            try {
                url = fileObject.getURL().toExternalForm();
            }
            catch (FileSystemException ex) {
                ex.printStackTrace();
            }
            return url;
        }
        return fileObject.getName().getBaseName();
    }

    private String fileNameString(FileObject[] files) {
        StringBuilder buf = new StringBuilder();
        int fileCount = files.length;
        for (int i = 0; files != null && i < fileCount; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            if (fileCount > 1) {
                buf.append("\"");
            }
            buf.append(this.fileNameString(files[i]));
            if (fileCount <= 1) continue;
            buf.append("\"");
        }
        return buf.toString();
    }

    private void doSelectedFileChanged(PropertyChangeEvent e) {
        FileObject f = (FileObject)e.getNewValue();
        VFSJFileChooser fc = this.getFileChooser();
        if (f != null && (fc.isFileSelectionEnabled() && !VFSUtils.isDirectory(f) || VFSUtils.isDirectory(f) && fc.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(f));
        }
    }

    private void doSelectedFilesChanged(PropertyChangeEvent e) {
        FileObject[] files = (FileObject[])e.getNewValue();
        VFSJFileChooser fc = this.getFileChooser();
        if (files != null && files.length > 0 && (files.length > 1 || fc.isDirectorySelectionEnabled() || !VFSUtils.isDirectory(files[0]))) {
            this.setFileName(this.fileNameString(files));
        }
    }

    private void doDirectoryChanged(PropertyChangeEvent e) {
        VFSJFileChooser fc = this.getFileChooser();
        AbstractVFSFileSystemView fsv = fc.getFileSystemView();
        this.clearIconCache();
        FileObject currentDirectory = fc.getCurrentDirectoryObject();
        if (currentDirectory != null) {
            this.directoryComboBoxModel.addItem(currentDirectory);
            this.directoryComboBox.setSelectedItem(currentDirectory);
            fc.setCurrentDirectoryObject(currentDirectory);
            if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
                if (fsv.isFileSystem(currentDirectory)) {
                    String url = null;
                    try {
                        url = currentDirectory.getURL().toExternalForm();
                    }
                    catch (FileSystemException e1) {
                        e1.printStackTrace();
                    }
                    this.setFileName(url);
                } else {
                    this.setFileName(null);
                }
            }
        }
    }

    private void doFilterChanged(PropertyChangeEvent e) {
        this.clearIconCache();
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent e) {
        if (this.fileNameLabel != null) {
            this.populateFileNameLabel();
        }
        this.clearIconCache();
        VFSJFileChooser fc = this.getFileChooser();
        FileObject currentDirectory = fc.getCurrentDirectoryObject();
        if (currentDirectory != null && fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled() && fc.getFileSystemView().isFileSystem(currentDirectory)) {
            String url = null;
            try {
                url = currentDirectory.getURL().toExternalForm();
            }
            catch (FileSystemException e1) {
                e1.printStackTrace();
            }
            this.setFileName(url);
        } else {
            this.setFileName(null);
        }
    }

    private void doAccessoryChanged(PropertyChangeEvent e) {
        if (this.getAccessoryPanel() != null) {
            JComponent accessory;
            if (e.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)e.getOldValue());
            }
            if ((accessory = (JComponent)e.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)accessory, "Center");
            }
        }
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent e) {
        VFSJFileChooser m_chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(m_chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(m_chooser));
    }

    private void doDialogTypeChanged(PropertyChangeEvent e) {
        VFSJFileChooser m_chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(m_chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(m_chooser));
        if (m_chooser.getDialogType() == VFSJFileChooser.DIALOG_TYPE.SAVE) {
            this.lookInLabel.setText(this.saveInLabelText);
        } else {
            this.lookInLabel.setText(this.lookInLabelText);
        }
    }

    private void doApproveButtonMnemonicChanged(PropertyChangeEvent e) {
    }

    private void doControlButtonsChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener(VFSJFileChooser fc) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String s = e.getPropertyName();
                if (s.equals("SelectedFileChangedProperty")) {
                    MetalVFSFileChooserUI.this.doSelectedFileChanged(e);
                } else if (s.equals("SelectedFilesChangedProperty")) {
                    MetalVFSFileChooserUI.this.doSelectedFilesChanged(e);
                } else if (s.equals("directoryChanged")) {
                    MetalVFSFileChooserUI.this.doDirectoryChanged(e);
                } else if (s.equals("fileFilterChanged")) {
                    MetalVFSFileChooserUI.this.doFilterChanged(e);
                } else if (s.equals("fileSelectionChanged")) {
                    MetalVFSFileChooserUI.this.doFileSelectionModeChanged(e);
                } else if (s.equals("AccessoryChangedProperty")) {
                    MetalVFSFileChooserUI.this.doAccessoryChanged(e);
                } else if (s.equals("ApproveButtonTextChangedProperty") || s.equals("ApproveButtonToolTipTextChangedProperty")) {
                    MetalVFSFileChooserUI.this.doApproveButtonTextChanged(e);
                } else if (s.equals("DialogTypeChangedProperty")) {
                    MetalVFSFileChooserUI.this.doDialogTypeChanged(e);
                } else if (s.equals("ApproveButtonMnemonicChangedProperty")) {
                    MetalVFSFileChooserUI.this.doApproveButtonMnemonicChanged(e);
                } else if (s.equals("ControlButtonsAreShownChangedProperty")) {
                    MetalVFSFileChooserUI.this.doControlButtonsChanged(e);
                } else if (s.equals("componentOrientation")) {
                    ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                    VFSJFileChooser cc = (VFSJFileChooser)e.getSource();
                    if (o != (ComponentOrientation)e.getOldValue()) {
                        cc.applyComponentOrientation(o);
                    }
                } else if (s.equals("FileChooser.useShellFolder")) {
                    MetalVFSFileChooserUI.this.updateUseShellFolder();
                    MetalVFSFileChooserUI.this.doDirectoryChanged(e);
                } else if (s.equals("ancestor") && e.getOldValue() == null && e.getNewValue() != null) {
                    MetalVFSFileChooserUI.this.fileNameTextField.selectAll();
                    MetalVFSFileChooserUI.this.fileNameTextField.requestFocus();
                }
            }
        };
    }

    protected void removeControlButtons() {
        this.getBottomPanel().remove(this.getButtonPanel());
    }

    protected void addControlButtons() {
        this.getBottomPanel().add(this.getButtonPanel());
    }

    @Override
    public void ensureFileIsVisible(VFSJFileChooser fc, FileObject f) {
        this.filePane.ensureFileIsVisible(fc, f);
    }

    @Override
    public void rescanCurrentDirectory(VFSJFileChooser fc) {
        this.filePane.rescanCurrentDirectory();
    }

    @Override
    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    @Override
    public void setFileName(String filename) {
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(filename);
        }
    }

    @Override
    protected void setDirectorySelected(boolean directorySelected) {
        super.setDirectorySelected(directorySelected);
        if (directorySelected) {
            if (this.approveButton != null) {
                this.approveButton.setText(this.directoryOpenButtonText);
                this.approveButton.setToolTipText(this.directoryOpenButtonToolTipText);
            }
        } else if (this.approveButton != null) {
            this.approveButton.setText(this.getApproveButtonText(this.chooser));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(this.chooser));
        }
    }

    @Override
    public String getDirectoryName() {
        return null;
    }

    @Override
    public void setDirectoryName(String dirname) {
    }

    protected ListCellRenderer createDirectoryComboBoxRenderer(VFSJFileChooser fc) {
        return new DirectoryComboBoxRenderer();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(VFSJFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    protected ListCellRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    public void valueChanged(ListSelectionEvent e) {
        VFSJFileChooser fc = this.getFileChooser();
        FileObject f = fc.getSelectedFileObject();
        if (!e.getValueIsAdjusting() && f != null && !this.getFileChooser().isTraversable(f)) {
            this.setFileName(this.fileNameString(f));
        }
    }

    @Override
    protected JButton getApproveButton(VFSJFileChooser fc) {
        return this.approveButton;
    }

    private static void groupLabels(AlignedLabel[] group) {
        for (AlignedLabel grp : group) {
            grp.group = group;
        }
    }

    public ComboBoxModel getCombo() {
        return this.directoryComboBoxModel;
    }

    final class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MetalVFSFileChooserUI.this.directoryComboBox.hidePopup();
            FileObject folder = (FileObject)MetalVFSFileChooserUI.this.directoryComboBox.getSelectedItem();
            if (!MetalVFSFileChooserUI.this.getFileChooser().getCurrentDirectory().equals(folder)) {
                MetalVFSFileChooserUI.this.getFileChooser().setCurrentDirectoryObject(folder);
            }
        }
    }

    public final class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected AbstractVFSFileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = MetalVFSFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop.equals("ChoosableFileFilterChangedProperty")) {
                this.filters = (AbstractVFSFileFilter[])e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (prop.equals("fileFilterChanged")) {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public void setSelectedItem(Object filter) {
            if (filter != null) {
                MetalVFSFileChooserUI.this.getFileChooser().setFileFilter((AbstractVFSFileFilter)filter);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            AbstractVFSFileFilter currentFilter = MetalVFSFileChooserUI.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                for (AbstractVFSFileFilter aFilter : this.filters) {
                    if (aFilter != currentFilter) continue;
                    found = true;
                }
                if (!found) {
                    MetalVFSFileChooserUI.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return MetalVFSFileChooserUI.this.getFileChooser().getFileFilter();
        }

        @Override
        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        @Override
        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return MetalVFSFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }
    }

    public final class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        List<FileObject> directories = new CopyOnWriteArrayList<FileObject>();
        int[] depths = null;
        FileObject selectedDirectory = null;
        VFSJFileChooser chooser = MetalVFSFileChooserUI.this.getFileChooser();
        AbstractVFSFileSystemView fsv = this.chooser.getFileSystemView();

        public DirectoryComboBoxModel() {
            FileObject dir = MetalVFSFileChooserUI.this.getFileChooser().getCurrentDirectoryObject();
            if (dir != null) {
                this.addItem(dir);
            }
        }

        private void addItem(FileObject directory) {
            if (directory == null) {
                return;
            }
            this.directories.clear();
            FileObject[] baseFolders = this.fsv.getRoots(directory);
            this.directories.addAll(Arrays.asList(baseFolders));
            try {
                FileObject f = directory;
                ArrayList<FileObject> path = new ArrayList<FileObject>(10);
                do {
                    path.add(f);
                } while ((f = VFSUtils.getParentDirectory(f)) != null);
                int pathCount = path.size();
                for (int i = 0; i < pathCount; ++i) {
                    f = (FileObject)path.get(i);
                    int topIndex = this.directories.indexOf(f);
                    if (topIndex == -1) continue;
                    for (int j = i - 1; j >= 0; --j) {
                        this.directories.add(topIndex + i - j, (FileObject)path.get(j));
                    }
                    break;
                }
                this.calculateDepths();
            }
            catch (Exception ex) {
                this.calculateDepths();
            }
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            int count = this.depths.length;
            block0: for (int i = 0; i < count; ++i) {
                FileObject dir = this.directories.get(i);
                FileObject parent = VFSUtils.getParentDirectory(dir);
                this.depths[i] = 0;
                if (parent == null) continue;
                for (int j = i - 1; j >= 0; --j) {
                    if (!parent.equals(this.directories.get(j))) continue;
                    this.depths[i] = this.depths[j] + 1;
                    continue block0;
                }
            }
        }

        public int getDepth(int i) {
            return this.depths != null && i >= 0 && i < this.depths.length ? this.depths[i] : 0;
        }

        @Override
        public void setSelectedItem(Object selectedDirectory) {
            if (selectedDirectory.equals(this.selectedDirectory)) {
                return;
            }
            this.selectedDirectory = (FileObject)selectedDirectory;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        @Override
        public int getSize() {
            return this.directories.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.directories.get(index);
        }
    }

    private final class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        IndentIcon ii = null;

        private DirectoryComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setText("");
                return this;
            }
            FileObject directory = (FileObject)value;
            String texte = VFSUtils.getFriendlyName(MetalVFSFileChooserUI.this.getFileChooser().getName(directory));
            this.setText(texte);
            Icon icon = MetalVFSFileChooserUI.this.getFileChooser().getIcon(directory);
            this.ii = new IndentIcon(icon);
            this.ii.depth = MetalVFSFileChooserUI.this.directoryComboBoxModel.getDepth(index);
            this.setIcon(this.ii);
            return this;
        }
    }

    final class MetalVFSFileChooserUIAccessor
    implements VFSFileChooserUIAccessorIF {
        MetalVFSFileChooserUIAccessor() {
        }

        @Override
        public VFSJFileChooser getFileChooser() {
            return MetalVFSFileChooserUI.this.chooser;
        }

        @Override
        public BasicVFSDirectoryModel getModel() {
            return MetalVFSFileChooserUI.this.getModel();
        }

        @Override
        public JPanel createList() {
            return MetalVFSFileChooserUI.this.createList(this.getFileChooser());
        }

        @Override
        public JPanel createDetailsView() {
            return MetalVFSFileChooserUI.this.createDetailsView(this.getFileChooser());
        }

        @Override
        public boolean isDirectorySelected() {
            return MetalVFSFileChooserUI.this.isDirectorySelected();
        }

        @Override
        public FileObject getDirectory() {
            return MetalVFSFileChooserUI.this.getDirectory();
        }

        @Override
        public Action getChangeToParentDirectoryAction() {
            return MetalVFSFileChooserUI.this.getChangeToParentDirectoryAction();
        }

        @Override
        public Action getApproveSelectionAction() {
            return MetalVFSFileChooserUI.this.getApproveSelectionAction();
        }

        @Override
        public Action getNewFolderAction() {
            return MetalVFSFileChooserUI.this.getNewFolderAction();
        }

        @Override
        public MouseListener createDoubleClickListener(JList list) {
            return MetalVFSFileChooserUI.this.createDoubleClickListener(this.getFileChooser(), list);
        }

        @Override
        public ListSelectionListener createListSelectionListener() {
            return MetalVFSFileChooserUI.this.createListSelectionListener(this.getFileChooser());
        }

        @Override
        public boolean usesShellFolder() {
            return MetalVFSFileChooserUI.this.useShellFolder;
        }
    }
}

