/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.gui;

import com.sardak.antform.gui.Control;
import com.sardak.antform.gui.StylesheetHandler;
import com.sardak.antform.util.MnemonicsUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class ControlPanel
extends JPanel {
    private GridBagLayout layout;
    private JPanel buttonPanel;
    private String title;
    private Control control;
    private JLabel topLabel;
    private JPanel southPanel;
    private JPanel topPanel;
    private JPanel overPanel;
    private JPanel currentPanel;
    private Map mnemonicsMap;
    private HashSet usedLetters;
    private JTabbedPane tabbedPane;
    private StylesheetHandler stylesheetHandler;
    private static final int LEFT_MARGIN = 15;
    private static final int RIGHT_MARGIN = 15;
    private static final int HGAP = 5;
    private static final int VGAP = 5;
    private final boolean DEBUG_BORDERS = false;

    public Control getControl() {
        return this.control;
    }

    public void init() {
        this.usedLetters = new HashSet();
        this.mnemonicsMap = new HashMap();
        this.stylesheetHandler = new StylesheetHandler();
    }

    private final void addLeft(Component component) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(5, 15, 5, 5);
        this.layout.setConstraints(component, gbc);
        this.currentPanel.add(component);
    }

    public JLabel makeLabel(String labelText) {
        JLabel label = new JLabel(labelText);
        this.stylesheetHandler.addLabel(label);
        this.addLeft(label);
        this.setMnemonics(label, labelText);
        return label;
    }

    public void setMnemonics(JComponent component, String labelText) {
        if (this.mnemonicsMap.containsKey(component)) {
            return;
        }
        String sToUse = null;
        boolean isSet = false;
        sToUse = MnemonicsUtil.newMnemonic(labelText, this.usedLetters);
        boolean bl = isSet = sToUse != null;
        if (isSet) {
            char toUse = sToUse.charAt(0);
            if (component instanceof JLabel) {
                ((JLabel)component).setDisplayedMnemonic(toUse);
            } else if (component instanceof JButton) {
                ((JButton)component).setMnemonic(toUse);
            }
            this.mnemonicsMap.put(component, sToUse);
        }
    }

    public final void addRight(Component component) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(5, 5, 5, 15);
        this.layout.setConstraints(component, gbc);
        this.currentPanel.add(component);
    }

    public final void addCentered(Component component) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(5, 15, 5, 15);
        this.layout.setConstraints(component, gbc);
        this.currentPanel.add(component);
    }

    public final void addCenteredNoFill(Component component) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(15, 15, 15, 15);
        this.layout.setConstraints(component, gbc);
        this.currentPanel.add(component);
    }

    private static Border bigEtched() {
        Border eBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        Border bBorder = BorderFactory.createEtchedBorder();
        return BorderFactory.createCompoundBorder(bBorder, eBorder);
    }

    public static Border linkBorder() {
        Border eBorder = BorderFactory.createEmptyBorder(0, 100, 0, 100);
        Border bBorder = BorderFactory.createEmptyBorder();
        return BorderFactory.createCompoundBorder(bBorder, eBorder);
    }

    public ControlPanel(Control control, boolean tabbed) {
        this.control = control;
        this.topLabel = new JLabel(this.title, 0);
        Font font = this.topLabel.getFont();
        font = font.deriveFont(16.0f);
        font = font.deriveFont(1);
        this.topLabel.setOpaque(false);
        this.topLabel.setFont(font);
        this.setLayout(new BorderLayout());
        this.overPanel = new JPanel();
        this.topPanel = new JPanel();
        this.topPanel.setOpaque(false);
        this.overPanel.setLayout(new BorderLayout());
        this.overPanel.add((Component)this.topPanel, "Center");
        this.overPanel.setOpaque(true);
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 0));
        this.topPanel.add(Box.createHorizontalStrut(10));
        this.topPanel.add(this.topLabel);
        this.topPanel.add(Box.createHorizontalStrut(10));
        this.overPanel.setBorder(ControlPanel.bigEtched());
        this.add((Component)this.overPanel, "North");
        this.layout = new GridBagLayout();
        this.currentPanel = new JPanel();
        this.currentPanel.setBorder(BorderFactory.createEmptyBorder(15, 5, 15, 5));
        this.currentPanel.setLayout(this.layout);
        if (tabbed) {
            this.tabbedPane = new JTabbedPane();
            this.add((Component)this.tabbedPane, "Center");
        } else {
            this.add((Component)this.currentPanel, "Center");
        }
    }

    public void addButtonPanel(JPanel buttonPanel) {
        this.add((Component)buttonPanel, "South");
        this.stylesheetHandler.addPanel(buttonPanel);
        this.buttonPanel = buttonPanel;
    }

    public void addBlankSouthPanel() {
        this.southPanel = new JPanel();
        this.southPanel.setOpaque(true);
        this.southPanel.setBorder(ControlPanel.linkBorder());
        this.add((Component)this.southPanel, "South");
    }

    public void setTitle(String title) {
        this.topLabel.setText(title);
    }

    public JPanel getOverPanel() {
        return this.overPanel;
    }

    public JPanel getSouthPanel() {
        return this.southPanel;
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public JPanel getCurrentPanel() {
        return this.currentPanel;
    }

    public StylesheetHandler getStylesheetHandler() {
        return this.stylesheetHandler;
    }

    public void setStyleSheet(File stylesheet) throws IOException {
        this.stylesheetHandler.apply(stylesheet, this);
    }

    public void setImage(File image) {
        if (image != null) {
            this.overPanel.add((Component)new JLabel(new ImageIcon(image.getAbsolutePath())), "West");
        }
    }

    public HashSet getUsedLetters() {
        return this.usedLetters;
    }

    public void setUsedLetters(HashSet usedLetters) {
        this.usedLetters = usedLetters;
    }

    public void addMenu(JMenu menu) {
        this.control.addMenu(menu);
    }

    public void addToTabbedPane(String label, JPanel tabPanel, GridBagLayout aLayout) {
        this.tabbedPane.addTab(label, tabPanel);
        this.stylesheetHandler.addPanel(tabPanel);
        this.currentPanel = tabPanel;
        this.layout = aLayout;
    }

    public void activateTab(int tabIndex) {
        if (this.tabbedPane != null && tabIndex > -1 && tabIndex < this.tabbedPane.getTabCount()) {
            this.tabbedPane.setSelectedIndex(tabIndex);
        }
    }

    private void debugBorders(JComponent jComponent, Color borderColor) {
        jComponent.setBorder(BorderFactory.createCompoundBorder(new LineBorder(borderColor, 1), jComponent.getBorder()));
    }
}

