/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.utils;

import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserControl {
    private static Logger logger = LoggerFactory.getLogger((String)BrowserControl.class.getName());
    public static final String OPERA = "Opera";
    public static final String NETSCAPE = "Netscape";
    public static final String MOZILLA = "Mozilla";
    public static final String GALEON = "Galeon";
    public static final String EPIPHANY = "Epiphany";
    public static final String FIREFOX = "Firefox";
    public static final String KONQUEROR = "Konqueror";
    private static String browserCommand = "Firefox";
    private static ArrayList supportedBrowsers;
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";

    public static void displayURL(String url) {
        block11: {
            boolean windows = BrowserControl.isWindowsPlatform();
            String cmd = null;
            try {
                if (windows) {
                    cmd = "rundll32 url.dll,FileProtocolHandler " + url;
                    Process process = Runtime.getRuntime().exec(cmd);
                    break block11;
                }
                url = "'" + url.replace("'", "'") + "'";
                if (browserCommand.equals(NETSCAPE) || browserCommand.equals(FIREFOX) || browserCommand.equals(OPERA) || browserCommand.equals(MOZILLA)) {
                    cmd = browserCommand.toLowerCase() + " -remote openURL\\(" + url + "\\)";
                    Process p = BrowserControl.exec(cmd);
                    try {
                        int exitCode = p.waitFor();
                        if (exitCode != 0) {
                            cmd = browserCommand.toLowerCase() + " " + url;
                            p = BrowserControl.exec(cmd);
                        }
                        break block11;
                    }
                    catch (InterruptedException x) {
                        logger.info("Error bringing up browser, cmd='" + cmd + "'");
                        logger.info("Caught: " + x);
                    }
                    break block11;
                }
                if (browserCommand.equals(KONQUEROR)) {
                    cmd = "konqueror " + url;
                    BrowserControl.exec(cmd);
                } else if (browserCommand.equals(EPIPHANY)) {
                    cmd = "epiphany " + url;
                    BrowserControl.exec(cmd);
                } else {
                    cmd = browserCommand.replaceAll("%url|%URL", url);
                    BrowserControl.exec(cmd);
                }
            }
            catch (IOException x) {
                logger.warn("Could not invoke browser, command=" + cmd);
                logger.info("Caught: " + x);
            }
        }
    }

    private static Process exec(String cmd) throws IOException {
        logger.info(cmd);
        return Runtime.getRuntime().exec(cmd);
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith(WIN_ID);
    }

    public static void setBrowserCommand(String browserCommand) {
        BrowserControl.browserCommand = browserCommand;
    }

    public static ArrayList getSupportedBrowsers() {
        if (supportedBrowsers == null) {
            supportedBrowsers = new ArrayList();
            supportedBrowsers.add(KONQUEROR);
            supportedBrowsers.add(FIREFOX);
            supportedBrowsers.add(EPIPHANY);
            supportedBrowsers.add(MOZILLA);
            supportedBrowsers.add(NETSCAPE);
            supportedBrowsers.add(OPERA);
        }
        return supportedBrowsers;
    }
}

