/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class PostProcessSupport {
    private static ArrayList callList = new ArrayList();

    public static void addToPostProcess(Object obj, String strMethod, Object[] parameters, int priority) {
        Call newCall = new Call(obj, strMethod, parameters, priority);
        callList.add(newCall);
    }

    public static void addToPostProcess(Object obj, String strMethod, Object parameter, int priority) {
        Object[] parameters = new Object[]{parameter};
        Call newCall = new Call(obj, strMethod, parameters, priority);
        callList.add(newCall);
    }

    private static void orderByPriority() {
    }

    public static void executeCalls() {
        PostProcessSupport.orderByPriority();
        for (int i = 0; i < callList.size(); ++i) {
            Call call = (Call)callList.get(i);
            try {
                call.executeMethod();
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        PostProcessSupport.clearList();
    }

    public static void clearList() {
        callList.clear();
    }

    private static class Call {
        private Object obj;
        private Method method;
        private Object[] parameters;
        private int priority;

        public Call(Object obj, String strMethod, Object[] parameters, int priority) {
            this.obj = obj;
            this.parameters = parameters;
            Class[] classParams = new Class[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                classParams[i] = parameters[i].getClass();
            }
            try {
                this.method = obj.getClass().getMethod(strMethod, classParams);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                Method[] list = obj.getClass().getMethods();
                for (int i = 0; i < list.length; ++i) {
                    if (list[i].getName().compareTo(strMethod) != 0) continue;
                    boolean encontrado = true;
                    Class<?>[] params = list[i].getParameterTypes();
                    for (int j = 0; j < params.length; ++j) {
                        boolean bParamOK = false;
                        if (params[j].isInstance(parameters[j])) {
                            bParamOK = true;
                            continue;
                        }
                        Class<?>[] theInterfaces = parameters[j].getClass().getInterfaces();
                        for (int k = 0; k < theInterfaces.length; ++k) {
                            if (theInterfaces[k].getName().compareTo(params[j].getName()) != 0) continue;
                            bParamOK = true;
                            break;
                        }
                        if (bParamOK) continue;
                        encontrado = false;
                        break;
                    }
                    if (!encontrado) continue;
                    this.method = list[i];
                    return;
                }
                e.printStackTrace();
            }
        }

        public Object executeMethod() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return this.method.invoke(this.obj, this.parameters);
        }
    }
}

