/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.utils.swing.jtable;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.BitSet;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.gvsig.utils.swing.jtable.FieldSelectionEvent;
import org.gvsig.utils.swing.jtable.FieldSelectionListener;
import org.gvsig.utils.swing.jtable.FieldSelectionListenerSupport;

public class SelectionHeaderSupport {
    private SelectionCellRenderer cellRenderer = new SelectionCellRenderer();
    private FieldSelectionListenerSupport listenerSupport = new FieldSelectionListenerSupport();

    public void setTableHeader(final JTableHeader header) {
        header.setDefaultRenderer(this.cellRenderer);
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                for (int i = 0; i < header.getColumnModel().getColumnCount(); ++i) {
                    if (!header.getHeaderRect(i).contains(e.getPoint())) continue;
                    if ((e.getModifiersEx() & 0x80) == 128) {
                        SelectionHeaderSupport.this.cellRenderer.toggleSelection(i);
                    } else {
                        SelectionHeaderSupport.this.cellRenderer.setSelection(i);
                    }
                    FieldSelectionEvent evt = new FieldSelectionEvent();
                    evt.setSelectedField(i);
                    evt.setSelectedIndices(SelectionHeaderSupport.this.cellRenderer.selectedColumnIndices);
                    SelectionHeaderSupport.this.callFieldSelected(evt);
                    break;
                }
            }
        });
    }

    public BitSet getSelectedColumns() {
        return this.cellRenderer.selectedColumnIndices;
    }

    public void clearSelectedColumns() {
        this.cellRenderer.selectedColumnIndices.clear();
    }

    public void addFieldSelectionListener(FieldSelectionListener listener) {
        this.listenerSupport.addFieldSelectionListener(listener);
    }

    private void callFieldSelected(FieldSelectionEvent arg0) {
        this.listenerSupport.callFieldSelected(arg0);
    }

    public void removeFieldSelectionListener(FieldSelectionListener listener) {
        this.listenerSupport.removeFieldSelectionListener(listener);
    }

    public class SelectionCellRenderer
    extends JToggleButton
    implements TableCellRenderer {
        private BitSet selectedColumnIndices = new BitSet();

        public SelectionCellRenderer() {
            this.setMargin(new Insets(0, 0, 0, 0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(table.getModel().getColumnName(column));
            this.setSelected(false);
            for (int i = 0; i < this.selectedColumnIndices.cardinality(); ++i) {
                if (!this.selectedColumnIndices.get(column)) continue;
                this.setSelected(true);
            }
            return this;
        }

        public void setSelection(int i) {
            this.selectedColumnIndices.clear();
            this.selectedColumnIndices.set(i);
        }

        public void toggleSelection(int i) {
            this.selectedColumnIndices.flip(i);
        }
    }
}

