/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Grammar;
import org.gvsig.expressionevaluator.GrammarSet;
import org.gvsig.expressionevaluator.Statement;

public class DefaultGrammarSet
implements GrammarSet {
    private final List<Grammar> grammars = new ArrayList<Grammar>();

    public Statement getApplicableStatement(Statement.StatementContext context) {
        for (Grammar grammar : this.grammars) {
            Statement stmt = grammar.getApplicableStatement(context);
            if (stmt == null) continue;
            return stmt;
        }
        return null;
    }

    public boolean isReservedWord(String id) {
        for (Grammar grammar : this.grammars) {
            if (!grammar.isReservedWord(id)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Grammar grammar) {
        if (grammar == null) {
            return false;
        }
        for (Grammar theGrammar : this.grammars) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)theGrammar.getName(), (CharSequence)grammar.getName())) continue;
            return true;
        }
        return false;
    }

    public void add(Grammar grammar) {
        if (grammar == null) {
            return;
        }
        if (this.contains(grammar)) {
            throw new IllegalArgumentException("The grammar set already contains the grammar '" + grammar + "'.");
        }
        this.grammars.add(grammar);
    }

    public Grammar get(int i) {
        return this.grammars.get(i);
    }

    public int size() {
        return this.grammars.size();
    }

    public boolean isEmpty() {
        return this.grammars.isEmpty();
    }

    public List<Grammar> toList() {
        return Collections.unmodifiableList(this.grammars);
    }

    public Iterator<Grammar> iterator() {
        return this.grammars.iterator();
    }
}

