/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.foldersmanager;

import java.io.File;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.folders.FoldersManager;

public class UniqueTemporaryFileFunction
extends AbstractFunction {
    public static final String NAME = "UNIQUETEMPORARYFILE";

    public UniqueTemporaryFileFunction() {
        super("Folders", NAME, Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(1000)), "Return a unique file with the specified relative path to the temporary folder.\nThe base name of the file is modified to be unique.\nThe file will be deleted when the application exits.\n  UNIQUETEMPORARYFILE('folder','name.txt')\nFor this call, the return value will have the form:\n   {PATH}/folder/name-{HEX1}-{HEX2}.txt", "UNIQUETEMPORARYFILE({{pathComponents...}})", new String[]{"pathComponents - relative pathname"}, "File", false);
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        FoldersManager folderManager = ToolsLocator.getFoldersManager();
        String[] pathComponents = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            pathComponents[i] = this.getStr(args, i);
        }
        File f = folderManager.getUniqueTemporaryFile(pathComponents);
        return f;
    }
}

