/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.image;

import cz.vutbr.web.css.MediaSpec;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.lang3.Range;
import org.fit.cssbox.awt.GraphicsEngine;
import org.fit.cssbox.css.CSSNorm;
import org.fit.cssbox.css.DOMAnalyzer;
import org.fit.cssbox.io.DefaultDOMSource;
import org.fit.cssbox.io.DefaultDocumentSource;
import org.fit.cssbox.io.DocumentSource;
import org.fit.cssbox.layout.Dimension;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.tools.swing.api.SimpleImage;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ImageFromHTMLFunction
extends AbstractFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageFromHTMLFunction.class);

    public ImageFromHTMLFunction() {
        super("Image", "IMAGEFROMHTML", Range.is((Comparable)Integer.valueOf(3)), "", "IMAGEFROMHTML({{with}}, height, source)", new String[]{"width - with of the image in pixels", "height - height of the image in pixels", "source - HTML source or URL"}, "SimpleImage", false);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        int width = this.getInt(args, 0);
        int height = this.getInt(args, 1);
        String source = this.getStr(args, 2);
        URL url = null;
        try {
            url = new URL(source);
        }
        catch (Exception ex) {
            LOGGER.debug("Can't parse url", (Throwable)ex);
        }
        BufferedImage img = ImageFromHTMLFunction.createImageFromHTML(width, height, url, source);
        if (img == null) {
            return null;
        }
        SimpleImage simpleimg = ToolsSwingLocator.getToolsSwingManager().createSimpleImage((Object)img);
        return simpleimg;
    }

    public static BufferedImage createImageFromHTML(int width, int height, URL url, String source) {
        try {
            Object docSource;
            String mediaType = "screen";
            Dimension windowSize = new Dimension((float)width, (float)height);
            boolean cropWindow = false;
            boolean loadImages = true;
            boolean loadBackgroundImages = true;
            if (url != null) {
                docSource = new DefaultDocumentSource(url.toString());
            } else {
                final ByteArrayInputStream in = new ByteArrayInputStream(source.getBytes());
                docSource = new DocumentSource(url){

                    public URL getURL() {
                        return null;
                    }

                    public String getContentType() {
                        return "text/html";
                    }

                    public InputStream getInputStream() throws IOException {
                        return in;
                    }

                    public void close() throws IOException {
                        in.close();
                    }
                };
            }
            DefaultDOMSource parser = new DefaultDOMSource((DocumentSource)docSource);
            Document doc = parser.parse();
            MediaSpec media = new MediaSpec(mediaType);
            media.setDimensions(windowSize.width, windowSize.height);
            media.setDeviceDimensions(windowSize.width, windowSize.height);
            DOMAnalyzer da = new DOMAnalyzer(doc, docSource.getURL());
            da.setMediaSpec(media);
            da.attributesToStyles();
            da.addStyleSheet(null, CSSNorm.stdStyleSheet(), DOMAnalyzer.Origin.AGENT);
            da.addStyleSheet(null, CSSNorm.userStyleSheet(), DOMAnalyzer.Origin.AGENT);
            da.addStyleSheet(null, CSSNorm.formsStyleSheet(), DOMAnalyzer.Origin.AGENT);
            da.getStyleSheets();
            GraphicsEngine contentCanvas = new GraphicsEngine(da.getRoot(), da, docSource.getURL());
            contentCanvas.setAutoMediaUpdate(false);
            contentCanvas.getConfig().setClipViewport(cropWindow);
            contentCanvas.getConfig().setLoadImages(loadImages);
            contentCanvas.getConfig().setLoadBackgroundImages(loadBackgroundImages);
            contentCanvas.createLayout(windowSize);
            return contentCanvas.getImage();
        }
        catch (IOException | SAXException ex) {
            return null;
        }
    }
}

