/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.image;

import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.tools.swing.api.SimpleImage;
import org.gvsig.tools.swing.api.ToolsSwingLocator;

public class ImageResizeFunction
extends AbstractFunction {
    public ImageResizeFunction() {
        super("Image", "IMAGERESIZE", Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), "Resize an image, specifing a scale factor or a with and height", "IMAGERESIZE({{image}}, factor)", new String[]{"image", "factor", "width", "height"}, "SimpleImage", false);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        Object arg0 = this.getObject(args, 0);
        SimpleImage image = ToolsSwingLocator.getToolsSwingManager().createSimpleImage(arg0);
        if (image.isEmpty()) {
            return null;
        }
        switch (args.length) {
            case 2: {
                double factor = this.getDouble(args, 1);
                image = image.resize(factor);
                break;
            }
            case 3: {
                int width = this.getInt(args, 1);
                int height = this.getInt(args, 2);
                image = image.resize(width, height);
                break;
            }
            default: {
                throw new ExpressionRuntimeException(null, "Incorrect number of arguments", "The IMAGERESIZE function has 2 arguments, the image and a scale factor, or 3, the image, width and height");
            }
        }
        return image;
    }
}

