/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.numeric;

import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class ASinFunction
extends AbstractFunction {
    public ASinFunction() {
        super("Numeric", "ASIN", Range.is((Comparable)Integer.valueOf(1)), "Returns the arc sine of a value; the returned angle is in the range -pi/2 through pi/2. Special cases:\n- If the argument is NaN or its absolute value is greater than 1, then the result is NaN.\n- If the argument is zero, then the result is a zero with the same sign as the argument.\nThe computed result must be within 1 ulp of the exact result. Results must be semi-monotonic.", "ASIN({{a}})", new String[]{"a - the value whose arc sine is to be returned"}, "Double", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        double r = Math.asin(this.getDouble(args, 0));
        return r;
    }
}

