/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.operator;

import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.impl.function.operator.AbstractBinaryOperator;

public class AndOperator
extends AbstractBinaryOperator {
    public AndOperator() {
        super("Boolean", "AND", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public boolean useArgumentsInsteadObjects() {
        return true;
    }

    public Object call(Interpreter interpreter, Codes args) throws Exception {
        boolean op1 = this.getBoolean(interpreter, args, 0);
        if (!op1) {
            return false;
        }
        boolean op2 = this.getBoolean(interpreter, args, 1);
        return this.call(interpreter, op1, op2);
    }

    @Override
    public Object call(Interpreter interpreter, Object op1, Object op2) {
        if (op1 instanceof Boolean && op2 instanceof Boolean) {
            boolean value = this.getBoolean(op1, 1) && this.getBoolean(op2, 2);
            return value;
        }
        if (op1 == null && op2 == null) {
            return null;
        }
        if (op1 == null || op2 == null) {
            Boolean boolValue = null;
            if (op2 == null && op1 instanceof Boolean) {
                boolValue = this.getBoolean(op1, 1);
            } else if (op1 == null && op2 instanceof Boolean) {
                boolValue = this.getBoolean(op2, 2);
            }
            if (boolValue == null || boolValue.booleanValue()) {
                return null;
            }
            return false;
        }
        throw new IllegalArgumentException("Types not allowed in '" + this.name() + "' operand.");
    }
}

