/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.operator;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.impl.function.operator.AbstractBinaryOperator;

public class InOperator
extends AbstractBinaryOperator {
    public InOperator() {
        super("Boolean", "IN", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    @Override
    public Object call(Interpreter interpreter, Object op1, Object op2) {
        Iterator<Object> it = null;
        if (op2 instanceof Iterator) {
            it = (Iterator)op2;
        } else if (op2 instanceof Iterable) {
            it = ((Iterable)op2).iterator();
        } else if (op2.getClass().isArray()) {
            it = Arrays.asList((Object[])op2).iterator();
        } else {
            throw new IllegalArgumentException("Type not allowed in '" + this.name() + "' operand, expected an Iterator/iterable.");
        }
        while (it.hasNext()) {
            Object x = it.next();
            if (!Objects.equals(x, op1)) continue;
            return true;
        }
        return false;
    }

    public String toString(Codes args, Formatter<Code> formatter) {
        StringBuilder builder = new StringBuilder();
        Code op1 = (Code)args.get(0);
        Code op2 = (Code)args.get(1);
        builder.append("(");
        builder.append(op1.toString(formatter));
        builder.append(" IN ");
        if (op2 instanceof Code.Callable && StringUtils.equalsIgnoreCase((CharSequence)"TUPLE", (CharSequence)((Code.Callable)op2).name())) {
            builder.append("( ");
            builder.append(((Code.Callable)op2).parameters().toString(formatter));
            builder.append(" )");
        } else {
            builder.append(op2.toString(formatter));
        }
        builder.append(")");
        return builder.toString();
    }
}

