/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import java.util.Objects;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.PrettyFormatter;
import org.gvsig.expressionevaluator.impl.function.programming.BreakFunction;
import org.gvsig.expressionevaluator.impl.function.programming.ReturnFunction;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class ForEachFunction
extends AbstractFunction {
    public static final String NAME = "FOREACH";

    public ForEachFunction() {
        super("Programming", NAME, Range.is((Comparable)Integer.valueOf(3)), "The foreach() function evaluate body for every element of the iterable.", "FOR n IN {{expression}}\n  BEGIN\n  PASS;\nEND FOR\n", null, "Object", false);
    }

    public boolean isHidden() {
        return true;
    }

    public boolean useArgumentsInsteadObjects() {
        return true;
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object call(Interpreter interpreter, Codes args) throws Exception {
        if (this.getObject(interpreter, args, 1) == null) {
            return null;
        }
        if (!(interpreter.getSymbolTable() instanceof MutableSymbolTable)) {
            throw new ExpressionRuntimeException("The use of forech loops require a mutable symbol table.");
        }
        MutableSymbolTable symbolTable = (MutableSymbolTable)interpreter.getSymbolTable();
        Object body = null;
        String varname = this.getObject(interpreter, args, 0).toString();
        int argn = 1;
        Iterable iterable = (Iterable)this.getObject(interpreter, args, 1);
        for (Object value : iterable) {
            symbolTable.setVar(varname, value);
            try {
                Object x;
                body = x = this.getObject(interpreter, args, 2);
            }
            catch (BreakFunction.BreakException ex) {
                break;
            }
            catch (ReturnFunction.ReturnException ex) {
                throw ex;
            }
            catch (Exception ex) {
                String stmt = "unknown";
                try {
                    stmt = Objects.toString(args);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LOGGER.warn("Error in foreach function calling arg " + argn + ", " + stmt, (Throwable)ex);
                throw ex;
            }
            ++argn;
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(Codes args, Formatter<Code> formatter) {
        Code codeVarname = (Code)args.get(0);
        Code codeList = (Code)args.get(1);
        Code codeLoopBody = (Code)args.get(2);
        PrettyFormatter builder = PrettyFormatter.get(formatter);
        try {
            builder.push();
            builder.append((Object)"FOR \"");
            builder.append((Object)Objects.toString(((Code.Constant)codeVarname).value()));
            builder.append((Object)"\" IN ");
            builder.append((Object)codeList.toString(formatter));
            builder.append((Object)" LOOP ");
            builder.indent();
            builder.nl();
            if (Code.isFunction((Code)codeLoopBody, (String)"BLOCK")) {
                Code.Callable block = (Code.Callable)codeLoopBody;
                for (Code parameter : block.parameters()) {
                    builder.nl();
                    builder.append((Object)parameter.toString(formatter));
                    builder.append((Object)"; ");
                }
            } else {
                builder.nl();
                builder.append((Object)codeLoopBody.toString(formatter));
                builder.append((Object)" ");
            }
            builder.unindent();
            builder.nl();
            builder.append((Object)"END LOOP");
            String string = builder.build();
            return string;
        }
        finally {
            builder.pop();
        }
    }
}

