/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.tools.util.Size;
import org.gvsig.tools.util.Size64;

public class LenFunction
extends AbstractFunction {
    public static final String NAME = "LEN";

    public LenFunction() {
        super("Programming", NAME, Range.is((Comparable)Integer.valueOf(1)), null, "LEN({{expression}})", null, "Object", false);
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        Number value;
        Object obj = this.getObject(args, 0);
        if (obj == null) {
            return 0;
        }
        if (obj.getClass().isArray()) {
            Object[] x = (Object[])obj;
            value = x.length;
        } else if (obj instanceof List) {
            List l = (List)obj;
            value = l.size();
        } else if (obj instanceof CharSequence) {
            CharSequence s = (CharSequence)obj;
            value = s.length();
        } else if (obj instanceof Map) {
            Map m = (Map)obj;
            value = m.size();
        } else if (obj instanceof Size) {
            Size s = (Size)obj;
            value = s.size();
        } else if (obj instanceof Size64) {
            Size64 s = (Size64)obj;
            value = s.size64();
        } else {
            throw new ExpressionRuntimeException("The LEN function require a String, List, Map or Size and a received a '" + obj.getClass().getSimpleName() + "'.");
        }
        return value;
    }
}

