/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.string;

import org.apache.commons.lang3.Range;
import org.apache.commons.text.StringEscapeUtils;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class EscapeFunction
extends AbstractFunction {
    public static final String FUNCTION_ESCAPE = "ESCAPE";

    public EscapeFunction() {
        super("String", FUNCTION_ESCAPE, Range.is((Comparable)Integer.valueOf(2)), "Encode string data.\nSupported formats are: html, html3, html4, json.", "ESCAPE({{data}}, 'html')", new String[]{"data - A string value with the data to be converted", "format - A string value indicating the format of the output data. The default value is 'html'."}, "String", false);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        String data_s = this.getStr(args, 0);
        String type = this.getStr(args, 1);
        if ("html".equalsIgnoreCase(type)) {
            String data = StringEscapeUtils.escapeHtml4((String)data_s);
            return data;
        }
        if ("html3".equalsIgnoreCase(type)) {
            String data = StringEscapeUtils.escapeHtml3((String)data_s);
            return data;
        }
        if ("html4".equalsIgnoreCase(type)) {
            String data = StringEscapeUtils.escapeHtml4((String)data_s);
            return data;
        }
        if ("json".equalsIgnoreCase(type)) {
            String data = StringEscapeUtils.escapeJson((String)data_s);
            return data;
        }
        throw new IllegalArgumentException("Unsupported format type '" + type + "'.");
    }
}

