/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Time;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Observer;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeModel;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.bookmarksandhistory.Bookmarks;
import org.gvsig.tools.bookmarksandhistory.History;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.ColorChooserController;
import org.gvsig.tools.swing.api.CompoundIcon;
import org.gvsig.tools.swing.api.DropDown;
import org.gvsig.tools.swing.api.FilteredListController;
import org.gvsig.tools.swing.api.FilteredListModel;
import org.gvsig.tools.swing.api.FilteredTableModel;
import org.gvsig.tools.swing.api.FilteredTreeController;
import org.gvsig.tools.swing.api.FilteredTreeModel;
import org.gvsig.tools.swing.api.JListWithCheckbox;
import org.gvsig.tools.swing.api.JWebBrowser;
import org.gvsig.tools.swing.api.JWebBrowserFactory;
import org.gvsig.tools.swing.api.MessageBarController;
import org.gvsig.tools.swing.api.SearchToolbar;
import org.gvsig.tools.swing.api.SimpleImage;
import org.gvsig.tools.swing.api.TableColumnAdjuster;
import org.gvsig.tools.swing.api.TextComponentUndoRedoHelper;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.bookmarkshistory.BookmarksController;
import org.gvsig.tools.swing.api.bookmarkshistory.ComponentWithHistoryAndBookmarkController;
import org.gvsig.tools.swing.api.bookmarkshistory.HistoryController;
import org.gvsig.tools.swing.api.bookmarkshistory.TextFieldWithHistoryAndBookmarkController;
import org.gvsig.tools.swing.api.pickercontroller.CharsetPickerController;
import org.gvsig.tools.swing.api.pickercontroller.ColorPickerController;
import org.gvsig.tools.swing.api.pickercontroller.DataTypePickerController;
import org.gvsig.tools.swing.api.pickercontroller.DatePickerController;
import org.gvsig.tools.swing.api.pickercontroller.FilePickerController;
import org.gvsig.tools.swing.api.pickercontroller.FolderPickerController;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.viewer.JViewer;
import org.gvsig.tools.swing.api.viewer.ViewerFactory;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.swing.icontheme.IconThemeManager;
import org.gvsig.tools.swing.impl.ClearButtonUtils;
import org.gvsig.tools.swing.impl.ClipboardMonitor;
import org.gvsig.tools.swing.impl.ContextMenuUtils;
import org.gvsig.tools.swing.impl.DefaultActionListenerSupport;
import org.gvsig.tools.swing.impl.DefaultChangeListenerHelper;
import org.gvsig.tools.swing.impl.DefaultColorChooserController;
import org.gvsig.tools.swing.impl.DefaultCompoundIcon;
import org.gvsig.tools.swing.impl.DefaultFilteredListController;
import org.gvsig.tools.swing.impl.DefaultFilteredTreeController;
import org.gvsig.tools.swing.impl.DefaultJListWithCheckbox;
import org.gvsig.tools.swing.impl.DefaultSimpleImage;
import org.gvsig.tools.swing.impl.DefaultZoomDialog;
import org.gvsig.tools.swing.impl.DropDownButton;
import org.gvsig.tools.swing.impl.DropDownComboBox;
import org.gvsig.tools.swing.impl.DropDownLabel;
import org.gvsig.tools.swing.impl.DropDownLabelIcon;
import org.gvsig.tools.swing.impl.FilteredListModelImpl;
import org.gvsig.tools.swing.impl.FilteredTableModelImpl;
import org.gvsig.tools.swing.impl.FilteredTreeModelImpl;
import org.gvsig.tools.swing.impl.MessageBarControllerImpl;
import org.gvsig.tools.swing.impl.TableColumnAdjusterImpl;
import org.gvsig.tools.swing.impl.TextComponentUndoRedoHelperImpl;
import org.gvsig.tools.swing.impl.TextLineNumber;
import org.gvsig.tools.swing.impl.TitledSeparator;
import org.gvsig.tools.swing.impl.TreeComboUtils;
import org.gvsig.tools.swing.impl.bookmarkshistory.ComboBoxWithHistoryAndBookmarkControllerImpl;
import org.gvsig.tools.swing.impl.bookmarkshistory.DefaultBookmarksController;
import org.gvsig.tools.swing.impl.bookmarkshistory.DefaultHistoryController;
import org.gvsig.tools.swing.impl.bookmarkshistory.TextFieldWithHistoryAndBookmarkControllerImpl;
import org.gvsig.tools.swing.impl.bufferedImage.VirtualBufferedImageHelper;
import org.gvsig.tools.swing.impl.pickercontroller.BytearrayPickerControllerImpl;
import org.gvsig.tools.swing.impl.pickercontroller.CharsetPickerControllerImpl;
import org.gvsig.tools.swing.impl.pickercontroller.ColorPickerControllerImpl;
import org.gvsig.tools.swing.impl.pickercontroller.DataTypePickerControllerImpl;
import org.gvsig.tools.swing.impl.pickercontroller.DatePickerControllerImpl;
import org.gvsig.tools.swing.impl.pickercontroller.FilePickerControllerImpl;
import org.gvsig.tools.swing.impl.pickercontroller.FolderPickerControllerImpl;
import org.gvsig.tools.swing.impl.pickercontroller.LocalePickerControllerImpl;
import org.gvsig.tools.swing.impl.pickercontroller.nullablespinner.NullableSpinnerUtils;
import org.gvsig.tools.swing.impl.searchtoolbar.SearchToolbarImpl;

public class DefaultToolsSwingManager
implements ToolsSwingManager {
    private Dimension maxPhysicalSizeOfBufferedImage;
    private JWebBrowserFactory webBrowserfactory;
    private Color warningBackgroundColor = new Color(255, 225, 232);
    private Color warningForegroundColor = Color.red.darker();
    private Supplier<Dimension> desktopPanelSizeSupplier;
    private Map<String, ViewerFactory> viewerfacories;

    public void setWarningBackgroundColor(Color warningBackgroundColor) {
        this.warningBackgroundColor = warningBackgroundColor;
    }

    public Color getWarningBackgroundColor() {
        return this.warningBackgroundColor;
    }

    public void setWarningForegroundColor(Color warningForegroundColor) {
        this.warningForegroundColor = warningForegroundColor;
    }

    public Color getWarningForegroundColor() {
        return this.warningForegroundColor;
    }

    public ActionListenerSupport createActionListenerSupport() {
        return new DefaultActionListenerSupport();
    }

    public JListWithCheckbox createJListWithCheckbox(JList wrappedList) {
        return new DefaultJListWithCheckbox(wrappedList);
    }

    public void setTreeModel(JComboBox comboBox, TreeModel aTreeModel) {
        TreeComboUtils.setTreeModel(comboBox, aTreeModel);
    }

    public ComboBoxModel createComboBoxModel(TreeModel treeModel) {
        return TreeComboUtils.createComboBoxModel(treeModel);
    }

    public BufferedImage createBufferedImage(int w, int h, int type) {
        if (this.getMaxPhysicalSizeOfBufferedImage().getWidth() < (double)w || this.getMaxPhysicalSizeOfBufferedImage().getHeight() < (double)h) {
            return this.createVirtualBufferedImage(w, h, type);
        }
        return new BufferedImage(w, h, type);
    }

    public BufferedImage createVirtualBufferedImage(int w, int h, int type) {
        return VirtualBufferedImageHelper.createVirtualBufferedImage(w, h, type);
    }

    public BufferedImage copyBufferedImage(BufferedImage img) {
        WritableRaster sourceRaster = img.getRaster();
        BufferedImage newImage = sourceRaster.getDataBuffer() instanceof VirtualBufferedImageHelper.VirtualDataBuffer ? VirtualBufferedImageHelper.createVirtualBufferedImage(img.getWidth(), img.getHeight(), img.getSampleModel(), img.getColorModel()) : this.createBufferedImage(img.getWidth(), img.getHeight(), img.getType());
        WritableRaster raster = newImage.getRaster();
        img.copyData(raster);
        return newImage;
    }

    public void setMaxPhysicalSizeOfBufferedImage(Dimension dimension) {
        this.maxPhysicalSizeOfBufferedImage = dimension;
    }

    public Dimension getMaxPhysicalSizeOfBufferedImage() {
        if (this.maxPhysicalSizeOfBufferedImage == null) {
            this.maxPhysicalSizeOfBufferedImage = new Dimension(2000, 2000);
        }
        return this.maxPhysicalSizeOfBufferedImage;
    }

    public ColorChooserController createColorChooserController(JTextComponent txtLabel, JButton btnShowDialog, JSlider sldAlpha, boolean allowNull) {
        return new DefaultColorChooserController(txtLabel, btnShowDialog, sldAlpha, allowNull);
    }

    public ColorChooserController createColorChooserController(JTextComponent txtLabel, JButton btnShowDialog) {
        return new DefaultColorChooserController(txtLabel, btnShowDialog);
    }

    public ColorChooserController createColorChooserController(JTextComponent txtLabel, JButton btnShowDialog, JSlider sldAlpha) {
        return new DefaultColorChooserController(txtLabel, btnShowDialog, sldAlpha);
    }

    public Color alphaBlendingWithOpaqueBackground(Color bgColor, Color fgColor) {
        Color src = fgColor;
        Color dst = bgColor;
        double srca = (double)src.getAlpha() / 255.0;
        double srca_1 = 1.0 - srca;
        Color color = new Color((int)((double)src.getRed() * srca + (double)dst.getRed() * srca_1) & 0xFF, (int)((double)src.getGreen() * srca + (double)dst.getGreen() * srca_1) & 0xFF, (int)((double)src.getBlue() * srca + (double)dst.getBlue() * srca_1) & 0xFF);
        return color;
    }

    public Color opaqueColor(Color src) {
        double srca = (double)src.getAlpha() / 255.0;
        double srca_1 = 1.0 - srca;
        Color color = new Color((int)((double)src.getRed() * srca + 255.0 * srca_1) & 0xFF, (int)((double)src.getGreen() * srca + 255.0 * srca_1) & 0xFF, (int)((double)src.getBlue() * srca + 255.0 * srca_1) & 0xFF);
        return color;
    }

    private Object call(Object obj, String name, Object ... params) {
        Class[] types = null;
        if (params != null) {
            types = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                types[i] = params[i].getClass();
            }
        }
        try {
            Method method = obj.getClass().getMethod(name, types);
            Object r = method.invoke(obj, params);
            return r;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return null;
        }
    }

    public void translate(JComponent component) {
        this.translate(component, false);
    }

    public void translate(AbstractButton component) {
        this.translate(component, false);
    }

    public void translate(JLabel component) {
        this.translate(component, false);
    }

    public void translate(JTabbedPane component) {
        this.translate(component, false);
    }

    public void translate(JComponent component, boolean wrap) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        String text = (String)this.call(component, "getText", null);
        if (!StringUtils.isBlank((CharSequence)text)) {
            text = i18n.getTranslation(text);
            if (wrap) {
                text = DefaultToolsSwingManager.toHTML(text);
            }
            this.call(component, "setText", text);
        }
        if (!StringUtils.isEmpty((CharSequence)(text = (String)this.call(component, "getToolTipText", null)))) {
            text = i18n.getTranslation(text);
            this.call(component, "setToolTipText", DefaultToolsSwingManager.toHTML(text));
        }
    }

    public void translate(AbstractButton component, boolean wrap) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        String text = component.getText();
        if (!StringUtils.isBlank((CharSequence)text)) {
            text = i18n.getTranslation(text);
            if (wrap) {
                text = DefaultToolsSwingManager.toHTML(text);
            }
            component.setText(text);
        }
        if (!StringUtils.isBlank((CharSequence)(text = component.getToolTipText()))) {
            text = i18n.getTranslation(text);
            component.setToolTipText(DefaultToolsSwingManager.toHTML(text));
        }
    }

    public void translate(JLabel component, boolean wrap) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        String text = component.getText();
        if (!StringUtils.isBlank((CharSequence)text)) {
            text = i18n.getTranslation(text);
            if (wrap) {
                text = DefaultToolsSwingManager.toHTML(text);
            }
            component.setText(text);
        }
        if (!StringUtils.isBlank((CharSequence)(text = component.getToolTipText()))) {
            text = i18n.getTranslation(text);
            component.setToolTipText(DefaultToolsSwingManager.toHTML(text));
        }
    }

    public void translate(JTabbedPane component, boolean wrap) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        for (int i = 0; i < component.getTabCount(); ++i) {
            String text = component.getTitleAt(i);
            if (!StringUtils.isBlank((CharSequence)text)) {
                text = i18n.getTranslation(text);
                if (wrap) {
                    text = DefaultToolsSwingManager.toHTML(text);
                }
                component.setTitleAt(i, text);
            }
            if (StringUtils.isBlank((CharSequence)(text = component.getToolTipTextAt(i)))) continue;
            text = i18n.getTranslation(text);
            component.setToolTipTextAt(i, DefaultToolsSwingManager.toHTML(text));
        }
    }

    public static String toHTML(String s) {
        s = StringUtils.replace((String)s, (String)"\n", (String)"<br>");
        s = StringUtils.replace((String)s, (String)"<html>", (String)"");
        s = StringUtils.replace((String)s, (String)"</html>", (String)"");
        s = "<html>" + s + "</html>";
        return s;
    }

    public void setDefaultPopupMenu(JTextComponent component) {
        ContextMenuUtils.setDefaultContextMenu(component);
    }

    public void setDefaultPopupMenu(JTextComponent component, String title) {
        ContextMenuUtils.setDefaultContextMenu((JComponent)component, title);
    }

    public void setDefaultPopupMenu(JTextComponent component, String title, boolean textEditor) {
        ContextMenuUtils.setDefaultContextMenu(component, textEditor, title);
    }

    public void setDefaultPopupMenu(JSpinner component, String title, boolean textEditor) {
        ContextMenuUtils.setDefaultContextMenu(component, textEditor, title);
    }

    public void setDefaultPopupMenu(JComboBox component) {
        ContextMenuUtils.setDefaultContextMenu(component);
    }

    public void setDefaultPopupMenu(JComboBox component, String title) {
        ContextMenuUtils.setDefaultContextMenu((JComponent)component, title);
    }

    public ChangeListenerHelper createChangeListenerHelper() {
        DefaultChangeListenerHelper x = new DefaultChangeListenerHelper();
        return x;
    }

    public ColorPickerController createColorPickerController(JTextComponent txtLabel, JButton btnShowDialog, JSlider sldAlpha, boolean allowNull) {
        return new ColorPickerControllerImpl(txtLabel, btnShowDialog, sldAlpha, allowNull);
    }

    public ColorPickerController createColorPickerController(JTextComponent txtLabel, JButton btnShowDialog) {
        return new ColorPickerControllerImpl(txtLabel, btnShowDialog);
    }

    public ColorPickerController createColorPickerController(JTextComponent txtLabel, JButton btnShowDialog, JSlider sldAlpha) {
        return new ColorPickerControllerImpl(txtLabel, btnShowDialog, sldAlpha);
    }

    public DatePickerController createDatePickerController(JTextComponent txtDate, JButton btnDate) {
        return new DatePickerControllerImpl(txtDate, btnDate);
    }

    public FilePickerController createFilePickerController(JTextComponent txtFile, JButton btnFile, String dialogTitle, String fileChooserID, File initialPath, boolean seticon) {
        return new FilePickerControllerImpl(txtFile, btnFile, dialogTitle, fileChooserID, initialPath, seticon);
    }

    public FilePickerController createFilePickerController(JTextComponent txtFile, JButton btnFile) {
        return new FilePickerControllerImpl(txtFile, btnFile);
    }

    public PickerController<byte[]> createByteArrayPickerController(JTextComponent txtText, JButton btnUpload, JButton btnDownload, JButton btnEditAsText, String fileChooserID, File initialPath) {
        return new BytearrayPickerControllerImpl(txtText, btnUpload, btnDownload, btnEditAsText, fileChooserID, initialPath);
    }

    public PickerController<byte[]> createByteArrayPickerController(JTextComponent txtText, JButton btnUpload, JButton btnDownload, String fileChooserID, File initialPath) {
        return new BytearrayPickerControllerImpl(txtText, btnUpload, btnDownload, null, fileChooserID, initialPath);
    }

    public PickerController<byte[]> createByteArrayPickerController(JTextComponent txtText, JButton btnUpload, JButton btnDownload) {
        return new BytearrayPickerControllerImpl(txtText, btnUpload, btnDownload, null, null, null);
    }

    public FilePickerController createFilePickerController(JTextComponent txtFile, JButton btnFile, String dialogTitle) {
        return new FilePickerControllerImpl(txtFile, btnFile, dialogTitle);
    }

    public FolderPickerController createFolderPickerController(JTextComponent txtFile, JButton btnFile, String dialogTitle, String fileChooserID, File initialPath, boolean seticon) {
        return new FolderPickerControllerImpl(txtFile, btnFile, dialogTitle, fileChooserID, initialPath, seticon);
    }

    public FolderPickerController createFolderPickerController(JTextComponent txtFile, JButton btnFile) {
        return new FolderPickerControllerImpl(txtFile, btnFile);
    }

    public FolderPickerController createFolderPickerController(JTextComponent txtFile, JButton btnFile, String dialogTitle) {
        return new FolderPickerControllerImpl(txtFile, btnFile, dialogTitle);
    }

    public CharsetPickerController createCharsetPickerController(JLabel lblCharset, JComboBox cboCharset) {
        return new CharsetPickerControllerImpl(lblCharset, cboCharset);
    }

    public CharsetPickerController createCharsetPickerController(JComboBox cboCharset) {
        return new CharsetPickerControllerImpl(null, cboCharset);
    }

    public PickerController<Locale> createLocalePickerController(JComboBox cboLocale) {
        return new LocalePickerControllerImpl(null, cboLocale);
    }

    public void removeBorder(JComponent component) {
        if (component == null) {
            return;
        }
        try {
            component.setBorder(null);
            JScrollPane scrollPanel = this.getJScrollPane(component);
            if (scrollPanel != null) {
                scrollPanel.setBorder(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JScrollPane getJScrollPane(JComponent component) {
        try {
            JComponent p1 = (JComponent)component.getParent();
            if (p1 instanceof JViewport) {
                p1 = (JComponent)component.getParent();
            }
            if (p1 instanceof JScrollPane) {
                return (JScrollPane)p1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected ImageIcon getIcon(String name) {
        IconThemeManager iconThemeManager = ToolsSwingLocator.getIconThemeManager();
        IconTheme theme = iconThemeManager.getCurrent();
        ImageIcon icon = theme.get(name);
        return icon;
    }

    public void addClearButton(JTextComponent text) {
        ClearButtonUtils.addClearButton(text, null);
    }

    public void addClearButton(JComboBox combo) {
        ClearButtonUtils.addClearButton(combo);
    }

    public void addClearButton(JComboBox combo, ActionListener action) {
        ClearButtonUtils.addClearButton(combo, action);
    }

    public boolean hasClearButton(JComboBox combo) {
        return ClearButtonUtils.hasClearButton(combo);
    }

    public void removeClearButton(JComboBox combo) {
        ClearButtonUtils.removeClearButton(combo);
    }

    public boolean hasClearButton(JTextComponent text) {
        return ClearButtonUtils.hasClearButton(text);
    }

    public void removeClearButton(JTextComponent text) {
        ClearButtonUtils.removeClearButton(text);
    }

    public void addClearButton(JTextComponent text, ActionListener action) {
        ClearButtonUtils.addClearButton(text, action);
    }

    public String showZoomDialog(Component parent, String title, String text, boolean editable) {
        return this.showZoomDialog(parent, title, text, editable, WindowManager.MODE.DIALOG, null);
    }

    public String showZoomDialog(Component parent, String title, String text, boolean editable, WindowManager.MODE mode) {
        return this.showZoomDialog(parent, title, text, editable, mode, null);
    }

    public String showZoomDialog(Component parent, String title, String text, boolean editable, WindowManager.MODE mode, List<Action> customActions) {
        DefaultZoomDialog dialog = new DefaultZoomDialog(parent, title, text, mode, customActions);
        dialog.setEditable(editable);
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
        if (editable) {
            return dialog.getText();
        }
        return text;
    }

    public SimpleImage createSimpleImage() {
        DefaultSimpleImage x = new DefaultSimpleImage();
        return x;
    }

    public SimpleImage createSimpleImage(Object source) {
        if (source instanceof SimpleImage) {
            return (SimpleImage)source;
        }
        DefaultSimpleImage x = new DefaultSimpleImage(source);
        return x;
    }

    public DropDown createDropDown(JComboBox combo) {
        DropDownComboBox c = new DropDownComboBox(combo, this.getWarningBackgroundColor());
        return c;
    }

    public DropDown createDropDown(JLabel label) {
        DropDownLabel c = new DropDownLabel(label, this.getWarningBackgroundColor());
        return c;
    }

    public DropDown createDropDown(AbstractButton button) {
        DropDownButton c = new DropDownButton(button, this.getWarningBackgroundColor());
        return c;
    }

    public DropDown createDropDown(JComponent component) {
        DropDownLabel c = new DropDownLabel(component, this.getWarningBackgroundColor());
        return c;
    }

    public CompoundIcon createCompoundIcon(Icon ... icons) {
        DefaultCompoundIcon i = new DefaultCompoundIcon(icons);
        return i;
    }

    public CompoundIcon createCompoundIcon(int orientation, Icon ... icons) {
        DefaultCompoundIcon i = new DefaultCompoundIcon(orientation, icons);
        return i;
    }

    public CompoundIcon createCompoundIcon(int orientation, int gap, Icon ... icons) {
        DefaultCompoundIcon i = new DefaultCompoundIcon(orientation, gap, icons);
        return i;
    }

    public CompoundIcon createCompoundIcon(int orientation, int gap, int alignmentX, int alignmentY, Icon ... icons) {
        DefaultCompoundIcon i = new DefaultCompoundIcon(orientation, gap, alignmentX, alignmentY, icons);
        return i;
    }

    public BookmarksController createBookmarksController(Bookmarks bookmarks, JButton button) {
        DefaultBookmarksController controller = new DefaultBookmarksController(bookmarks, button);
        return controller;
    }

    public HistoryController createHistoryController(History history, JButton button) {
        DefaultHistoryController controller = new DefaultHistoryController(history, button);
        return controller;
    }

    public TextFieldWithHistoryAndBookmarkController createTextFieldWithHistoryAndBookmarkController(String name, JTextComponent text, JButton btnApply, JButton btnHistory, JButton btnBookmarks) {
        TextFieldWithHistoryAndBookmarkControllerImpl controller = new TextFieldWithHistoryAndBookmarkControllerImpl(name, text, btnApply, btnHistory, btnBookmarks);
        return controller;
    }

    public ComponentWithHistoryAndBookmarkController createComboBoxWithHistoryAndBookmarkController(String name, JComboBox combo) {
        ComboBoxWithHistoryAndBookmarkControllerImpl controller = new ComboBoxWithHistoryAndBookmarkControllerImpl(name, combo);
        return controller;
    }

    public FilteredTableModel createFilteredTableModel(TableModel tableModel, int filterColumn) {
        FilteredTableModelImpl model = new FilteredTableModelImpl(tableModel, filterColumn);
        return model;
    }

    public JLabel createTitledSeparator(String title, int height, int titlePosition, int titleJustification) {
        TitledSeparator c = new TitledSeparator(title, height, titlePosition, titleJustification);
        return c;
    }

    public JLabel createTitledSeparator(String title) {
        TitledSeparator c = new TitledSeparator(title, 2, 0, 0);
        return c;
    }

    public FilteredListModel createFilteredListModel() {
        FilteredListModelImpl model = new FilteredListModelImpl(null);
        return model;
    }

    public FilteredTreeModel createFilteredTreeModel(JTree tree) {
        FilteredTreeModelImpl model = new FilteredTreeModelImpl(tree.getModel());
        return model;
    }

    public FilteredListController createFilteredListController(JList list, JTextComponent text, JButton button) {
        DefaultFilteredListController flc = new DefaultFilteredListController(list, text, button);
        return flc;
    }

    public FilteredTreeController createFilteredTreeController(JTree list, JTextComponent text, JButton button) {
        DefaultFilteredTreeController ftc = new DefaultFilteredTreeController(list, text, button);
        return ftc;
    }

    public JWebBrowser createJWebBrowser() {
        return this.webBrowserfactory.create(new Object[0]);
    }

    public void registerJWebBrowserFactory(JWebBrowserFactory factory) {
        this.webBrowserfactory = factory;
    }

    public JWebBrowserFactory getJWebBrowserFactory() {
        return this.webBrowserfactory;
    }

    public DataTypePickerController createDataTypePickerController(JComboBox cboDataType, JButton btnDataType, boolean allowNull) {
        return new DataTypePickerControllerImpl(cboDataType, btnDataType, allowNull);
    }

    public TableColumnAdjuster createTableColumnAdjuster(JTable table) {
        return TableColumnAdjusterImpl.install(table);
    }

    public MessageBarController createMessageBarController(JLabel txtLabel, int timeDuration) {
        return new MessageBarControllerImpl(txtLabel, timeDuration);
    }

    public DropDown createDropDownIcon(JLabel lblNull) {
        return new DropDownLabelIcon(lblNull, this.getWarningBackgroundColor());
    }

    public void putInClipboard(String data) {
        ClipboardMonitor.getMonitor().put(data);
    }

    public void putInClipboard(String data, String mimetype) {
        ClipboardMonitor.getMonitor().put(data, mimetype);
    }

    public String getFromClipboard() {
        return ClipboardMonitor.getMonitor().getString();
    }

    public boolean isClipboardEmpty() {
        return ClipboardMonitor.getMonitor().hasString();
    }

    public void addClipboardObserver(Observer observer) {
        ClipboardMonitor.getMonitor().addObserver(observer);
    }

    public void deleteClipboardObserver(Observer observer) {
        ClipboardMonitor.getMonitor().deleteObserver(observer);
    }

    public JSpinner spinnerOfNumber(JSpinner spinner, Number value) {
        return NullableSpinnerUtils.ofNumber(spinner, value);
    }

    public JSpinner spinnerOfNumber(JSpinner spinner, Class valueClass) {
        return NullableSpinnerUtils.ofNumber(spinner, valueClass);
    }

    public JSpinner spinnerOfIntegers(JSpinner spinner, Integer value, int minimum, int maximum, int stepSize) {
        return NullableSpinnerUtils.ofIntegers(spinner, value, minimum, maximum, stepSize);
    }

    public JSpinner spinnerOfTime(JSpinner spinner) {
        return NullableSpinnerUtils.ofTime(spinner);
    }

    public JSpinner spinnerOfTime(JSpinner spinner, Time value) {
        return NullableSpinnerUtils.ofTime(spinner, value);
    }

    public Window findWindow(Component c) {
        if (c == null) {
            return JOptionPane.getRootFrame();
        }
        if (c instanceof Window) {
            return (Window)c;
        }
        return this.findWindow(c.getParent());
    }

    public Container findRootContainer(Component c) {
        if (c == null) {
            return JOptionPane.getRootFrame();
        }
        if (c instanceof Window) {
            return (Container)c;
        }
        if (c instanceof JInternalFrame) {
            return (Container)c;
        }
        return this.findRootContainer(c.getParent());
    }

    public boolean isModalDialogShowing() {
        Window[] windows = Window.getWindows();
        if (windows != null) {
            for (Window w : windows) {
                if (!w.isShowing() || !(w instanceof Dialog) || !((Dialog)w).isModal()) continue;
                return true;
            }
        }
        return false;
    }

    public void registerViewer(ViewerFactory factory) {
        if (factory == null) {
            return;
        }
        if (this.viewerfacories == null) {
            this.viewerfacories = new LinkedHashMap<String, ViewerFactory>();
        }
        this.viewerfacories.put(factory.getViewerName().toLowerCase(), factory);
    }

    public Collection<ViewerFactory> getViewerFactories() {
        return this.viewerfacories.values();
    }

    public ViewerFactory getViewerFactory(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        if (this.viewerfacories == null) {
            return null;
        }
        return this.viewerfacories.get(name.toLowerCase());
    }

    public JViewer getViewer(Object data) {
        for (ViewerFactory factory : this.getViewerFactories()) {
            if (!factory.isApplicable(new Object[]{data})) continue;
            JViewer viewer = factory.createViewer();
            viewer.setContents(data);
            return viewer;
        }
        return null;
    }

    public void addLineNumbers(JTextComponent text, JScrollPane scroll) {
        TextLineNumber tln = new TextLineNumber(text, scroll);
        tln.install();
    }

    public TextComponentUndoRedoHelper addUndoRedoSupport(JTextComponent text) {
        TextComponentUndoRedoHelperImpl helper = new TextComponentUndoRedoHelperImpl();
        if (text != null) {
            helper.install(text);
        }
        return helper;
    }

    public SearchToolbar addSearchToolbar(JTextComponent text) {
        SearchToolbarImpl searchToolbar = new SearchToolbarImpl();
        if (text != null) {
            searchToolbar.install(text);
        }
        return searchToolbar;
    }

    public void registerDesktopPanelSizeSupplier(Supplier<Dimension> supplier) {
        this.desktopPanelSizeSupplier = supplier;
    }

    public Dimension getDesktopPanelSize() {
        if (this.desktopPanelSizeSupplier == null) {
            GraphicsEnvironment lge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            DisplayMode dm = lge.getDefaultScreenDevice().getDisplayMode();
            Dimension screensize = new Dimension(dm.getWidth(), dm.getHeight());
            return screensize;
        }
        return this.desktopPanelSizeSupplier.get();
    }
}

