/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.dynclass;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultModeler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultModeler.class);
    private final Map<String, DynClass> dynClasses = new HashMap<String, DynClass>();

    public void loadModel(File model) {
        DynObjectManager dynObjectManager = ToolsLocator.getDynObjectManager();
        try {
            String xml = FileUtils.readFileToString((File)model);
            InputStream is = IOUtils.toInputStream((String)xml, (Charset)Charset.forName("UTF-8"));
            Map dynClasses = dynObjectManager.importDynClassDefinitions(is, this.getClass().getClassLoader());
            for (DynClass aDynClass : dynClasses.values()) {
                this.dynClasses.put(aDynClass.getName(), aDynClass);
            }
        }
        catch (Exception ex) {
            logger.warn("Can't load model from '" + model.getAbsolutePath() + "'.", (Throwable)ex);
        }
    }

    public Collection<DynClass> getClasses() {
        return this.dynClasses.values();
    }
}

